/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.console;

import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.Point;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import org.jetbrains.annotations.NotNull;

public final class MergedHorizontalScrollBarModel
extends DefaultBoundedRangeModel {
    private volatile boolean myInternalChange;
    private final JScrollBar myBar;
    private final EditorEx myFirstEditor;
    private final EditorEx mySecondEditor;
    private int myFirstValue;
    private int mySecondValue;

    public MergedHorizontalScrollBarModel(@NotNull JScrollBar bar, @NotNull EditorEx first2, @NotNull EditorEx second2) {
        if (bar == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(0);
        }
        if (first2 == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(1);
        }
        if (second2 == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(2);
        }
        this.myBar = bar;
        this.myFirstEditor = first2;
        this.mySecondEditor = second2;
        this.addChangeListener(event -> this.onChange());
        first2.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
        second2.getScrollPane().getViewport().addChangeListener(event -> this.onUpdate(event.getSource()));
    }

    private boolean isInternal() {
        return this.myInternalChange || !this.myFirstEditor.getComponent().isVisible() || !this.mySecondEditor.getComponent().isVisible();
    }

    private void onChange() {
        if (this.isInternal()) {
            return;
        }
        this.myInternalChange = true;
        MergedHorizontalScrollBarModel.setValue(this.myFirstEditor.getScrollPane().getViewport(), this.getValue());
        MergedHorizontalScrollBarModel.setValue(this.mySecondEditor.getScrollPane().getViewport(), this.getValue());
        this.myInternalChange = false;
    }

    private void onUpdate(Object source) {
        Point position;
        if (this.isInternal()) {
            return;
        }
        JViewport first2 = this.myFirstEditor.getScrollPane().getViewport();
        JViewport second2 = this.mySecondEditor.getScrollPane().getViewport();
        int value = this.getValue();
        if (source == first2) {
            position = first2.getViewPosition();
            if (position.x != this.myFirstValue) {
                this.myFirstValue = value = position.x;
            }
        } else {
            position = second2.getViewPosition();
            if (position.x != this.mySecondValue) {
                this.mySecondValue = value = position.x;
            }
        }
        int ext = Math.min(first2.getExtentSize().width, second2.getExtentSize().width);
        int max = Math.max(first2.getViewSize().width, second2.getViewSize().width);
        this.setRangeProperties(value, ext, 0, max, false);
        this.myBar.setEnabled(ext < max);
    }

    private static void setValue(JViewport viewport, int value) {
        Point position = viewport.getViewPosition();
        position.x = Math.max(0, Math.min(value, viewport.getViewSize().width - viewport.getExtentSize().width));
        viewport.setViewPosition(position);
    }

    public void setEnabled(boolean enabled) {
        this.myFirstEditor.getScrollPane().getHorizontalScrollBar().setEnabled(!enabled);
        this.mySecondEditor.getScrollPane().getHorizontalScrollBar().setEnabled(!enabled);
        this.myBar.setVisible(enabled);
    }

    @NotNull
    public static MergedHorizontalScrollBarModel create(@NotNull JScrollBar bar, @NotNull EditorEx first2, @NotNull EditorEx second2) {
        if (bar == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(3);
        }
        if (first2 == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(4);
        }
        if (second2 == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(5);
        }
        MergedHorizontalScrollBarModel model2 = new MergedHorizontalScrollBarModel(bar, first2, second2);
        bar.setModel(model2);
        model2.setEnabled(true);
        MergedHorizontalScrollBarModel mergedHorizontalScrollBarModel = model2;
        if (mergedHorizontalScrollBarModel == null) {
            MergedHorizontalScrollBarModel.$$$reportNull$$$0(6);
        }
        return mergedHorizontalScrollBarModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bar";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/console/MergedHorizontalScrollBarModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/console/MergedHorizontalScrollBarModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

