/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.dashboard.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.compound.CompoundRunConfiguration;
import com.intellij.execution.compound.SettingsAndEffectiveTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationNode;
import com.intellij.execution.dashboard.actions.RunDashboardActionUtils;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runToolbar.RunToolbarProcessData;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExecutorAction
extends DumbAwareAction {
    private static final Key<List<RunDashboardRunConfigurationNode>> RUNNABLE_LEAVES_KEY = Key.create("RUNNABLE_LEAVES_KEY");

    protected ExecutorAction() {
    }

    protected ExecutorAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ExecutorAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) == null) {
            this.update(e, false);
            return;
        }
        JBIterable<RunDashboardRunConfigurationNode> targetNodes = RunDashboardActionUtils.getLeafTargets(e);
        boolean running = targetNodes.filter(node2 -> {
            Content content2 = node2.getContent();
            return content2 != null && !RunContentManagerImpl.isTerminated((Content)content2);
        }).isNotEmpty();
        this.update(e, running);
        List<RunDashboardRunConfigurationNode> runnableLeaves = targetNodes.filter(this::canRun).toList();
        Presentation presentation2 = e.getPresentation();
        if (!runnableLeaves.isEmpty()) {
            presentation2.putClientProperty(RUNNABLE_LEAVES_KEY, runnableLeaves);
        }
        presentation2.setEnabled(!runnableLeaves.isEmpty());
    }

    private boolean canRun(@NotNull RunDashboardRunConfigurationNode node2) {
        if (node2 == null) {
            ExecutorAction.$$$reportNull$$$0(2);
        }
        ProgressManager.checkCanceled();
        Project project2 = node2.getProject();
        return this.canRun(node2.getConfigurationSettings(), null, DumbService.isDumb(project2));
    }

    private boolean canRun(RunnerAndConfigurationSettings settings, ExecutionTarget target2, boolean isDumb) {
        if (isDumb && !settings.getType().isDumbAware()) {
            return false;
        }
        String executorId = this.getExecutor().getId();
        RunConfiguration configuration = settings.getConfiguration();
        Project project2 = configuration.getProject();
        if (configuration instanceof CompoundRunConfiguration) {
            if (ExecutionTargetManager.getInstance((Project)project2).getTargetsFor(configuration).isEmpty()) {
                return false;
            }
            List subConfigurations = ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets();
            if (subConfigurations.isEmpty()) {
                return false;
            }
            RunManager runManager = RunManager.getInstance((Project)project2);
            for (SettingsAndEffectiveTarget subConfiguration : subConfigurations) {
                RunnerAndConfigurationSettings subSettings = runManager.findSettings(subConfiguration.getConfiguration());
                if (subSettings != null && this.canRun(subSettings, subConfiguration.getTarget(), isDumb)) continue;
                return false;
            }
            return true;
        }
        if (!ExecutorAction.isValid(settings)) {
            return false;
        }
        ProgramRunner runner = ProgramRunner.getRunner((String)executorId, (RunProfile)configuration);
        if (runner == null) {
            return false;
        }
        if (target2 == null ? (target2 = ExecutionTargetManager.getInstance((Project)project2).findTarget(configuration)) == null : !ExecutionTargetManager.canRun((RunConfiguration)configuration, (ExecutionTarget)target2)) {
            return false;
        }
        return !ExecutionManager.getInstance((Project)project2).isStarting(executorId, runner.getRunnerId());
    }

    private static boolean isValid(RunnerAndConfigurationSettings settings) {
        try {
            settings.checkSettings(null);
            return true;
        }
        catch (RuntimeConfigurationError ex) {
            return false;
        }
        catch (RuntimeConfigurationException | IndexNotReadyException ex) {
            return true;
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ExecutorAction.$$$reportNull$$$0(3);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        List runnableLeaves = (List)e.getPresentation().getClientProperty(RUNNABLE_LEAVES_KEY);
        if (runnableLeaves == null) {
            return;
        }
        for (RunDashboardRunConfigurationNode node2 : runnableLeaves) {
            this.run(node2.getConfigurationSettings(), null, node2.getDescriptor());
        }
    }

    private void run(RunnerAndConfigurationSettings settings, ExecutionTarget target2, RunContentDescriptor descriptor) {
        this.runSubProcess(settings, target2, descriptor, RunToolbarProcessData.prepareBaseSettingCustomization((RunnerAndConfigurationSettings)settings, null));
    }

    private void runSubProcess(RunnerAndConfigurationSettings settings, ExecutionTarget target2, RunContentDescriptor descriptor, @Nullable Consumer<? super ExecutionEnvironment> envCustomization) {
        RunConfiguration configuration = settings.getConfiguration();
        Project project2 = configuration.getProject();
        RunManager runManager = RunManager.getInstance((Project)project2);
        if (configuration instanceof CompoundRunConfiguration) {
            List subConfigurations = ((CompoundRunConfiguration)configuration).getConfigurationsWithEffectiveRunTargets();
            for (SettingsAndEffectiveTarget subConfiguration : subConfigurations) {
                RunnerAndConfigurationSettings subSettings = runManager.findSettings(subConfiguration.getConfiguration());
                if (subSettings == null) continue;
                this.runSubProcess(subSettings, subConfiguration.getTarget(), null, envCustomization);
            }
        } else {
            if (target2 == null) {
                target2 = ExecutionTargetManager.getInstance((Project)project2).findTarget(configuration);
                assert (target2 != null) : "No target for configuration of type " + configuration.getType().getDisplayName();
            }
            ProcessHandler processHandler = descriptor == null ? null : descriptor.getProcessHandler();
            ExecutionManager.getInstance((Project)project2).restartRunProfile(project2, this.getExecutor(), target2, settings, processHandler, RunToolbarProcessData.prepareSuppressMainSlotCustomization((Project)project2, envCustomization));
        }
    }

    protected abstract Executor getExecutor();

    protected abstract void update(@NotNull AnActionEvent var1, boolean var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/dashboard/actions/ExecutorAction";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/dashboard/actions/ExecutorAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

