/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.impl.TokenBuffer;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ConsoleTokenUtil {
    private static final char BACKSPACE = '\b';
    private static final Key<ConsoleViewContentType> CONTENT_TYPE = Key.create("ConsoleViewContentType");
    private static final Key<Boolean> USER_INPUT_SENT = Key.create("USER_INPUT_SENT");
    static final Key<Boolean> MANUAL_HYPERLINK = Key.create("MANUAL_HYPERLINK");

    ConsoleTokenUtil() {
    }

    private static void normalizeBackspaceCharacters(@NotNull StringBuilder text2) {
        int ind;
        if (text2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(0);
        }
        if ((ind = StringUtil.indexOf((CharSequence)text2, '\b')) < 0) {
            return;
        }
        int guardLength = 0;
        int newLength = 0;
        for (int i = 0; i < text2.length(); ++i) {
            boolean append;
            char ch = text2.charAt(i);
            if (ch == '\b') {
                assert (guardLength <= newLength);
                if (guardLength == newLength) {
                    append = guardLength == 0;
                } else {
                    boolean bl = append = text2.charAt(newLength - 1) == '\b';
                    if (!append) {
                        --newLength;
                    }
                }
            } else {
                append = true;
            }
            if (!append) continue;
            text2.setCharAt(newLength, ch);
            ++newLength;
            if (ch != '\r' && ch != '\n') continue;
            guardLength = newLength;
        }
        text2.setLength(newLength);
    }

    static int evaluateBackspacesInTokens(@NotNull List<? extends TokenBuffer.TokenInfo> source, int sourceStartIndex, @NotNull List<? super TokenBuffer.TokenInfo> dest) {
        if (source == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(1);
        }
        if (dest == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(2);
        }
        int backspacesFromNextToken = 0;
        for (int i = source.size() - 1; i >= sourceStartIndex; --i) {
            TokenBuffer.TokenInfo newToken;
            TokenBuffer.TokenInfo token = source.get(i);
            if (StringUtil.containsChar(token.getText(), '\b') || backspacesFromNextToken > 0) {
                StringBuilder tokenTextBuilder = new StringBuilder(token.getText().length() + backspacesFromNextToken);
                tokenTextBuilder.append(token.getText());
                StringUtil.repeatSymbol(tokenTextBuilder, '\b', backspacesFromNextToken);
                ConsoleTokenUtil.normalizeBackspaceCharacters(tokenTextBuilder);
                backspacesFromNextToken = ConsoleTokenUtil.getBackspacePrefixLength(tokenTextBuilder);
                String newText = tokenTextBuilder.substring(backspacesFromNextToken);
                newToken = new TokenBuffer.TokenInfo(token.contentType, newText, token.getHyperlinkInfo());
            } else {
                newToken = token;
            }
            dest.add((TokenBuffer.TokenInfo)newToken);
        }
        Collections.reverse(dest);
        return backspacesFromNextToken;
    }

    private static int getBackspacePrefixLength(@NotNull CharSequence text2) {
        if (text2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(3);
        }
        return StringUtil.countChars(text2, '\b', 0, true);
    }

    static ConsoleViewContentType getTokenType(@NotNull RangeMarker m) {
        if (m == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(4);
        }
        return m.getUserData(CONTENT_TYPE);
    }

    private static void saveTokenType(@NotNull RangeMarker m, @NotNull ConsoleViewContentType contentType) {
        if (m == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(5);
        }
        if (contentType == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(6);
        }
        m.putUserData(CONTENT_TYPE, contentType);
    }

    static RangeMarker findTokenMarker(@NotNull Editor editor2, @NotNull Project project2, int offset) {
        if (editor2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(7);
        }
        if (project2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeMarker[] marker = new RangeMarker[1];
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)project2, (boolean)true);
        model2.processRangeHighlightersOverlappingWith(offset, offset, m -> {
            if (ConsoleTokenUtil.getTokenType((RangeMarker)m) == null || m.getStartOffset() > offset || offset + 1 > m.getEndOffset()) {
                return true;
            }
            marker[0] = m;
            return false;
        });
        return marker[0];
    }

    static void createTokenRangeHighlighter(@NotNull Editor editor2, @NotNull Project project2, @NotNull ConsoleViewContentType contentType, int startOffset, int endOffset, boolean mergeWithThePreviousSameTypeToken) {
        if (editor2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(10);
        }
        if (contentType == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(11);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        MarkupModelEx model2 = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)project2, (boolean)true);
        int layer = 1001;
        if (mergeWithThePreviousSameTypeToken && startOffset > 0) {
            int prevMarkerEndOffset;
            RangeMarker prevMarker = ConsoleTokenUtil.findTokenMarker(editor2, project2, startOffset - 1);
            ConsoleViewContentType prevMarkerType = prevMarker == null ? null : ConsoleTokenUtil.getTokenType(prevMarker);
            int n = prevMarkerEndOffset = prevMarkerType == null ? -1 : prevMarker.getEndOffset();
            if (contentType.equals(prevMarkerType) && prevMarkerEndOffset >= 0 && prevMarkerEndOffset < editor2.getDocument().getTextLength() && editor2.getDocument().getCharsSequence().charAt(prevMarkerEndOffset - 1) != '\n') {
                startOffset = prevMarker.getStartOffset();
                prevMarker.dispose();
            }
        }
        model2.addRangeHighlighterAndChangeAttributes(contentType.getAttributesKey(), startOffset, endOffset, layer, HighlighterTargetArea.EXACT_RANGE, false, rm -> {
            if (rm.getTextAttributesKey() == null) {
                rm.setTextAttributes(contentType.getAttributes());
            }
            ConsoleTokenUtil.saveTokenType((RangeMarker)rm, contentType);
        });
    }

    static void updateAllTokenTextAttributes(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(13);
        }
        MarkupModel model2 = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)project2, (boolean)false);
        for (RangeHighlighter tokenMarker : model2.getAllHighlighters()) {
            ConsoleViewContentType contentType = ConsoleTokenUtil.getTokenType((RangeMarker)tokenMarker);
            if (contentType == null || contentType.getAttributesKey() != null || !(tokenMarker instanceof RangeHighlighterEx)) continue;
            ((RangeHighlighterEx)tokenMarker).setTextAttributes(contentType.getAttributes());
        }
    }

    @NotNull
    static CharSequence computeTextToSend(@NotNull Editor editor2, @NotNull Project project2) {
        if (editor2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(15);
        }
        StringBuilder textToSend = new StringBuilder();
        RangeMarker marker = ConsoleTokenUtil.findTokenMarker(editor2, project2, editor2.getCaretModel().getOffset() - 1);
        while (marker != null) {
            ConsoleViewContentType tokenType = ConsoleTokenUtil.getTokenType(marker);
            if (tokenType != null) {
                if (tokenType != ConsoleViewContentType.USER_INPUT || marker.getUserData(USER_INPUT_SENT) == Boolean.TRUE) break;
                marker.putUserData(USER_INPUT_SENT, true);
                textToSend.insert(0, marker.getDocument().getText(TextRange.create(marker)));
            }
            marker = ((RangeMarkerImpl)marker).findRangeMarkerBefore();
        }
        StringBuilder stringBuilder = textToSend;
        if (stringBuilder == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(16);
        }
        return stringBuilder;
    }

    static void highlightTokenTextAttributes(@NotNull Editor editor2, @NotNull Project project2, @NotNull List<? extends TokenBuffer.TokenInfo> tokens, @NotNull EditorHyperlinkSupport hyperlinks, @NotNull Collection<? super ConsoleViewContentType> contentTypes, @NotNull List<? super Pair<String, ConsoleViewContentType>> contents) {
        if (editor2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(18);
        }
        if (tokens == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(19);
        }
        if (hyperlinks == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(20);
        }
        if (contentTypes == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(21);
        }
        if (contents == null) {
            ConsoleTokenUtil.$$$reportNull$$$0(22);
        }
        int offset = editor2.getDocument().getTextLength();
        int tokenLength = 0;
        for (int i = tokens.size() - 1; i >= 0; --i) {
            int start2;
            TokenBuffer.TokenInfo prevToken;
            TokenBuffer.TokenInfo token = tokens.get(i);
            contentTypes.add((ConsoleViewContentType)token.contentType);
            contents.add(new Pair<String, ConsoleViewContentType>(token.getText(), token.contentType));
            TokenBuffer.TokenInfo tokenInfo = prevToken = i == 0 ? null : tokens.get(i - 1);
            if (prevToken != null && token.contentType == prevToken.contentType && token.getHyperlinkInfo() == prevToken.getHyperlinkInfo() || (start2 = Math.max(0, offset - (tokenLength += token.length()))) == offset) continue;
            HyperlinkInfo info = token.getHyperlinkInfo();
            if (info != null) {
                hyperlinks.createHyperlink(start2, offset, null, info).putUserData(MANUAL_HYPERLINK, (Object)true);
            }
            ConsoleTokenUtil.createTokenRangeHighlighter(editor2, project2, token.contentType, start2, offset, false);
            offset = start2;
            tokenLength = 0;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleTokenUtil";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinks";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentTypes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleTokenUtil";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeTextToSend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBackspaceCharacters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateBackspacesInTokens";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBackspacePrefixLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTokenType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveTokenType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findTokenMarker";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTokenRangeHighlighter";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateAllTokenTextAttributes";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeTextToSend";
                break;
            }
            case 16: {
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "highlightTokenTextAttributes";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

