/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConsoleState;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ProcessStreamsSynchronizer;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.ObjectUtils;
import com.pty4j.PtyProcess;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ConsoleViewRunningState
extends ConsoleState {
    private static final char LF = '\n';
    private final ConsoleViewImpl myConsole;
    private final ProcessHandler myProcessHandler;
    private final ConsoleState myFinishedStated;
    private final Writer myUserInputWriter;
    private final ProcessStreamsSynchronizer myStreamsSynchronizer;
    private final ProcessAdapter myProcessListener;

    public ConsoleViewRunningState(@NotNull ConsoleViewImpl console, @NotNull ProcessHandler processHandler, @NotNull ConsoleState finishedStated, boolean attachToStdOut, boolean attachToStdIn) {
        OutputStream processInput;
        if (console == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(1);
        }
        if (finishedStated == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(2);
        }
        this.myProcessListener = new ProcessAdapter(){

            @Override
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (outputType instanceof ProcessOutputType) {
                    ConsoleViewRunningState.this.myStreamsSynchronizer.doWhenStreamsSynchronized(event.getText(), (ProcessOutputType)outputType, () -> ConsoleViewRunningState.this.print(event.getText(), outputType));
                } else {
                    ConsoleViewRunningState.this.print(event.getText(), outputType);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/execution/impl/ConsoleViewRunningState$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myConsole = console;
        this.myProcessHandler = processHandler;
        this.myFinishedStated = finishedStated;
        ProcessStreamsSynchronizer processStreamsSynchronizer = this.myStreamsSynchronizer = attachToStdOut ? new ProcessStreamsSynchronizer((Disposable)((Object)console)) : null;
        if (attachToStdOut) {
            processHandler.addProcessListener(this.myProcessListener);
        }
        this.myUserInputWriter = attachToStdIn ? ((processInput = this.myProcessHandler.getProcessInput()) == null ? null : ConsoleViewRunningState.createOutputStreamWriter(processInput, processHandler)) : null;
    }

    private static OutputStreamWriter createOutputStreamWriter(OutputStream processInput, ProcessHandler processHandler) {
        Charset charset = null;
        if (processHandler instanceof OSProcessHandler) {
            charset = ((OSProcessHandler)processHandler).getCharset();
        }
        if (charset == null) {
            charset = EncodingManager.getInstance().getDefaultCharset();
        }
        return new OutputStreamWriter(processInput, charset);
    }

    private void print(@NotNull String text2, @NotNull Key<?> outputType) {
        if (text2 == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(4);
        }
        this.myConsole.print(text2, ConsoleViewContentType.getConsoleViewType(outputType));
    }

    @Override
    @NotNull
    public ConsoleState dispose() {
        if (this.myProcessHandler != null) {
            this.myProcessHandler.removeProcessListener(this.myProcessListener);
        }
        ConsoleState consoleState = this.myFinishedStated;
        if (consoleState == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(5);
        }
        return consoleState;
    }

    @Override
    public boolean isCommandLine(@NotNull String line) {
        if (line == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(6);
        }
        return this.myProcessHandler instanceof BaseProcessHandler && line.equals(((BaseProcessHandler)this.myProcessHandler).getCommandLine());
    }

    @Override
    public boolean isFinished() {
        return this.myProcessHandler == null || this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public boolean isRunning() {
        return this.myProcessHandler != null && !this.myProcessHandler.isProcessTerminated();
    }

    @Override
    public void sendUserInput(@NotNull String input) throws IOException {
        if (input == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(7);
        }
        if (this.myUserInputWriter == null) {
            throw new IOException(ExecutionBundle.message((String)"no.user.process.input.error.message", (Object[])new Object[0]));
        }
        char enterKeyCode = this.getEnterKeyCode();
        String inputToSend = input.replace('\n', enterKeyCode);
        this.myUserInputWriter.write(inputToSend);
        this.myUserInputWriter.flush();
    }

    private char getEnterKeyCode() {
        PtyProcess process2;
        if (this.myProcessHandler instanceof BaseProcessHandler && (process2 = ObjectUtils.tryCast(((BaseProcessHandler)this.myProcessHandler).getProcess(), PtyProcess.class)) != null) {
            return (char)process2.getEnterKeyCode();
        }
        return '\n';
    }

    @Override
    @NotNull
    public ConsoleState attachTo(@NotNull ConsoleViewImpl console, @NotNull ProcessHandler processHandler) {
        if (console == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(8);
        }
        if (processHandler == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(9);
        }
        ConsoleState consoleState = this.dispose().attachTo(console, processHandler);
        if (consoleState == null) {
            ConsoleViewRunningState.$$$reportNull$$$0(10);
        }
        return consoleState;
    }

    @TestOnly
    @Nullable
    ProcessStreamsSynchronizer getStreamsSynchronizer() {
        return this.myStreamsSynchronizer;
    }

    public String toString() {
        return "Running state";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finishedStated";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/ConsoleViewRunningState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/ConsoleViewRunningState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "dispose";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "attachTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sendUserInput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "attachTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

