/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.PositionTracker;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RerunTestsNotification {
    private static final String KEY = "rerun.tests.notification.shown";

    public static void showRerunNotification(@Nullable RunContentDescriptor contentToReuse, @NotNull ExecutionConsole executionConsole) {
        boolean showNotification;
        if (executionConsole == null) {
            RerunTestsNotification.$$$reportNull$$$0(0);
        }
        if (contentToReuse == null) {
            return;
        }
        String lastActionId = ActionManagerEx.getInstanceEx().getPrevPreformedActionId();
        boolean bl = showNotification = !"RerunTests".equals(lastActionId);
        if (showNotification && !PropertiesComponent.getInstance().isTrueValue(KEY)) {
            UiNotifyConnector.doWhenFirstShown((JComponent)executionConsole.getComponent(), () -> RerunTestsNotification.doShow(executionConsole));
        }
    }

    private static void doShow(@NotNull ExecutionConsole executionConsole) {
        if (executionConsole == null) {
            RerunTestsNotification.$$$reportNull$$$0(1);
        }
        EdtExecutorService.getScheduledExecutorInstance().schedule(() -> {
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("RerunTests"));
            if (shortcutText.isEmpty()) {
                return;
            }
            ConsoleView consoleView = UIUtil.findComponentOfType(executionConsole.getComponent(), ConsoleViewImpl.class);
            if (consoleView != null) {
                GotItMessage message2 = GotItMessage.createMessage((String)ExecutionBundle.message((String)"popup.content.rerun.tests.with", (Object[])new Object[]{shortcutText}), (String)"");
                final Disposable disposable = Disposer.newDisposable();
                Disposer.register((Disposable)executionConsole, disposable);
                message2.setDisposable(disposable);
                message2.setCallback(() -> PropertiesComponent.getInstance().setValue(KEY, true));
                message2.setShowCallout(false);
                final JComponent consoleComponent = consoleView.getComponent();
                message2.show((PositionTracker)new PositionTracker<Balloon>((Component)consoleComponent){

                    @Override
                    public RelativePoint recalculateLocation(@NotNull Balloon balloon) {
                        if (balloon == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        RelativePoint point = RelativePoint.getSouthEastOf(consoleComponent);
                        JBInsets shadowInsets = balloon instanceof BalloonImpl ? ((BalloonImpl)balloon).getShadowBorderInsets() : JBInsets.emptyInsets();
                        JBDimension balloonContentSize = JBDimension.create(balloon.getPreferredSize(), true);
                        JBInsets.removeFrom(balloonContentSize, (Insets)shadowInsets);
                        point.getPoint().y += shadowInsets.top;
                        int spacingFromEdges = JBUIScale.scale(12);
                        point.getPoint().translate(-balloonContentSize.width / 2 - spacingFromEdges, -balloonContentSize.height / 2 - spacingFromEdges);
                        return point;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/execution/runners/RerunTestsNotification$1", "recalculateLocation"));
                    }
                }, Balloon.Position.below);
                consoleComponent.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if (!consoleComponent.isShowing()) {
                            Disposer.dispose(disposable);
                            consoleComponent.removeHierarchyListener(this);
                        }
                    }
                });
            }
        }, 1000L, TimeUnit.MILLISECONDS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "executionConsole";
        objectArray2[1] = "com/intellij/execution/runners/RerunTestsNotification";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showRerunNotification";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doShow";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

