/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.changes.issueLinks.LinkMouseListenerBase;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public abstract class RepaintLinkMouseListenerBase<T>
extends LinkMouseListenerBase<T> {
    public static final Key<Object> ACTIVE_TAG = Key.create("RepaintLinkMouseListenerActiveTag");

    public void mouseMoved(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        JComponent component2 = (JComponent)e.getSource();
        Object tag = this.getTagAt(e);
        UIUtil.setCursor(component2, tag != null ? Cursor.getPredefinedCursor(12) : Cursor.getDefaultCursor());
        if (!Comparing.equal(tag, ComponentUtil.getClientProperty(component2, ACTIVE_TAG))) {
            ComponentUtil.putClientProperty(component2, ACTIVE_TAG, tag);
            this.repaintComponent(e);
        }
    }

    public void installOn(@NotNull Component component2) {
        if (component2 == null) {
            RepaintLinkMouseListenerBase.$$$reportNull$$$0(0);
        }
        if (!(component2 instanceof JComponent)) {
            throw new IllegalArgumentException("JComponent expected");
        }
        super.installOn(component2);
        component2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                JComponent component2 = (JComponent)e.getSource();
                Object tag = ComponentUtil.getClientProperty(component2, ACTIVE_TAG);
                if (tag != null) {
                    ComponentUtil.putClientProperty(component2, ACTIVE_TAG, null);
                    RepaintLinkMouseListenerBase.this.repaintComponent(e);
                }
            }
        });
    }

    protected abstract void repaintComponent(MouseEvent var1);

    protected boolean isEnabled() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/execution/services/RepaintLinkMouseListenerBase", "installOn"));
    }
}

