/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.util.ObjectUtils;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ServiceEventListener {
    public static final Topic<ServiceEventListener> TOPIC = Topic.create("services topic", ServiceEventListener.class, Topic.BroadcastDirection.TO_CHILDREN);
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final Object POLLING_RESET_TARGET = ObjectUtils.sentinel("pollingResetTarget");

    public void handle(@NotNull ServiceEvent var1);

    public static enum EventType {
        RESET,
        SYNC_RESET,
        SERVICE_ADDED,
        SERVICE_REMOVED,
        SERVICE_CHANGED,
        SERVICE_STRUCTURE_CHANGED,
        SERVICE_GROUP_CHANGED,
        GROUP_CHANGED;

    }

    public static final class ServiceEvent {
        public final EventType type;
        public final Object target;
        public final Class<?> contributorClass;
        public final Object parent;

        private ServiceEvent(@NotNull EventType type, @NotNull Object target2, @NotNull Class<?> contributorClass) {
            if (type == null) {
                ServiceEvent.$$$reportNull$$$0(0);
            }
            if (target2 == null) {
                ServiceEvent.$$$reportNull$$$0(1);
            }
            if (contributorClass == null) {
                ServiceEvent.$$$reportNull$$$0(2);
            }
            this(type, target2, contributorClass, null);
        }

        private ServiceEvent(@NotNull EventType type, @NotNull Object target2, @NotNull Class<?> contributorClass, @Nullable Object parent) {
            if (type == null) {
                ServiceEvent.$$$reportNull$$$0(3);
            }
            if (target2 == null) {
                ServiceEvent.$$$reportNull$$$0(4);
            }
            if (contributorClass == null) {
                ServiceEvent.$$$reportNull$$$0(5);
            }
            this.type = type;
            this.target = target2;
            this.contributorClass = contributorClass;
            this.parent = parent;
        }

        public String toString() {
            return this.type + ": " + this.target.toString() + "; from contributor: " + this.contributorClass + (String)(this.parent == null ? "" : "; parent: " + this.parent);
        }

        public static ServiceEvent createEvent(@NotNull EventType type, @NotNull Object target2, @NotNull Class<?> rootContributorClass) {
            if (type == null) {
                ServiceEvent.$$$reportNull$$$0(6);
            }
            if (target2 == null) {
                ServiceEvent.$$$reportNull$$$0(7);
            }
            if (rootContributorClass == null) {
                ServiceEvent.$$$reportNull$$$0(8);
            }
            return new ServiceEvent(type, target2, rootContributorClass);
        }

        public static ServiceEvent createResetEvent(@NotNull Class<?> rootContributorClass) {
            if (rootContributorClass == null) {
                ServiceEvent.$$$reportNull$$$0(9);
            }
            return new ServiceEvent(EventType.RESET, rootContributorClass, rootContributorClass);
        }

        public static ServiceEvent createSyncResetEvent(@NotNull Class<?> rootContributorClass) {
            if (rootContributorClass == null) {
                ServiceEvent.$$$reportNull$$$0(10);
            }
            return new ServiceEvent(EventType.SYNC_RESET, rootContributorClass, rootContributorClass);
        }

        public static ServiceEvent createServiceAddedEvent(@NotNull Object target2, @NotNull Class<?> contributorClass, @Nullable Object parent) {
            if (target2 == null) {
                ServiceEvent.$$$reportNull$$$0(11);
            }
            if (contributorClass == null) {
                ServiceEvent.$$$reportNull$$$0(12);
            }
            return new ServiceEvent(EventType.SERVICE_ADDED, target2, contributorClass, parent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: 
                case 4: 
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: 
                case 5: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributorClass";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootContributorClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceEventListener$ServiceEvent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createEvent";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createResetEvent";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createSyncResetEvent";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createServiceAddedEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

