/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewDragHelper;
import com.intellij.execution.services.ServiceViewGroupingContributor;
import com.intellij.execution.services.ServiceViewLazyContributor;
import com.intellij.execution.services.ServiceViewOptions;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.WeighedItem;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullizer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.TreeTraversal;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promises;

final class ServiceModel
implements Disposable,
InvokerSupplier {
    private static final Logger LOG = Logger.getInstance(ServiceModel.class);
    static final TreeTraversal NOT_LOADED_LAST_BFS = new TreeTraversal("NOT_LOADED_LAST_BFS"){

        @Override
        @NotNull
        public <T> TreeTraversal.It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                1.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                1.$$$reportNull$$$0(1);
            }
            return new NotLoadedLastBfsIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/services/ServiceModel$1";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    static final TreeTraversal ONLY_LOADED_BFS = new TreeTraversal("ONLY_LOADED_BFS"){

        @Override
        @NotNull
        public <T> TreeTraversal.It<T> createIterator(@NotNull Iterable<? extends T> roots2, @NotNull Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                2.$$$reportNull$$$0(0);
            }
            if (tree == null) {
                2.$$$reportNull$$$0(1);
            }
            return new OnlyLoadedBfsIt<T>(roots2, tree);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tree";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/services/ServiceModel$2";
            objectArray[2] = "createIterator";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NotNullizer ourNotNullizer = new NotNullizer("ServiceViewTreeTraversal.NotNull");
    private final Project myProject;
    private final Invoker myInvoker;
    private final List<ServiceViewItem> myRoots;
    private volatile boolean myRootsInitialized;
    private final List<ServiceModelEventListener> myListeners;

    ServiceModel(@NotNull Project project2) {
        if (project2 == null) {
            ServiceModel.$$$reportNull$$$0(0);
        }
        this.myInvoker = Invoker.forBackgroundThreadWithoutReadAction((Disposable)this);
        this.myRoots = new CopyOnWriteArrayList<ServiceViewItem>();
        this.myListeners = new CopyOnWriteArrayList<ServiceModelEventListener>();
        this.myProject = project2;
    }

    @Override
    public void dispose() {
    }

    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.myInvoker;
        if (invoker == null) {
            ServiceModel.$$$reportNull$$$0(1);
        }
        return invoker;
    }

    void addEventListener(@NotNull ServiceModelEventListener listener2) {
        if (listener2 == null) {
            ServiceModel.$$$reportNull$$$0(2);
        }
        this.myListeners.add(listener2);
    }

    void removeEventListener(@NotNull ServiceModelEventListener listener2) {
        if (listener2 == null) {
            ServiceModel.$$$reportNull$$$0(3);
        }
        this.myListeners.remove(listener2);
    }

    @NotNull
    List<? extends ServiceViewItem> getRoots() {
        List<Object> list2 = this.myRootsInitialized ? this.myRoots : Collections.emptyList();
        if (list2 == null) {
            ServiceModel.$$$reportNull$$$0(4);
        }
        return list2;
    }

    CancellablePromise<?> initRoots() {
        return this.getInvoker().invoke(() -> {
            if (!this.myRootsInitialized) {
                this.myRoots.addAll(this.doGetRoots());
                this.myRootsInitialized = true;
            }
        });
    }

    private List<? extends ServiceViewItem> doGetRoots() {
        ArrayList<ContributorNode> result2 = new ArrayList<ContributorNode>();
        for (ServiceViewContributor<?> contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
            try {
                ContributorNode root = new ContributorNode(this.myProject, contributor);
                root.loadChildren();
                if (root.getChildren().isEmpty()) continue;
                result2.add(root);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                PluginException.logPluginError(LOG, "Failed to init service view contributor " + contributor.getClass(), e, contributor.getClass());
            }
        }
        return result2;
    }

    private JBIterable<ServiceViewItem> findItems(Object service2, Class<?> contributorClass) {
        Object value = service2 instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service2).asService() : service2;
        return ((JBTreeTraverser)JBTreeTraverser.from(node2 -> contributorClass.isInstance(node2.getRootContributor()) ? new ArrayList<ServiceViewItem>(node2.getChildren()) : null).withRoots((Iterable<ServiceViewItem>)this.myRoots)).traverse(NOT_LOADED_LAST_BFS).filter(node2 -> node2.getValue().equals(value));
    }

    @Nullable
    ServiceViewItem findItem(Condition<? super ServiceViewItem> condition, Condition<? super ServiceViewItem> visitChildrenCondition) {
        return ((JBTreeTraverser)JBTreeTraverser.from(node2 -> visitChildrenCondition.value((ServiceViewItem)node2) ? new ArrayList<ServiceViewItem>(node2.getChildren()) : null).withRoots((Iterable<ServiceViewItem>)this.myRoots)).traverse(NOT_LOADED_LAST_BFS).filter(condition).first();
    }

    @Nullable
    ServiceViewItem findItem(Object service2, Class<?> contributorClass) {
        return this.findItems(service2, contributorClass).first();
    }

    @Nullable
    ServiceViewItem findItemById(List<String> ids, ServiceViewContributor<?> contributor) {
        if (ids.isEmpty()) {
            return null;
        }
        List<ServiceViewItem> roots2 = ContainerUtil.filter(this.getRoots(), item -> contributor.equals(item.getContributor()));
        if (roots2.isEmpty()) {
            return null;
        }
        return ServiceModel.findItemById(new LinkedList<String>(ids), roots2);
    }

    private static ServiceViewItem findItemById(Deque<String> path2, List<? extends ServiceViewItem> roots2) {
        String id2 = path2.removeFirst();
        for (ServiceViewItem serviceViewItem : roots2) {
            if (!id2.equals(serviceViewItem.getViewDescriptor().getId())) continue;
            return path2.isEmpty() ? serviceViewItem : ServiceModel.findItemById(path2, serviceViewItem.getChildren());
        }
        return null;
    }

    @NotNull
    CancellablePromise<?> handle(@NotNull ServiceEventListener.ServiceEvent e) {
        if (e == null) {
            ServiceModel.$$$reportNull$$$0(5);
        }
        Runnable handler = () -> {
            LOG.debug("Handle event: " + e);
            switch (e.type) {
                case SERVICE_ADDED: {
                    this.addService(e);
                    break;
                }
                case SERVICE_REMOVED: {
                    this.removeService(e);
                    break;
                }
                case SERVICE_CHANGED: {
                    this.serviceChanged(e);
                    break;
                }
                case SERVICE_STRUCTURE_CHANGED: {
                    this.serviceStructureChanged(e);
                    break;
                }
                case SERVICE_GROUP_CHANGED: {
                    this.serviceGroupChanged(e);
                    break;
                }
                case GROUP_CHANGED: {
                    this.groupChanged(e);
                    break;
                }
                default: {
                    this.reset(e.contributorClass);
                }
            }
            for (ServiceModelEventListener listener2 : this.myListeners) {
                listener2.eventProcessed(e);
            }
        };
        if (e.type != ServiceEventListener.EventType.SYNC_RESET) {
            CancellablePromise cancellablePromise = this.getInvoker().invoke(handler);
            if (cancellablePromise == null) {
                ServiceModel.$$$reportNull$$$0(6);
            }
            return cancellablePromise;
        }
        handler.run();
        CancellablePromise cancellablePromise = Promises.resolvedCancellablePromise(null);
        if (cancellablePromise == null) {
            ServiceModel.$$$reportNull$$$0(7);
        }
        return cancellablePromise;
    }

    private void reset(Class<?> contributorClass) {
        int index = -1;
        if (this.myRoots.isEmpty()) {
            index = 0;
        } else {
            ServiceViewItem contributorNode = null;
            for (int i = 0; i < this.myRoots.size(); ++i) {
                ServiceViewItem child = this.myRoots.get(i);
                if (!contributorClass.isInstance(child.getContributor())) continue;
                contributorNode = child;
                index = i;
                break;
            }
            if (contributorNode != null) {
                this.myRoots.remove(contributorNode);
            } else {
                index = this.getContributorNodeIndex(contributorClass);
            }
        }
        ContributorNode newRoot = null;
        for (ServiceViewContributor<?> contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
            if (!contributorClass.isInstance(contributor)) continue;
            newRoot = new ContributorNode(this.myProject, contributor);
            newRoot.loadChildren();
            if (!newRoot.getChildren().isEmpty()) break;
            newRoot = null;
            break;
        }
        if (newRoot != null) {
            this.myRoots.add(index, newRoot);
        }
    }

    private int getContributorNodeIndex(Class<?> contributorClass) {
        ServiceViewContributor<?> contributor;
        int index = -1;
        List<ServiceViewContributor<?>> contributors = ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList();
        List<ServiceViewContributor> existingContributors = ContainerUtil.map(this.myRoots, ServiceViewItem::getContributor);
        for (int i = contributors.size() - 1; i >= 0 && !contributorClass.isInstance(contributor = contributors.get(i)) && (index = existingContributors.indexOf(contributor)) != 0; --i) {
        }
        if (index < 0) {
            index = this.myRoots.size();
        }
        return index;
    }

    private void addService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item != null) {
            return;
        }
        if (e.parent != null) {
            ServiceViewContributor<?> parentContributor;
            ServiceViewItem parent = this.findItem(e.parent, e.contributorClass);
            ServiceViewContributor<?> serviceViewContributor = parentContributor = parent instanceof ServiceNode ? ((ServiceNode)parent).getProvidingContributor() : null;
            if (parentContributor == null) {
                return;
            }
            ServiceModel.addService(e.target, parent.getChildren(), this.myProject, parent, parentContributor);
            return;
        }
        ServiceViewItem contributorNode = null;
        for (ServiceViewItem child : this.myRoots) {
            if (!e.contributorClass.isInstance(child.getContributor())) continue;
            contributorNode = child;
            break;
        }
        if (contributorNode == null) {
            int index = this.getContributorNodeIndex(e.contributorClass);
            for (ServiceViewContributor<?> contributor : ServiceViewContributor.CONTRIBUTOR_EP_NAME.getExtensionList()) {
                if (!e.contributorClass.isInstance(contributor)) continue;
                contributorNode = new ContributorNode(this.myProject, contributor);
                this.myRoots.add(index, contributorNode);
                break;
            }
            if (contributorNode == null) {
                return;
            }
        }
        ServiceModel.addService(e.target, contributorNode.getChildren(), this.myProject, contributorNode, contributorNode.getContributor());
    }

    private void removeService(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item == null) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        while (parent instanceof ServiceGroupNode) {
            item.markRemoved();
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        if (parent instanceof ContributorNode) {
            item.markRemoved();
            parent.getChildren().remove(item);
            if (!parent.getChildren().isEmpty()) {
                return;
            }
            item = parent;
            parent = parent.getParent();
        }
        item.markRemoved();
        if (parent == null) {
            this.myRoots.remove(item);
        } else {
            parent.getChildren().remove(item);
        }
    }

    private void serviceChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceModel.updateServiceViewDescriptor((ServiceNode)item, e.target);
        }
    }

    private static void updateServiceViewDescriptor(ServiceNode node2, Object target2) {
        ServiceViewContributor<?> providingContributor = node2.getProvidingContributor();
        if (providingContributor != null && !providingContributor.equals(target2)) {
            node2.setViewDescriptor(providingContributor.getViewDescriptor(node2.myProject));
            return;
        }
        ServiceViewDescriptor viewDescriptor = node2.getContributor().getServiceDescriptor(node2.myProject, target2);
        node2.setViewDescriptor(viewDescriptor);
    }

    private void serviceStructureChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (item instanceof ServiceNode) {
            ServiceNode node2 = (ServiceNode)item;
            ServiceModel.updateServiceViewDescriptor(node2, e.target);
            node2.reloadChildren();
        }
    }

    private void serviceGroupChanged(ServiceEventListener.ServiceEvent e) {
        ServiceViewItem item = this.findItem(e.target, e.contributorClass);
        if (!(item instanceof ServiceNode)) {
            return;
        }
        ServiceViewItem parent = item.getParent();
        if (parent == null) {
            return;
        }
        ServiceGroupNode group = null;
        if (parent instanceof ServiceGroupNode) {
            group = (ServiceGroupNode)parent;
            parent = group.getParent();
            while (parent instanceof ServiceGroupNode) {
                parent = parent.getParent();
            }
            if (parent == null) {
                return;
            }
        }
        if (group != null) {
            group.getChildren().remove(item);
        } else {
            parent.getChildren().remove(item);
        }
        ServiceViewContributor<?> value = e.target;
        ServiceViewContributor<?> providingContributor = ((ServiceNode)item).getProvidingContributor();
        if (providingContributor != null && !providingContributor.equals(e.target)) {
            value = providingContributor;
        }
        ServiceNode serviceNode = ServiceModel.addService(value, parent.getChildren(), this.myProject, parent, item.getContributor());
        serviceNode.moveChildren((ServiceNode)item);
        while (group != null && group.getChildren().isEmpty()) {
            ServiceViewItem groupParent = group.getParent();
            if (groupParent == null) {
                return;
            }
            groupParent.getChildren().remove(group);
            group = groupParent instanceof ServiceGroupNode ? (ServiceGroupNode)groupParent : null;
        }
    }

    private void groupChanged(ServiceEventListener.ServiceEvent e) {
        JBIterable<ServiceGroupNode> groups2 = this.findItems(e.target, e.contributorClass).filter(ServiceGroupNode.class);
        ServiceGroupNode first2 = groups2.first();
        if (first2 == null) {
            return;
        }
        ServiceViewDescriptor viewDescriptor = ((ServiceViewGroupingContributor)first2.getContributor()).getGroupDescriptor(e.target);
        for (ServiceViewItem serviceViewItem : groups2) {
            serviceViewItem.setViewDescriptor(viewDescriptor);
            ServiceViewItem parent = serviceViewItem.getParent();
            if (parent == null) continue;
            List<ServiceViewItem> children2 = parent.getChildren();
            children2.remove(serviceViewItem);
            ServiceModel.addGroupOrdered(children2, (ServiceGroupNode)serviceViewItem);
        }
    }

    private static <T> List<ServiceViewItem> getContributorChildren(Project project2, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ArrayList<ServiceViewItem> children2 = new ArrayList<ServiceViewItem>();
        try {
            for (T service2 : contributor.getServices(project2)) {
                ServiceModel.addService(service2, children2, project2, parent, contributor);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            PluginException.logPluginError(LOG, "Failed to retrieve service view contributor children " + contributor.getClass(), e, contributor.getClass());
        }
        return children2;
    }

    private static <T> ServiceNode addService(Object service2, List<ServiceViewItem> children2, Project project2, ServiceViewItem parent, ServiceViewContributor<T> contributor) {
        ServiceNode serviceNode;
        Object value;
        Object typedService = service2;
        Object object = value = service2 instanceof ServiceViewProvidingContributor ? ((ServiceViewProvidingContributor)service2).asService() : service2;
        if (contributor instanceof ServiceViewGroupingContributor && (serviceNode = ServiceModel.addGroupNode((ServiceViewGroupingContributor)contributor, typedService, value, parent, project2, children2)) != null) {
            return serviceNode;
        }
        serviceNode = new ServiceNode(value, parent, contributor, contributor.getServiceDescriptor(project2, typedService), project2, service2 instanceof ServiceViewContributor ? (ServiceViewContributor)service2 : null);
        ServiceModel.addServiceOrdered(children2, serviceNode, contributor);
        return serviceNode;
    }

    private static <T, G> ServiceNode addGroupNode(ServiceViewGroupingContributor<T, G> groupingContributor, T service2, Object value, ServiceViewItem parent, Project project2, List<ServiceViewItem> children2) {
        List<G> groups2 = groupingContributor.getGroups(service2);
        if (groups2.isEmpty()) {
            return null;
        }
        List<ServiceViewItem> currentChildren = children2;
        ServiceViewItem groupParent = parent;
        for (G group : groups2) {
            boolean found2 = false;
            for (ServiceViewItem child : currentChildren) {
                if (!child.getValue().equals(group)) continue;
                groupParent = child;
                currentChildren = groupParent.getChildren();
                found2 = true;
                break;
            }
            if (found2) continue;
            ServiceGroupNode groupNode = new ServiceGroupNode(group, groupParent, groupingContributor, groupingContributor.getGroupDescriptor(group));
            ServiceModel.addGroupOrdered(currentChildren, groupNode);
            groupParent = groupNode;
            currentChildren = groupParent.getChildren();
        }
        ServiceNode serviceNode = new ServiceNode(value, groupParent, groupingContributor, groupingContributor.getServiceDescriptor(project2, service2), project2, service2 instanceof ServiceViewContributor ? (ServiceViewContributor)service2 : null);
        ServiceModel.addServiceOrdered(currentChildren, serviceNode, groupingContributor);
        return serviceNode;
    }

    private static void addServiceOrdered(List<ServiceViewItem> children2, ServiceNode child, ServiceViewContributor<?> contributor) {
        if (!children2.isEmpty() && contributor instanceof Comparator) {
            Comparator comparator2 = (Comparator)((Object)contributor);
            for (int i = 0; i < children2.size(); ++i) {
                ServiceViewItem anchor = children2.get(i);
                if (!(anchor instanceof ServiceNode) || comparator2.compare(child.getService(), ((ServiceNode)anchor).getService()) >= 0) continue;
                children2.add(i, child);
                return;
            }
        }
        children2.add(child);
    }

    private static void addGroupOrdered(List<ServiceViewItem> children2, ServiceGroupNode child) {
        if (!children2.isEmpty()) {
            for (int i = 0; i < children2.size(); ++i) {
                ServiceViewItem anchor = children2.get(i);
                if (anchor instanceof ServiceNode) {
                    children2.add(i, child);
                    return;
                }
                if (!(anchor instanceof ServiceGroupNode) || ServiceModel.compareGroups(child, (ServiceGroupNode)anchor) >= 0) continue;
                children2.add(i, child);
                return;
            }
        }
        children2.add(child);
    }

    private static int compareGroups(ServiceGroupNode group1, ServiceGroupNode group2) {
        ServiceViewDescriptor groupDescriptor1 = group1.getViewDescriptor();
        WeighedItem weighedItem1 = ObjectUtils.tryCast(groupDescriptor1, WeighedItem.class);
        ServiceViewDescriptor groupDescriptor2 = group2.getViewDescriptor();
        WeighedItem weighedItem2 = ObjectUtils.tryCast(groupDescriptor2, WeighedItem.class);
        if (weighedItem1 != null) {
            if (weighedItem2 == null) {
                return -1;
            }
            int diff = weighedItem1.getWeight() - weighedItem2.getWeight();
            if (diff != 0) {
                return diff;
            }
        } else if (weighedItem2 != null) {
            return 1;
        }
        String name1 = ServiceViewDragHelper.getDisplayName(groupDescriptor1.getPresentation());
        String name2 = ServiceViewDragHelper.getDisplayName(groupDescriptor2.getPresentation());
        return StringUtil.naturalCompare(name1, name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "handle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addEventListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeEventListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handle";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class OnlyLoadedBfsIt<T>
    extends TreeTraversal.It<T> {
        Deque<T> myQueue;
        T myTop;

        OnlyLoadedBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                OnlyLoadedBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.myQueue = new ArrayDeque<T>();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.myQueue);
        }

        @Override
        public T nextImpl() {
            if (this.myTop != null) {
                Iterable iterable;
                if ((!(this.myTop instanceof ServiceNode) || ((ServiceNode)this.myTop).isChildrenInitialized() || ((ServiceNode)this.myTop).isLoaded()) && (iterable = (Iterable)this.tree.fun(this.myTop)) != null) {
                    JBIterable.from(iterable).map(ourNotNullizer::notNullize).addAllTo(this.myQueue);
                }
                this.myTop = null;
            }
            if (this.myQueue.isEmpty()) {
                return (T)this.stop();
            }
            this.myTop = ourNotNullizer.nullize(this.myQueue.remove());
            return this.myTop;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/execution/services/ServiceModel$OnlyLoadedBfsIt", "<init>"));
        }
    }

    private static final class NotLoadedLastBfsIt<T>
    extends TreeTraversal.It<T> {
        Deque<T> myQueue;
        Deque<T> myNotLoadedQueue;
        T myTop;

        NotLoadedLastBfsIt(@NotNull Iterable<? extends T> roots2, Function<? super T, ? extends Iterable<? extends T>> tree) {
            if (roots2 == null) {
                NotLoadedLastBfsIt.$$$reportNull$$$0(0);
            }
            super(tree);
            this.myQueue = new ArrayDeque<T>();
            this.myNotLoadedQueue = new ArrayDeque<T>();
            JBIterable.from(roots2).map(ourNotNullizer::notNullize).addAllTo(this.myQueue);
        }

        @Override
        public T nextImpl() {
            if (this.myTop != null) {
                if (this.myTop instanceof ServiceNode && !((ServiceNode)this.myTop).isChildrenInitialized() && !((ServiceNode)this.myTop).isLoaded()) {
                    this.myNotLoadedQueue.add(this.myTop);
                } else {
                    Iterable iterable = (Iterable)this.tree.fun(this.myTop);
                    if (iterable != null) {
                        JBIterable.from(iterable).map(ourNotNullizer::notNullize).addAllTo(this.myQueue);
                    }
                }
                this.myTop = null;
            }
            while (!this.myNotLoadedQueue.isEmpty() && this.myQueue.isEmpty()) {
                T notLoaded = this.myNotLoadedQueue.remove();
                Iterable iterable = (Iterable)this.tree.fun(notLoaded);
                if (iterable == null) continue;
                JBIterable.from(iterable).map(ourNotNullizer::notNullize).addAllTo(this.myQueue);
            }
            if (this.myQueue.isEmpty()) {
                return (T)this.stop();
            }
            this.myTop = ourNotNullizer.nullize(this.myQueue.remove());
            return this.myTop;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/execution/services/ServiceModel$NotLoadedLastBfsIt", "<init>"));
        }
    }

    static interface ServiceModelEventListener {
        public void eventProcessed(ServiceEventListener.ServiceEvent var1);
    }

    static class ServiceGroupNode
    extends ServiceViewItem {
        ServiceGroupNode(@NotNull Object group, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            if (group == null) {
                ServiceGroupNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceGroupNode.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceGroupNode.$$$reportNull$$$0(2);
            }
            super(group, parent, contributor, viewDescriptor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceGroupNode node2 = (ServiceGroupNode)o;
            return this.getValue().equals(node2.getValue()) && Comparing.equal(this.getParent(), node2.getParent());
        }

        @Override
        public int hashCode() {
            int result2 = super.hashCode();
            ServiceViewItem parent = this.getParent();
            result2 = 31 * result2 + (parent != null ? parent.hashCode() : 0);
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "group";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "viewDescriptor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/services/ServiceModel$ServiceGroupNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class ServiceNode
    extends ServiceViewItem {
        private final Project myProject;
        private final ServiceViewContributor<?> myProvidingContributor;
        private volatile boolean myChildrenInitialized;
        private volatile boolean myLoaded;

        ServiceNode(@NotNull Object service2, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor, @NotNull Project project2, @Nullable ServiceViewContributor<?> providingContributor) {
            if (service2 == null) {
                ServiceNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceNode.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceNode.$$$reportNull$$$0(2);
            }
            if (project2 == null) {
                ServiceNode.$$$reportNull$$$0(3);
            }
            super(service2, parent, contributor, viewDescriptor);
            this.myProject = project2;
            this.myProvidingContributor = providingContributor;
            this.myChildrenInitialized = providingContributor == null;
            this.myLoaded = !(providingContributor instanceof ServiceViewLazyContributor);
        }

        @Override
        @NotNull
        List<ServiceViewItem> getChildren() {
            List<ServiceViewItem> children2 = super.getChildren();
            if (!this.myChildrenInitialized) {
                if (this.myProvidingContributor != null) {
                    children2.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.myProvidingContributor));
                }
                this.myChildrenInitialized = true;
                this.myLoaded = true;
            }
            List<ServiceViewItem> list2 = children2;
            if (list2 == null) {
                ServiceNode.$$$reportNull$$$0(4);
            }
            return list2;
        }

        boolean isChildrenInitialized() {
            return this.myChildrenInitialized;
        }

        boolean isLoaded() {
            return this.myLoaded;
        }

        private void reloadChildren() {
            super.getChildren().clear();
            if (this.myProvidingContributor != null) {
                this.myChildrenInitialized = false;
                this.myLoaded = true;
            }
        }

        private void moveChildren(ServiceNode node2) {
            List<ServiceViewItem> children2 = super.getChildren();
            children2.clear();
            List<ServiceViewItem> nodeChildren = node2.myChildren;
            children2.addAll(nodeChildren);
            nodeChildren.clear();
            for (ServiceViewItem child : children2) {
                child.setParent(this);
            }
            this.myChildrenInitialized = node2.myChildrenInitialized;
            this.myLoaded = node2.myLoaded;
        }

        @Nullable
        ServiceViewContributor<?> getProvidingContributor() {
            return this.myProvidingContributor;
        }

        @NotNull
        private Object getService() {
            Object object = this.myProvidingContributor != null ? this.myProvidingContributor : this.getValue();
            if (object == null) {
                ServiceNode.$$$reportNull$$$0(5);
            }
            return object;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceModel$ServiceNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceModel$ServiceNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class ContributorNode
    extends ServiceViewItem {
        private final Project myProject;

        ContributorNode(@NotNull Project project2, @NotNull ServiceViewContributor<?> contributor) {
            if (project2 == null) {
                ContributorNode.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ContributorNode.$$$reportNull$$$0(1);
            }
            super(contributor, null, contributor, contributor.getViewDescriptor(project2));
            this.myProject = project2;
        }

        private void loadChildren() {
            List<ServiceViewItem> children2 = this.getChildren();
            if (!children2.isEmpty()) {
                children2.clear();
            }
            children2.addAll(ServiceModel.getContributorChildren(this.myProject, this, this.getContributor()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "contributor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/execution/services/ServiceModel$ContributorNode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static abstract class ServiceViewItem
    implements ColoredItem {
        private final Object myValue;
        private volatile ServiceViewItem myParent;
        private final ServiceViewContributor<?> myContributor;
        private ServiceViewDescriptor myViewDescriptor;
        private final List<ServiceViewItem> myChildren;
        private volatile boolean myPresentationUpdated;
        private volatile boolean myRemoved;
        private PresentationData myPresentation;

        protected ServiceViewItem(@NotNull Object value, @Nullable ServiceViewItem parent, @NotNull ServiceViewContributor<?> contributor, @NotNull ServiceViewDescriptor viewDescriptor) {
            if (value == null) {
                ServiceViewItem.$$$reportNull$$$0(0);
            }
            if (contributor == null) {
                ServiceViewItem.$$$reportNull$$$0(1);
            }
            if (viewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(2);
            }
            this.myChildren = new CopyOnWriteArrayList<ServiceViewItem>();
            this.myValue = value;
            this.myParent = parent;
            this.myContributor = contributor;
            this.myViewDescriptor = viewDescriptor;
        }

        @NotNull
        Object getValue() {
            Object object = this.myValue;
            if (object == null) {
                ServiceViewItem.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        ServiceViewContributor<?> getContributor() {
            ServiceViewContributor<?> serviceViewContributor = this.myContributor;
            if (serviceViewContributor == null) {
                ServiceViewItem.$$$reportNull$$$0(4);
            }
            return serviceViewContributor;
        }

        @NotNull
        ServiceViewContributor<?> getRootContributor() {
            ServiceViewContributor<?> serviceViewContributor = this.myParent == null ? this.myContributor : this.myParent.getRootContributor();
            if (serviceViewContributor == null) {
                ServiceViewItem.$$$reportNull$$$0(5);
            }
            return serviceViewContributor;
        }

        @NotNull
        ServiceViewDescriptor getViewDescriptor() {
            if (!this.myPresentationUpdated) {
                this.myPresentationUpdated = true;
                if (this.myValue instanceof NodeDescriptor) {
                    ((NodeDescriptor)this.myValue).update();
                }
            }
            ServiceViewDescriptor serviceViewDescriptor = this.myViewDescriptor;
            if (serviceViewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(6);
            }
            return serviceViewDescriptor;
        }

        private void setViewDescriptor(@NotNull ServiceViewDescriptor viewDescriptor) {
            if (viewDescriptor == null) {
                ServiceViewItem.$$$reportNull$$$0(7);
            }
            AppUIUtil.invokeOnEdt(() -> {
                this.myViewDescriptor = viewDescriptor;
                this.myPresentationUpdated = false;
            });
        }

        @Nullable
        ServiceViewItem getParent() {
            return this.myParent;
        }

        private void setParent(@Nullable ServiceViewItem parent) {
            this.myParent = parent;
        }

        @NotNull
        List<ServiceViewItem> getChildren() {
            List<ServiceViewItem> list2 = this.myChildren;
            if (list2 == null) {
                ServiceViewItem.$$$reportNull$$$0(8);
            }
            return list2;
        }

        @Override
        @Nullable
        public Color getColor() {
            ServiceViewDescriptor descriptor = this.getViewDescriptor();
            return descriptor instanceof ColoredItem ? ((ColoredItem)((Object)descriptor)).getColor() : null;
        }

        private void markRemoved() {
            this.myRemoved = true;
        }

        boolean isRemoved() {
            return this.myRemoved || this.myParent != null && this.myParent.isRemoved();
        }

        ItemPresentation getItemPresentation(@Nullable ServiceViewOptions viewOptions) {
            if (this.isRemoved()) {
                return this.myPresentation;
            }
            ItemPresentation presentation2 = viewOptions == null ? this.getViewDescriptor().getPresentation() : this.getViewDescriptor().getCustomPresentation(viewOptions);
            this.myPresentation = presentation2 instanceof PresentationData ? (PresentationData)presentation2 : new PresentationData(presentation2.getPresentableText(), presentation2.getLocationString(), presentation2.getIcon(false), null);
            return this.myPresentation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceViewItem node2 = (ServiceViewItem)o;
            return this.myValue.equals(node2.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        public String toString() {
            return this.myValue.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contributor";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewDescriptor";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/services/ServiceModel$ServiceViewItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/services/ServiceModel$ServiceViewItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContributor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRootContributor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getViewDescriptor";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setViewDescriptor";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

