/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.execution.services.ServiceViewActionProvider;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.execution.services.ServiceViewUi;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

class ServiceSingleView
extends ServiceView {
    private final AtomicReference<ServiceModel.ServiceViewItem> myRef;
    private boolean mySelected;
    private final ServiceViewModel.ServiceViewModelListener myListener;

    ServiceSingleView(@NotNull Project project2, @NotNull ServiceViewModel model2, @NotNull ServiceViewUi ui2) {
        if (project2 == null) {
            ServiceSingleView.$$$reportNull$$$0(0);
        }
        if (model2 == null) {
            ServiceSingleView.$$$reportNull$$$0(1);
        }
        if (ui2 == null) {
            ServiceSingleView.$$$reportNull$$$0(2);
        }
        super(new BorderLayout(), project2, model2, ui2);
        this.myRef = new AtomicReference();
        ui2.setServiceToolbar(ServiceViewActionProvider.getInstance());
        this.add((Component)ui2.getComponent(), "Center");
        this.myListener = this::updateItem;
        model2.addModelListener(this.myListener);
        model2.getInvoker().invokeLater(this::updateItem);
    }

    @Override
    @NotNull
    Promise<Void> select(@NotNull Object service2, @NotNull Class<?> contributorClass) {
        ServiceModel.ServiceViewItem item;
        if (service2 == null) {
            ServiceSingleView.$$$reportNull$$$0(3);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(4);
        }
        if ((item = this.myRef.get()) == null || !item.getValue().equals(service2)) {
            Promise promise = Promises.rejectedPromise((String)"Service not found");
            if (promise == null) {
                ServiceSingleView.$$$reportNull$$$0(5);
            }
            return promise;
        }
        this.showContent();
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            ServiceSingleView.$$$reportNull$$$0(6);
        }
        return promise;
    }

    @Override
    Promise<Void> expand(@NotNull Object service2, @NotNull Class<?> contributorClass) {
        if (service2 == null) {
            ServiceSingleView.$$$reportNull$$$0(7);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(8);
        }
        return this.matches(service2);
    }

    @Override
    Promise<Void> extract(@NotNull Object service2, @NotNull Class<?> contributorClass) {
        if (service2 == null) {
            ServiceSingleView.$$$reportNull$$$0(9);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(10);
        }
        return this.matches(service2);
    }

    private Promise<Void> matches(@NotNull Object service2) {
        ServiceModel.ServiceViewItem item;
        if (service2 == null) {
            ServiceSingleView.$$$reportNull$$$0(11);
        }
        return (item = this.myRef.get()) == null || !item.getValue().equals(service2) ? Promises.rejectedPromise((String)"Service not found") : Promises.resolvedPromise();
    }

    @Override
    void onViewSelected() {
        this.showContent();
    }

    @Override
    void onViewUnselected() {
        this.mySelected = false;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            item.getViewDescriptor().onNodeUnselected();
        }
    }

    @Override
    @NotNull
    List<ServiceModel.ServiceViewItem> getSelectedItems() {
        ServiceModel.ServiceViewItem item = this.myRef.get();
        List<Object> list2 = item == null ? Collections.emptyList() : Collections.singletonList(item);
        if (list2 == null) {
            ServiceSingleView.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    void jumpToServices() {
    }

    @Override
    public void dispose() {
        this.getModel().removeModelListener(this.myListener);
    }

    private void updateItem() {
        WeakReference<ServiceModel.ServiceViewItem> oldValueRef = new WeakReference<ServiceModel.ServiceViewItem>(this.myRef.get());
        ServiceModel.ServiceViewItem newValue = ContainerUtil.getOnlyItem(this.getModel().getRoots());
        WeakReference<ServiceModel.ServiceViewItem> newValueRef = new WeakReference<ServiceModel.ServiceViewItem>(newValue);
        this.myRef.set(newValue);
        ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(this.getProject())).submit(() -> {
            ServiceModel.ServiceViewItem value;
            if (this.mySelected && (value = (ServiceModel.ServiceViewItem)newValueRef.get()) != null) {
                ServiceViewDescriptor descriptor = value.getViewDescriptor();
                if (oldValueRef.get() == null) {
                    this.onViewSelected(descriptor);
                }
                this.myUi.setDetailsComponent(descriptor.getContentComponent());
            }
        });
    }

    private void showContent() {
        if (this.mySelected) {
            return;
        }
        this.mySelected = true;
        ServiceModel.ServiceViewItem item = this.myRef.get();
        if (item != null) {
            ServiceViewDescriptor descriptor = item.getViewDescriptor();
            this.onViewSelected(descriptor);
            this.myUi.setDetailsComponent(descriptor.getContentComponent());
        }
    }

    @Override
    List<Object> getChildrenSafe(@NotNull List<Object> valueSubPath, @NotNull Class<?> contributorClass) {
        if (valueSubPath == null) {
            ServiceSingleView.$$$reportNull$$$0(13);
        }
        if (contributorClass == null) {
            ServiceSingleView.$$$reportNull$$$0(14);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ui";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contributorClass";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceSingleView";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSubPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceSingleView";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "select";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "select";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenSafe";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

