/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.CommonBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ServiceViewDeleteProvider
implements DeleteProvider {
    private final ServiceView myServiceView;

    ServiceViewDeleteProvider(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        this.myServiceView = serviceView;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Project project2;
        if (dataContext == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(2);
        }
        if ((project2 = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        List<Pair<ServiceModel.ServiceViewItem, Runnable>> items = ContainerUtil.mapNotNull(this.myServiceView.getSelectedItems(), item -> {
            Runnable remover = item.getViewDescriptor().getRemover();
            return remover == null ? null : Pair.create(item, remover);
        });
        if ((items = ServiceViewDeleteProvider.filterChildren(items)).isEmpty()) {
            return;
        }
        if (Messages.showYesNoDialog((Project)project2, (String)ExecutionBundle.message((String)"service.view.delete.confirmation", (Object[])new Object[]{ExecutionBundle.message((String)"service.view.items", (Object[])new Object[]{items.size()})}), (String)CommonBundle.message((String)"button.delete", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        for (Pair<ServiceModel.ServiceViewItem, Runnable> item2 : items) {
            ((Runnable)item2.second).run();
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(3);
        }
        if (!ContainerUtil.exists(this.myServiceView.getSelectedItems(), item -> item.getViewDescriptor().getRemover() != null)) {
            return false;
        }
        JComponent detailsComponent = this.myServiceView.getUi().getDetailsComponent();
        return detailsComponent == null || !UIUtil.isAncestor(detailsComponent, (Component)dataContext.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT));
    }

    @NotNull
    private static List<Pair<ServiceModel.ServiceViewItem, Runnable>> filterChildren(List<Pair<ServiceModel.ServiceViewItem, Runnable>> items) {
        List<Pair<ServiceModel.ServiceViewItem, Runnable>> list2 = ContainerUtil.filter(items, item -> {
            for (ServiceModel.ServiceViewItem parent = ((ServiceModel.ServiceViewItem)item.first).getParent(); parent != null; parent = parent.getParent()) {
                for (Pair pair : items) {
                    if (!((ServiceModel.ServiceViewItem)pair.first).equals(parent)) continue;
                    return false;
                }
            }
            return true;
        });
        if (list2 == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewDeleteProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewDeleteProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

