/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceViewModel;
import com.intellij.ide.navigationToolbar.NavBarModel;
import com.intellij.ide.navigationToolbar.NavBarModelExtension;
import com.intellij.ide.navigationToolbar.NavBarModelListener;
import com.intellij.ide.navigationToolbar.NavBarPanel;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceViewNavBarPanel
extends NavBarPanel {
    @NotNull
    private final Consumer<? super ServiceModel.ServiceViewItem> mySelector;
    private boolean myRebuildNeeded;

    ServiceViewNavBarPanel(@NotNull Project project2, boolean docked, @NotNull ServiceViewModel viewModel, @NotNull Consumer<? super ServiceModel.ServiceViewItem> selector) {
        if (project2 == null) {
            ServiceViewNavBarPanel.$$$reportNull$$$0(0);
        }
        if (viewModel == null) {
            ServiceViewNavBarPanel.$$$reportNull$$$0(1);
        }
        if (selector == null) {
            ServiceViewNavBarPanel.$$$reportNull$$$0(2);
        }
        super(project2, docked);
        this.myRebuildNeeded = true;
        this.mySelector = selector;
        Disposer.register(viewModel, this);
        ((ServiceViewNavBarModel)this.getModel()).setViewModel(viewModel);
    }

    @Override
    protected boolean isDisposeOnRemove() {
        return false;
    }

    @Override
    protected NavBarModel createModel() {
        return new ServiceViewNavBarModel(this.myProject, new NavBarModelListener(){

            @Override
            public void modelChanged() {
                ServiceViewNavBarPanel.this.myRebuildNeeded = true;
                ServiceViewNavBarPanel.this.getUpdateQueue().queueRebuildUi();
            }

            @Override
            public void selectionChanged() {
                ServiceViewNavBarPanel.this.updateItems();
                ServiceViewNavBarPanel.this.scrollSelectionToVisible();
            }
        });
    }

    @Override
    public boolean isRebuildUiNeeded() {
        if (this.myRebuildNeeded) {
            this.myRebuildNeeded = false;
            return true;
        }
        return super.isRebuildUiNeeded();
    }

    @Override
    protected void doubleClick(Object object) {
        if (object instanceof ServiceModel.ServiceViewItem) {
            this.mySelector.accept((ServiceModel.ServiceViewItem)object);
        }
        this.hideHint(true);
    }

    void hidePopup() {
        this.hideHint(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "viewModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "selector";
                break;
            }
        }
        objectArray[1] = "com/intellij/execution/services/ServiceViewNavBarPanel";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class ServiceViewNavBarRoot {
        ServiceViewNavBarRoot() {
        }
    }

    private static final class ServiceViewNavBarModel
    extends NavBarModel {
        private ServiceViewModel myViewModel;
        private final ServiceViewNavBarRoot myRoot;

        ServiceViewNavBarModel(@NotNull Project project2, @NotNull NavBarModelListener notificator) {
            if (project2 == null) {
                ServiceViewNavBarModel.$$$reportNull$$$0(0);
            }
            if (notificator == null) {
                ServiceViewNavBarModel.$$$reportNull$$$0(1);
            }
            super(project2, notificator, null);
            this.myRoot = new ServiceViewNavBarRoot();
        }

        void setViewModel(@NotNull ServiceViewModel viewModel) {
            if (viewModel == null) {
                ServiceViewNavBarModel.$$$reportNull$$$0(2);
            }
            this.myViewModel = viewModel;
        }

        @Override
        public void updateModel(DataContext dataContext) {
        }

        @Override
        public void updateModelAsync(@NotNull DataContext dataContext, @Nullable Runnable callback) {
            if (dataContext == null) {
                ServiceViewNavBarModel.$$$reportNull$$$0(3);
            }
        }

        @Override
        protected void updateModel(PsiElement psiElement, NavBarModelExtension ownerExtension) {
        }

        @Override
        public void updateModel(Object object) {
            ArrayList<Object> path2 = new ArrayList<Object>();
            if (object instanceof ServiceModel.ServiceViewItem) {
                ServiceModel.ServiceViewItem item = (ServiceModel.ServiceViewItem)object;
                List<? extends ServiceModel.ServiceViewItem> roots2 = this.myViewModel.getVisibleRoots();
                do {
                    path2.add(item);
                } while ((item = roots2.contains(item) ? null : item.getParent()) != null);
            }
            path2.add(this.myRoot);
            Collections.reverse(path2);
            this.setModel(path2, true);
        }

        @Override
        protected boolean hasChildren(Object object) {
            return !this.getChildren(object).isEmpty();
        }

        @Override
        public List<Object> getChildren(Object object) {
            if (object == this.myRoot) {
                return new ArrayList<Object>(this.myViewModel.getVisibleRoots());
            }
            if (object instanceof ServiceModel.ServiceViewItem) {
                ServiceModel.ServiceNode service2;
                if (object instanceof ServiceModel.ServiceNode && (service2 = (ServiceModel.ServiceNode)object).getProvidingContributor() != null && !service2.isChildrenInitialized()) {
                    this.myViewModel.getInvoker().invoke(() -> service2.getChildren());
                    return Collections.emptyList();
                }
                return new ArrayList<Object>(this.myViewModel.getChildren((ServiceModel.ServiceViewItem)object));
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "notificator";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewModel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/execution/services/ServiceViewNavBarPanel$ServiceViewNavBarModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setViewModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateModelAsync";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

