/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.facet.impl.invalid.InvalidFacet;
import com.intellij.facet.impl.invalid.InvalidFacetManager;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.NlsSafe;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class FacetLoadingErrorDescription
extends ConfigurationErrorDescription {
    private static final ConfigurationErrorType FACET_ERROR = new ConfigurationErrorType(true){

        @Override
        @Nls
        @NotNull
        public String getErrorText(int errorCount, @NlsSafe String firstElementName) {
            String string2 = ProjectBundle.message((String)"facet.configuration.problem.text", (Object[])new Object[]{errorCount, firstElementName});
            if (string2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetLoadingErrorDescription$1", "getErrorText"));
        }
    };
    private final InvalidFacet myFacet;

    public FacetLoadingErrorDescription(InvalidFacet facet) {
        super(facet.getName() + " (" + facet.getModule().getName() + ")", facet.getErrorMessage(), FACET_ERROR);
        this.myFacet = facet;
    }

    @Override
    @NotNull
    public String getIgnoreConfirmationMessage() {
        String string2 = ProjectBundle.message((String)"confirmation.message.would.you.like.to.ignore.facet", (Object[])new Object[]{this.myFacet.getName(), this.myFacet.getModule().getName()});
        if (string2 == null) {
            FacetLoadingErrorDescription.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public void ignoreInvalidElement() {
        InvalidFacetManager.getInstance(this.myFacet.getModule().getProject()).setIgnored(this.myFacet, true);
    }

    @Override
    public boolean isValid() {
        return !this.myFacet.isDisposed();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/facet/impl/FacetLoadingErrorDescription", "getIgnoreConfirmationMessage"));
    }
}

