/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.facet.impl.invalid.InvalidFacetConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Arrays;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetUtil {
    public static <F extends Facet> F addFacet(Module module, FacetType<F, ?> type) {
        return FacetUtil.addFacet(module, type, type.getPresentableName());
    }

    public static <F extends Facet> F addFacet(@NotNull Module module, @NotNull FacetType<F, ?> type, @NotNull String facetName) {
        if (module == null) {
            FacetUtil.$$$reportNull$$$0(0);
        }
        if (type == null) {
            FacetUtil.$$$reportNull$$$0(1);
        }
        if (facetName == null) {
            FacetUtil.$$$reportNull$$$0(2);
        }
        ModifiableFacetModel model2 = FacetManager.getInstance((Module)module).createModifiableModel();
        Object facet = FacetUtil.createFacet(module, type, facetName);
        ApplicationManager.getApplication().runWriteAction(() -> {
            model2.addFacet(facet);
            model2.commit();
        });
        return facet;
    }

    private static <F extends Facet, C extends FacetConfiguration> F createFacet(Module module, FacetType<F, C> type, @NotNull String facetName) {
        if (facetName == null) {
            FacetUtil.$$$reportNull$$$0(3);
        }
        return (F)FacetManager.getInstance((Module)module).createFacet(type, facetName, type.createDefaultConfiguration(), null);
    }

    public static void deleteFacet(Facet facet) {
        WriteAction.runAndWait(() -> {
            if (!FacetUtil.isRegistered(facet)) {
                return;
            }
            ModifiableFacetModel model2 = FacetManager.getInstance((Module)facet.getModule()).createModifiableModel();
            model2.removeFacet(facet);
            model2.commit();
        });
    }

    public static boolean isRegistered(Facet facet) {
        return Arrays.asList(FacetManager.getInstance((Module)facet.getModule()).getAllFacets()).contains(facet);
    }

    public static void loadFacetConfiguration(@NotNull FacetConfiguration configuration, @Nullable Element config) throws InvalidDataException {
        if (configuration == null) {
            FacetUtil.$$$reportNull$$$0(4);
        }
        if (config != null) {
            if (configuration instanceof PersistentStateComponent) {
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)configuration, config);
            } else {
                configuration.readExternal(config);
            }
        }
    }

    @NotNull
    public static Element saveFacetConfiguration(@NotNull FacetConfiguration configuration) {
        if (configuration == null) {
            FacetUtil.$$$reportNull$$$0(5);
        }
        if (configuration instanceof PersistentStateComponent) {
            Object state = ((PersistentStateComponent)configuration).getState();
            if (state instanceof Element) {
                Element element2 = (Element)state;
                if (element2 == null) {
                    FacetUtil.$$$reportNull$$$0(6);
                }
                return element2;
            }
            Element result2 = XmlSerializer.serialize(state);
            Element element3 = result2 == null ? new Element("configuration") : result2;
            if (element3 == null) {
                FacetUtil.$$$reportNull$$$0(7);
            }
            return element3;
        }
        if (configuration instanceof InvalidFacetConfiguration) {
            Element element4 = ((InvalidFacetConfiguration)configuration).getFacetState().getConfiguration();
            if (element4 == null) {
                FacetUtil.$$$reportNull$$$0(8);
            }
            return element4;
        }
        Element config = new Element("configuration");
        configuration.writeExternal(config);
        Element element5 = config;
        if (element5 == null) {
            FacetUtil.$$$reportNull$$$0(9);
        }
        return element5;
    }

    @ApiStatus.Internal
    @Nullable
    public static Element saveFacetConfiguration(Facet<?> facet) {
        Element config;
        try {
            FacetConfiguration configuration = facet.getConfiguration();
            config = FacetUtil.saveFacetConfiguration(configuration);
            if (facet instanceof JDOMExternalizable) {
                ((JDOMExternalizable)facet).writeExternal(config);
            }
        }
        catch (WriteExternalException e) {
            return null;
        }
        return config;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetName";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/FacetUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/FacetUtil";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "saveFacetConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addFacet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFacet";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadFacetConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveFacetConfiguration";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

