/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.pointers.FacetPointerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointerListener;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.EventDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class FacetPointersManagerImpl
extends FacetPointersManager {
    private final Map<String, FacetPointerImpl> myPointers;
    private final Map<Class<? extends Facet>, EventDispatcher<FacetPointerListener>> myDispatchers;
    @NotNull
    private final Project myProject;

    public FacetPointersManagerImpl(@NotNull Project project2) {
        if (project2 == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(0);
        }
        this.myPointers = new HashMap<String, FacetPointerImpl>();
        this.myDispatchers = new HashMap<Class<? extends Facet>, EventDispatcher<FacetPointerListener>>();
        this.myProject = project2;
    }

    @Override
    public <F extends Facet> FacetPointer<F> create(F facet) {
        String id2 = FacetPointersManagerImpl.constructId(facet);
        FacetPointerImpl<F> pointer = this.myPointers.get(id2);
        if (pointer == null) {
            if (!FacetUtil.isRegistered(facet)) {
                return this.create(id2);
            }
            pointer = new FacetPointerImpl<F>(this, facet);
            this.myPointers.put(id2, pointer);
        }
        return pointer;
    }

    @Override
    public <F extends Facet> FacetPointer<F> create(String id2) {
        FacetPointerImpl pointer = this.myPointers.get(id2);
        if (pointer == null) {
            pointer = new FacetPointerImpl(this, id2);
            this.myPointers.put(id2, pointer);
        }
        return pointer;
    }

    <F extends Facet> void dispose(FacetPointer<F> pointer) {
        this.myPointers.remove(pointer.getId());
    }

    void refreshPointers() {
        ArrayList<Pair<FacetPointerImpl, String>> changed2 = new ArrayList<Pair<FacetPointerImpl, String>>();
        for (FacetPointerImpl facetPointerImpl : this.myPointers.values()) {
            String oldId = facetPointerImpl.getId();
            facetPointerImpl.refresh();
            if (oldId.equals(facetPointerImpl.getId())) continue;
            changed2.add(Pair.create(facetPointerImpl, oldId));
        }
        for (Pair pair : changed2) {
            Class facetClass;
            FacetPointerImpl pointer = (FacetPointerImpl)pair.getFirst();
            Object facet = pointer.getFacet();
            Class clazz = facetClass = facet != null ? facet.getClass() : Facet.class;
            while (facetClass != Object.class) {
                EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
                if (dispatcher != null) {
                    dispatcher.getMulticaster().pointerIdChanged(pointer, (String)pair.getSecond());
                }
                facetClass = facetClass.getSuperclass();
            }
        }
    }

    public boolean isRegistered(FacetPointer<?> pointer) {
        return this.myPointers.containsKey(pointer.getId());
    }

    FacetPointerImpl get(String id2) {
        return this.myPointers.get(id2);
    }

    @Override
    public void addListener(FacetPointerListener<Facet> listener2) {
        this.addListener(Facet.class, listener2);
    }

    @Override
    public void removeListener(FacetPointerListener<Facet> listener2) {
        this.removeListener(Facet.class, listener2);
    }

    @Override
    public void addListener(FacetPointerListener<Facet> listener2, Disposable parentDisposable) {
        this.addListener(Facet.class, listener2, parentDisposable);
    }

    @Override
    public <F extends Facet> void addListener(final Class<F> facetClass, final FacetPointerListener<F> listener2, Disposable parentDisposable) {
        this.addListener(facetClass, listener2);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                FacetPointersManagerImpl.this.removeListener(facetClass, listener2);
            }
        });
    }

    @Override
    public <F extends Facet> void addListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(FacetPointerListener.class);
            this.myDispatchers.put(facetClass, dispatcher);
        }
        dispatcher.addListener(listener2);
    }

    @Override
    public <F extends Facet> void removeListener(Class<F> facetClass, FacetPointerListener<F> listener2) {
        EventDispatcher<FacetPointerListener> dispatcher = this.myDispatchers.get(facetClass);
        if (dispatcher != null) {
            dispatcher.removeListener(listener2);
        }
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            FacetPointersManagerImpl.$$$reportNull$$$0(1);
        }
        return project2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/facet/impl/pointers/FacetPointersManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

