/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.mock;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.mock.MockFacetEditorTab;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;

public class MockFacetConfiguration
implements FacetConfiguration {
    private final List<String> myRootUrls = new ArrayList<String>();
    private String myData = "";
    private MockFacetEditorTab myEditor;

    public MockFacetConfiguration(String data2) {
        this.myData = data2;
    }

    public MockFacetConfiguration() {
    }

    public FacetEditorTab[] createEditorTabs(FacetEditorContext editorContext, FacetValidatorsManager validatorsManager) {
        this.myEditor = new MockFacetEditorTab(this);
        return new FacetEditorTab[]{this.myEditor};
    }

    public MockFacetEditorTab getEditor() {
        return this.myEditor;
    }

    public void addRoot(VirtualFile root) {
        this.myRootUrls.add(root.getUrl());
    }

    public void addRoot(String url) {
        this.myRootUrls.add(url);
    }

    public void removeRoot(VirtualFile root) {
        this.myRootUrls.remove(root.getUrl());
    }

    public void setData(String data2) {
        this.myData = data2;
    }

    public String getData() {
        return this.myData;
    }

    public void readExternal(Element element2) throws InvalidDataException {
        this.myData = StringUtil.notNullize(element2.getAttributeValue("data"));
        this.myRootUrls.clear();
        List<Element> children2 = element2.getChildren("root");
        for (Element child : children2) {
            this.myRootUrls.add(child.getAttributeValue("url"));
        }
    }

    public void writeExternal(Element element2) throws WriteExternalException {
        if (!this.myData.isEmpty()) {
            element2.setAttribute("data", this.myData);
        }
        for (String url : this.myRootUrls) {
            element2.addContent(new Element("root").setAttribute("url", url));
        }
    }

    public Collection<String> getRootUrls() {
        return this.myRootUrls;
    }
}

