/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filename;

import com.intellij.openapi.util.text.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public final class UniqueNameBuilder<T> {
    private static final String VFS_SEPARATOR = "/";
    private final Map<T, String> myPaths = new HashMap<T, String>();
    private final String mySeparator;
    private final String myRoot;
    private final Node myRootNode = new Node("", null);

    public UniqueNameBuilder(String root, String separator) {
        this.myRoot = root;
        this.mySeparator = separator;
    }

    public boolean contains(T file2) {
        return this.myPaths.containsKey(file2);
    }

    public int size() {
        return this.myPaths.size();
    }

    public void addPath(T key, String path2) {
        path2 = Strings.trimStart(path2, this.myRoot);
        this.myPaths.put(key, path2);
        Node current = this.myRootNode;
        PathComponentsIterator pathComponentsIterator = new PathComponentsIterator(path2);
        while (pathComponentsIterator.hasNext()) {
            String word = (String)pathComponentsIterator.next();
            current = current.findOrAddChild(word);
        }
        Node c = current;
        while (c != null) {
            ++c.myNestedChildrenCount;
            c = c.myParentNode;
        }
    }

    public String getShortPath(T key) {
        String path2 = this.myPaths.get(key);
        if (path2 == null) {
            return key.toString();
        }
        Node current = this.myRootNode;
        Node firstNodeWithBranches = null;
        Node firstNodeBeforeNodeWithBranches = null;
        Node fileNameNode = null;
        PathComponentsIterator pathComponentsIterator = new PathComponentsIterator(path2);
        while (pathComponentsIterator.hasNext()) {
            String pathComponent = (String)pathComponentsIterator.next();
            current = current.findOrAddChild(pathComponent);
            if (fileNameNode == null) {
                fileNameNode = current;
            }
            if (firstNodeBeforeNodeWithBranches == null && firstNodeWithBranches != null && current.myChildren.size() <= 1 && current.myParentNode.myNestedChildrenCount - current.myParentNode.myChildren.size() < 1) {
                firstNodeBeforeNodeWithBranches = current;
            }
            if (current.myChildren.size() == 1 || firstNodeWithBranches != null) continue;
            firstNodeWithBranches = current;
        }
        StringBuilder b = new StringBuilder();
        if (firstNodeBeforeNodeWithBranches == null) {
            firstNodeBeforeNodeWithBranches = current;
        }
        boolean skipFirstSeparator = true;
        Node c = firstNodeBeforeNodeWithBranches;
        while (c != this.myRootNode) {
            if (c != fileNameNode && c != firstNodeBeforeNodeWithBranches && c.myParentNode.myChildren.size() == 1) {
                b.append(this.mySeparator);
                b.append("\u2026");
                while (c.myParentNode != fileNameNode && c.myParentNode.myChildren.size() == 1) {
                    c = c.myParentNode;
                }
            } else if (c.myText.startsWith(VFS_SEPARATOR)) {
                if (!skipFirstSeparator) {
                    b.append(this.mySeparator);
                }
                skipFirstSeparator = false;
                b.append(c.myText, VFS_SEPARATOR.length(), c.myText.length());
            } else {
                b.append(c.myText);
            }
            c = c.myParentNode;
        }
        return b.toString();
    }

    public String getSeparator() {
        return this.mySeparator;
    }

    private static final class PathComponentsIterator
    implements Iterator<String> {
        private final String myPath;
        private int myLastPos;
        private int mySeparatorPos;

        PathComponentsIterator(String path2) {
            this.myPath = path2;
            this.myLastPos = path2.length();
            this.mySeparatorPos = path2.lastIndexOf(UniqueNameBuilder.VFS_SEPARATOR);
        }

        @Override
        public boolean hasNext() {
            return this.myLastPos != 0;
        }

        @Override
        public String next() {
            String pathComponent;
            if (this.myLastPos == 0) {
                throw new NoSuchElementException();
            }
            if (this.mySeparatorPos != -1) {
                pathComponent = this.myPath.substring(this.mySeparatorPos, this.myLastPos);
                this.myLastPos = this.mySeparatorPos;
                this.mySeparatorPos = this.myPath.lastIndexOf(UniqueNameBuilder.VFS_SEPARATOR, this.myLastPos - 1);
            } else {
                pathComponent = this.myPath.substring(0, this.myLastPos);
                if (!pathComponent.startsWith(UniqueNameBuilder.VFS_SEPARATOR)) {
                    pathComponent = UniqueNameBuilder.VFS_SEPARATOR + pathComponent;
                }
                this.myLastPos = 0;
            }
            return pathComponent;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    private static final class Node {
        final String myText;
        final HashMap<String, Node> myChildren;
        final Node myParentNode;
        int myNestedChildrenCount;

        Node(String text2, Node parentNode) {
            this.myText = text2;
            this.myParentNode = parentNode;
            this.myChildren = new HashMap();
        }

        Node findOrAddChild(String word) {
            Node node2 = this.myChildren.get(word);
            if (node2 == null) {
                node2 = new Node(word, this);
                this.myChildren.put(word, node2);
            }
            return node2;
        }
    }
}

