/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindBundle;
import com.intellij.find.FindInProjectSettings;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.impl.livePreview.SearchResults;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.LightweightHint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FindUtil {
    private static final Key<Direction> KEY = Key.create("FindUtil.KEY");

    private FindUtil() {
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull Editor myEditor) {
        Project project2;
        if (myEditor == null) {
            FindUtil.$$$reportNull$$$0(0);
        }
        PsiFile file2 = (project2 = myEditor.getProject()) != null ? PsiDocumentManager.getInstance(project2).getPsiFile(myEditor.getDocument()) : null;
        return file2 != null ? file2.getVirtualFile() : null;
    }

    public static void initStringToFindWithSelection(FindModel findModel, @Nullable Editor editor2) {
        String s;
        if (editor2 != null && (s = FindUtil.getSelectedText(editor2)) != null && s.length() < 10000) {
            if (findModel.isRegularExpressions() && Registry.is("ide.find.escape.selected.text.for.regex")) {
                findModel.setStringToFind(StringUtil.escapeToRegexp(s));
            } else {
                FindModel.initStringToFind((FindModel)findModel, (String)s);
            }
        }
    }

    public static void configureFindModel(boolean replace, @Nullable Editor editor2, FindModel model2, boolean firstSearch) {
        String selectedText = FindUtil.getSelectedText(editor2);
        boolean multiline = selectedText != null && selectedText.contains("\n");
        String stringToFind = firstSearch || model2.getStringToFind().contains("\n") ? "" : model2.getStringToFind();
        boolean isSelectionUsed = false;
        if (!StringUtil.isEmpty(selectedText)) {
            if (!multiline || !replace) {
                stringToFind = selectedText;
                isSelectionUsed = true;
            } else {
                stringToFind = "";
            }
        }
        model2.setReplaceState(replace);
        boolean isGlobal = !multiline || !replace;
        model2.setStringToFind(isSelectionUsed && model2.isRegularExpressions() && Registry.is("ide.find.escape.selected.text.for.regex") ? StringUtil.escapeToRegexp(stringToFind) : stringToFind);
        model2.setMultiline(false);
        model2.setGlobal(isGlobal);
        model2.setPromptOnReplace(false);
    }

    public static void updateFindInFileModel(@Nullable Project project2, @NotNull FindModel with2, boolean saveFindString) {
        if (with2 == null) {
            FindUtil.$$$reportNull$$$0(1);
        }
        FindModel model2 = FindManager.getInstance((Project)project2).getFindInFileModel();
        model2.setCaseSensitive(with2.isCaseSensitive());
        model2.setWholeWordsOnly(with2.isWholeWordsOnly());
        model2.setRegularExpressions(with2.isRegularExpressions());
        model2.setSearchContext(with2.getSearchContext());
        if (saveFindString && !with2.getStringToFind().isEmpty()) {
            model2.setStringToFind(with2.getStringToFind());
        }
        if (with2.isReplaceState()) {
            model2.setPreserveCase(with2.isPreserveCase());
            if (saveFindString) {
                model2.setStringToReplace(with2.getStringToReplace());
            }
        }
    }

    public static void useFindStringFromFindInFileModel(FindModel findModel, Editor editor2) {
        EditorSearchSession editorSearchSession;
        if (editor2 != null && (editorSearchSession = EditorSearchSession.get(editor2)) != null) {
            FindModel currentFindModel = editorSearchSession.getFindModel();
            findModel.setStringToFind(currentFindModel.getStringToFind());
            if (findModel.isReplaceState()) {
                findModel.setStringToReplace(currentFindModel.getStringToReplace());
            }
        }
    }

    private static String getSelectedText(@Nullable Editor editor2) {
        if (editor2 == null) {
            return null;
        }
        String selectedText = editor2.getSelectionModel().getSelectedText();
        if (selectedText == null && Registry.is("ide.find.select.word.at.caret")) {
            selectedText = FindUtil.getWordAtCaret(editor2, true);
        }
        return selectedText;
    }

    @Nullable
    private static String getWordAtCaret(@Nullable Editor editor2, boolean selectWordIfFound) {
        if (editor2 == null) {
            return null;
        }
        int caretOffset = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        CharSequence text2 = document.getCharsSequence();
        int start2 = 0;
        int end = document.getTextLength();
        if (!editor2.getSelectionModel().hasSelection()) {
            char c;
            int i;
            for (i = caretOffset - 1; i >= 0; --i) {
                c = text2.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                start2 = i + 1;
                break;
            }
            for (i = caretOffset; i < document.getTextLength(); ++i) {
                c = text2.charAt(i);
                if (Character.isJavaIdentifierPart(c)) continue;
                end = i;
                break;
            }
            if (start2 < end && selectWordIfFound) {
                editor2.getSelectionModel().setSelection(start2, end);
                EditorSearchSession.logSelectionUpdate();
            }
        } else {
            start2 = editor2.getSelectionModel().getSelectionStart();
            end = editor2.getSelectionModel().getSelectionEnd();
        }
        return start2 < end ? text2.subSequence(start2, end).toString() : null;
    }

    public static void findWordAtCaret(Project project2, @NotNull Editor editor2, @NotNull SearchResults.Direction direction) {
        String s;
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(2);
        }
        if (direction == null) {
            FindUtil.$$$reportNull$$$0(3);
        }
        if ((s = FindUtil.getWordAtCaret(editor2, false)) == null) {
            return;
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance((Project)project2);
        findInProjectSettings.addStringToFind(s);
        findManager.getFindInFileModel().setStringToFind(s);
        findManager.setFindWasPerformed();
        findManager.clearFindingNextUsageInFile();
        FindModel model2 = new FindModel();
        model2.setForward(direction == SearchResults.Direction.DOWN);
        model2.setStringToFind(s);
        model2.setCaseSensitive(true);
        model2.setWholeWordsOnly(false);
        EditorSearchSession searchSession = EditorSearchSession.get(editor2);
        if (searchSession != null) {
            searchSession.setTextInField(model2.getStringToFind());
        }
        findManager.setFindNextModel(model2);
        FindUtil.doSearch(project2, editor2, editor2.getCaretModel().getOffset(), true, model2, true);
    }

    public static void find(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(4);
        }
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        FindManager findManager = FindManager.getInstance((Project)project2);
        String s = FindUtil.getSelectedText(editor2);
        FindModel model2 = findManager.getFindInFileModel().clone();
        if (StringUtil.isEmpty(s)) {
            model2.setGlobal(true);
        } else if (s.indexOf(10) >= 0) {
            model2.setGlobal(false);
        } else {
            model2.setStringToFind(s);
            model2.setGlobal(true);
        }
        model2.setReplaceState(false);
        PsiFile psiFile = PsiDocumentManager.getInstance(project2).getPsiFile(editor2.getDocument());
        model2.setFindAllEnabled(psiFile != null);
        findManager.showFindDialog(model2, () -> {
            int offset;
            if (model2.isFindAll() && psiFile != null) {
                findManager.setFindNextModel(model2);
                FindUtil.findAllAndShow(project2, psiFile, model2);
                return;
            }
            if (!model2.isGlobal() && editor2.getSelectionModel().hasSelection()) {
                offset = model2.isForward() ? editor2.getSelectionModel().getSelectionStart() : editor2.getSelectionModel().getSelectionEnd();
                ScrollType scrollType = model2.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                FindUtil.moveCaretAndDontChangeSelection(editor2, offset, scrollType);
            }
            if (model2.isGlobal()) {
                offset = model2.isFromCursor() ? editor2.getCaretModel().getOffset() : (model2.isForward() ? 0 : editor2.getDocument().getTextLength());
            } else {
                if (!editor2.getSelectionModel().hasSelection()) {
                    findManager.setFindNextModel(null);
                    return;
                }
                offset = model2.isForward() ? editor2.getSelectionModel().getSelectionStart() : editor2.getSelectionModel().getSelectionEnd();
            }
            findManager.setFindNextModel(null);
            findManager.getFindInFileModel().copyFrom(model2);
            FindUtil.doSearch(project2, editor2, offset, true, model2, true);
        });
    }

    @Nullable
    static List<Usage> findAll(@NotNull Project project2, @NotNull PsiFile psiFile, @NotNull FindModel findModel) {
        FindResult result2;
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(6);
        }
        if (psiFile == null) {
            FindUtil.$$$reportNull$$$0(7);
        }
        if (findModel == null) {
            FindUtil.$$$reportNull$$$0(8);
        }
        if (project2.isDisposed()) {
            return null;
        }
        if ((psiFile = (PsiFile)psiFile.getNavigationElement()) == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance(project2).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        CharSequence text2 = document.getCharsSequence();
        int textLength = document.getTextLength();
        FindManager findManager = FindManager.getInstance((Project)project2);
        findModel.setForward(true);
        int offset = 0;
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        ArrayList<Usage> usages = new ArrayList<Usage>();
        while (offset < textLength && (result2 = findManager.findString(text2, offset, findModel, virtualFile2)).isStringFound()) {
            usages.add((Usage)new UsageInfo2UsageAdapter(new UsageInfo((PsiElement)psiFile, result2.getStartOffset(), result2.getEndOffset())));
            int prevOffset = offset;
            if (prevOffset != (offset = result2.getEndOffset())) continue;
            ++offset;
        }
        return usages;
    }

    static void findAllAndShow(final @NotNull Project project2, final @NotNull PsiFile psiFile, final @NotNull FindModel findModel) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            FindUtil.$$$reportNull$$$0(10);
        }
        if (findModel == null) {
            FindUtil.$$$reportNull$$$0(11);
        }
        findModel.setCustomScope(true);
        findModel.setProjectScope(false);
        findModel.setCustomScopeName(FindBundle.message("file.scope.name.0", psiFile.getName()));
        List<Usage> usages = FindUtil.findAll(project2, psiFile, findModel);
        if (usages == null) {
            return;
        }
        UsageTarget[] usageTargets = new UsageTarget[]{new FindInProjectUtil.StringUsageTarget(project2, findModel)};
        UsageViewPresentation usageViewPresentation = FindInProjectUtil.setupViewPresentation(false, findModel);
        UsageView view = UsageViewManager.getInstance((Project)project2).showUsages(usageTargets, usages.toArray(Usage.EMPTY_ARRAY), usageViewPresentation);
        view.setRerunAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FindUtil.findAllAndShow(project2, psiFile, findModel);
            }

            @Override
            public boolean isEnabled() {
                return !project2.isDisposed() && psiFile.isValid();
            }
        });
    }

    public static void searchBack(Project project2, Editor editor2, @Nullable DataContext context2) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project2);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor2, null, context2);
            return;
        }
        FindModel model2 = findManager.getFindNextModel(editor2);
        if (model2 == null) {
            model2 = findManager.getFindInFileModel();
        }
        model2.setForward(!(model2 = model2.clone()).isForward());
        if (!model2.isGlobal() && !editor2.getSelectionModel().hasSelection()) {
            model2.setGlobal(true);
        }
        if (Direction.UP.equals(editor2.getUserData(KEY)) && !model2.isForward()) {
            offset = editor2.getDocument().getTextLength();
        } else if (Direction.DOWN.equals(editor2.getUserData(KEY)) && model2.isForward()) {
            offset = 0;
        } else {
            editor2.putUserData(KEY, null);
            offset = editor2.getCaretModel().getOffset();
            if (!model2.isForward() && offset > 0) {
                --offset;
            }
        }
        FindUtil.searchAgain(project2, editor2, offset, model2);
    }

    public static boolean searchAgain(Project project2, Editor editor2, @Nullable DataContext context2) {
        int offset;
        FindManager findManager = FindManager.getInstance((Project)project2);
        if (!findManager.findWasPerformed() && !findManager.selectNextOccurrenceWasPerformed()) {
            new IncrementalFindAction().getHandler().execute(editor2, null, context2);
            return false;
        }
        FindModel model2 = findManager.getFindNextModel(editor2);
        if (model2 == null) {
            model2 = findManager.getFindInFileModel();
        }
        model2 = model2.clone();
        if (Direction.DOWN.equals(editor2.getUserData(KEY)) && model2.isForward()) {
            offset = 0;
        } else if (Direction.UP.equals(editor2.getUserData(KEY)) && !model2.isForward()) {
            offset = editor2.getDocument().getTextLength();
        } else {
            editor2.putUserData(KEY, null);
            int n = offset = model2.isGlobal() && model2.isForward() ? editor2.getSelectionModel().getSelectionEnd() : editor2.getCaretModel().getOffset();
            if (!model2.isForward() && offset > 0) {
                --offset;
            }
        }
        return FindUtil.searchAgain(project2, editor2, offset, model2);
    }

    private static boolean searchAgain(Project project2, Editor editor2, int offset, FindModel model2) {
        if (!model2.isGlobal() && !editor2.getSelectionModel().hasSelection()) {
            model2.setGlobal(true);
        }
        model2.setFromCursor(false);
        if (model2.isReplaceState()) {
            model2.setPromptOnReplace(true);
            model2.setReplaceAll(false);
            FindUtil.replace(project2, editor2, offset, model2);
            return true;
        }
        FindUtil.doSearch(project2, editor2, offset, true, model2, true);
        return false;
    }

    public static void replace(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(12);
        }
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(13);
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        FindModel model2 = findManager.getFindInFileModel().clone();
        String s = editor2.getSelectionModel().getSelectedText();
        if (!StringUtil.isEmpty(s)) {
            if (s.indexOf(10) >= 0) {
                model2.setGlobal(false);
            } else {
                model2.setStringToFind(s);
                model2.setGlobal(true);
            }
        } else {
            model2.setGlobal(true);
        }
        model2.setReplaceState(true);
        findManager.showFindDialog(model2, () -> {
            int offset;
            if (!model2.isGlobal() && editor2.getSelectionModel().hasSelection()) {
                offset = model2.isForward() ? editor2.getSelectionModel().getSelectionStart() : editor2.getSelectionModel().getSelectionEnd();
                ScrollType scrollType = model2.isForward() ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
                FindUtil.moveCaretAndDontChangeSelection(editor2, offset, scrollType);
            }
            if (model2.isGlobal()) {
                if (model2.isFromCursor()) {
                    offset = editor2.getCaretModel().getOffset();
                    if (!model2.isForward()) {
                        ++offset;
                    }
                } else {
                    offset = model2.isForward() ? 0 : editor2.getDocument().getTextLength();
                }
            } else {
                if (!editor2.getSelectionModel().hasSelection()) {
                    findManager.setFindNextModel(null);
                    return;
                }
                int n = offset = model2.isForward() ? editor2.getSelectionModel().getSelectionStart() : editor2.getSelectionModel().getSelectionEnd();
            }
            if (s != null && editor2.getSelectionModel().hasSelection() && s.equals(model2.getStringToFind())) {
                if (model2.isFromCursor() && model2.isForward()) {
                    offset = Math.min(editor2.getSelectionModel().getSelectionStart(), offset);
                } else if (model2.isFromCursor() && !model2.isForward()) {
                    offset = Math.max(editor2.getSelectionModel().getSelectionEnd(), offset);
                }
            }
            findManager.setFindNextModel(null);
            findManager.getFindInFileModel().copyFrom(model2);
            FindUtil.replace(project2, editor2, offset, model2);
        });
    }

    public static boolean replace(@NotNull Project project2, @NotNull Editor editor2, int offset, @NotNull FindModel model2) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(14);
        }
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(15);
        }
        if (model2 == null) {
            FindUtil.$$$reportNull$$$0(16);
        }
        return FindUtil.replace(project2, editor2, offset, model2, (range, replace) -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(@NotNull Project project2, @NotNull Editor editor2, int offset, @NotNull FindModel model2, ReplaceDelegate delegate2) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(17);
        }
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(18);
        }
        if (model2 == null) {
            FindUtil.$$$reportNull$$$0(19);
        }
        Document document = editor2.getDocument();
        if (!FileDocumentManager.getInstance().requestWriting(document, project2)) {
            return false;
        }
        document.startGuardedBlockChecking();
        boolean toPrompt = model2.isPromptOnReplace();
        try {
            FindUtil.doReplace(project2, editor2, model2, offset, toPrompt, delegate2);
        }
        catch (ReadOnlyFragmentModificationException e) {
            EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(document).handle(e);
        }
        finally {
            document.stopGuardedBlockChecking();
        }
        return true;
    }

    private static void doReplace(@NotNull Project project2, @NotNull Editor editor2, @NotNull FindModel aModel, int caretOffset, boolean toPrompt, ReplaceDelegate delegate2) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(20);
        }
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(21);
        }
        if (aModel == null) {
            FindUtil.$$$reportNull$$$0(22);
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        FindModel model2 = aModel.clone();
        int occurrences = 0;
        ArrayList<Pair> rangesToChange = new ArrayList<Pair>();
        boolean replaced = false;
        boolean reallyReplaced = false;
        int offset = caretOffset;
        Document document = editor2.getDocument();
        while (offset >= 0 && offset < document.getTextLength()) {
            int newOffset;
            String toReplace;
            caretOffset = offset;
            FindResult result2 = FindUtil.doSearch(project2, editor2, offset, !replaced, model2, toPrompt);
            if (result2 == null) break;
            int startResultOffset = result2.getStartOffset();
            model2.setFromCursor(true);
            int startOffset = result2.getStartOffset();
            int endOffset = result2.getEndOffset();
            String foundString = document.getCharsSequence().subSequence(startOffset, endOffset).toString();
            try {
                toReplace = findManager.getStringToReplace(foundString, model2, startOffset, document.getCharsSequence());
            }
            catch (FindManager.MalformedReplacementStringException e) {
                if (ApplicationManager.getApplication().isUnitTestMode()) break;
                Messages.showErrorDialog((Project)project2, (String)e.getMessage(), (String)FindBundle.message("find.replace.invalid.replacement.string.title", new Object[0]));
                break;
            }
            if (toPrompt) {
                int promptResult = findManager.showPromptDialog(model2, FindBundle.message("find.replace.dialog.title", new Object[0]));
                if (promptResult == 2) {
                    offset = model2.isForward() ? result2.getEndOffset() : startResultOffset;
                    continue;
                }
                if (promptResult == 1) break;
                if (promptResult == 3) {
                    toPrompt = false;
                }
            }
            if (delegate2 == null || delegate2.shouldReplace((TextRange)result2, toReplace)) {
                if (toPrompt && !reallyReplaced) {
                    editor2.getCaretModel().moveToOffset(0);
                    reallyReplaced = true;
                }
                TextRange textRange = FindUtil.doReplace(project2, document, model2, result2, toReplace, toPrompt, rangesToChange);
                replaced = true;
                int n = newOffset = model2.isForward() ? textRange.getEndOffset() : textRange.getStartOffset();
                if (textRange.isEmpty()) {
                    ++newOffset;
                }
                ++occurrences;
            } else {
                int n = newOffset = model2.isForward() ? result2.getEndOffset() : result2.getStartOffset();
            }
            if (newOffset == offset) {
                newOffset += model2.isForward() ? 1 : -1;
            }
            offset = newOffset;
        }
        if (replaced) {
            if (toPrompt) {
                if (caretOffset > document.getTextLength()) {
                    caretOffset = document.getTextLength();
                }
                editor2.getCaretModel().moveToOffset(caretOffset);
            } else {
                CharSequence text2 = document.getCharsSequence();
                StringBuilder newText = new StringBuilder(document.getTextLength());
                rangesToChange.sort(Comparator.comparingInt(o -> ((TextRange)o.getFirst()).getStartOffset()));
                int offsetBefore = 0;
                for (Pair pair : rangesToChange) {
                    TextRange range = (TextRange)pair.getFirst();
                    String replace = (String)pair.getSecond();
                    newText.append(text2, offsetBefore, range.getStartOffset());
                    if (delegate2 == null || delegate2.shouldReplace(range, replace)) {
                        newText.append(replace);
                    } else {
                        newText.append(text2.subSequence(range.getStartOffset(), range.getEndOffset()));
                    }
                    if ((offsetBefore = range.getEndOffset()) >= caretOffset) continue;
                    caretOffset += replace.length() - range.getLength();
                }
                newText.append(text2, offsetBefore, text2.length());
                if (caretOffset > newText.length()) {
                    caretOffset = newText.length();
                }
                int finalCaretOffset = caretOffset;
                CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    document.setText(newText);
                    editor2.getCaretModel().moveToOffset(finalCaretOffset);
                    if (model2.isGlobal()) {
                        editor2.getSelectionModel().removeSelection();
                    }
                }), null, null);
            }
        }
        ReplaceInProjectManager.reportNumberReplacedOccurrences(project2, occurrences);
    }

    private static boolean selectionMayContainRange(SelectionModel selection, TextRange range) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        return starts.length != 0 && new TextRange(starts[0], ends[starts.length - 1]).contains(range);
    }

    private static boolean selectionStrictlyContainsRange(SelectionModel selection, TextRange range) {
        int[] starts = selection.getBlockSelectionStarts();
        int[] ends = selection.getBlockSelectionEnds();
        for (int i = 0; i < starts.length; ++i) {
            if (!new TextRange(starts[i], ends[i]).contains(range)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static FindResult doSearch(@NotNull Project project2, @NotNull Editor editor2, int offset, boolean toWarn, @NotNull FindModel model2, boolean adjustEditor) {
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(23);
        }
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(24);
        }
        if (model2 == null) {
            FindUtil.$$$reportNull$$$0(25);
        }
        FindManager findManager = FindManager.getInstance((Project)project2);
        Document document = editor2.getDocument();
        FindResult result2 = findManager.findString(document.getCharsSequence(), offset, model2, FindUtil.getVirtualFile(editor2));
        boolean isFound = result2.isStringFound();
        SelectionModel selection = editor2.getSelectionModel();
        if (isFound && !model2.isGlobal()) {
            if (!FindUtil.selectionMayContainRange(selection, (TextRange)result2)) {
                isFound = false;
            } else if (!FindUtil.selectionStrictlyContainsRange(selection, (TextRange)result2)) {
                int[] starts;
                for (int newOffset : starts = selection.getBlockSelectionStarts()) {
                    if (newOffset <= result2.getStartOffset()) continue;
                    return FindUtil.doSearch(project2, editor2, newOffset, toWarn, model2, adjustEditor);
                }
            }
        }
        if (!isFound) {
            if (toWarn) {
                FindUtil.processNotFound(editor2, model2.getStringToFind(), model2, project2);
            }
            return null;
        }
        if (adjustEditor) {
            ScrollType scrollType;
            CaretModel caretModel = editor2.getCaretModel();
            ScrollingModel scrollingModel = editor2.getScrollingModel();
            int oldCaretOffset = caretModel.getOffset();
            boolean forward = oldCaretOffset < result2.getStartOffset();
            ScrollType scrollType2 = scrollType = forward ? ScrollType.CENTER_DOWN : ScrollType.CENTER_UP;
            if (model2.isGlobal()) {
                int targetCaretPosition = result2.getEndOffset();
                if (selection.getSelectionEnd() - selection.getSelectionStart() == result2.getLength()) {
                    targetCaretPosition = caretModel.getOffset() - selection.getSelectionStart() + result2.getStartOffset();
                }
                if (caretModel.getCaretAt(editor2.offsetToVisualPosition(targetCaretPosition)) != null) {
                    return result2;
                }
                caretModel.moveToOffset(targetCaretPosition);
                selection.removeSelection();
                scrollingModel.scrollToCaret(scrollType);
                scrollingModel.runActionOnScrollingFinished(() -> {
                    scrollingModel.scrollTo(editor2.offsetToLogicalPosition(result2.getStartOffset()), scrollType);
                    scrollingModel.scrollTo(editor2.offsetToLogicalPosition(result2.getEndOffset()), scrollType);
                });
            } else {
                FindUtil.moveCaretAndDontChangeSelection(editor2, result2.getStartOffset(), scrollType);
                FindUtil.moveCaretAndDontChangeSelection(editor2, result2.getEndOffset(), scrollType);
            }
            IdeDocumentHistory.getInstance((Project)project2).includeCurrentCommandAsNavigation();
            if (!model2.isGlobal()) {
                RangeHighlighterEx segmentHighlighter = (RangeHighlighterEx)editor2.getMarkupModel().addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, result2.getStartOffset(), result2.getEndOffset(), 6001, HighlighterTargetArea.EXACT_RANGE);
                MyListener listener2 = new MyListener(editor2, (RangeHighlighter)segmentHighlighter);
                caretModel.addCaretListener((CaretListener)listener2);
            } else {
                selection.setSelection(result2.getStartOffset(), result2.getEndOffset());
                EditorSearchSession.logSelectionUpdate();
            }
        }
        return result2;
    }

    public static void processNotFound(final Editor editor2, String stringToFind, FindModel model2, Project project2) {
        String message2 = FindBundle.message("find.search.string.not.found.message", stringToFind);
        short position = 2;
        if (model2.isGlobal()) {
            FindModel modelForNextSearch;
            Document document;
            FindModel newModel = model2.clone();
            FindManager findManager = FindManager.getInstance((Project)project2);
            FindResult result2 = findManager.findString((document = editor2.getDocument()).getCharsSequence(), newModel.isForward() ? 0 : document.getTextLength(), model2, FindUtil.getVirtualFile(editor2));
            if (!result2.isStringFound()) {
                result2 = null;
            }
            if ((modelForNextSearch = findManager.getFindNextModel(editor2)) == null) {
                modelForNextSearch = findManager.getFindInFileModel();
            }
            if (result2 != null) {
                AnAction action2;
                if (newModel.isForward()) {
                    action2 = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindNext" : "FindPrevious");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
                    message2 = !shortcutsText.isEmpty() ? FindBundle.message("find.search.again.from.top.hotkey.message", message2, shortcutsText) : FindBundle.message("find.search.again.from.top.action.message", message2);
                    editor2.putUserData(KEY, (Object)Direction.DOWN);
                } else {
                    action2 = ActionManager.getInstance().getAction(modelForNextSearch.isForward() ? "FindPrevious" : "FindNext");
                    String shortcutsText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)action2);
                    message2 = !shortcutsText.isEmpty() ? FindBundle.message("find.search.again.from.bottom.hotkey.message", message2, shortcutsText) : FindBundle.message("find.search.again.from.bottom.action.message", message2);
                    editor2.putUserData(KEY, (Object)Direction.UP);
                    position = 1;
                }
            }
            CaretListener listener2 = new CaretListener(){

                public void caretPositionChanged(@NotNull CaretEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    editor2.putUserData(KEY, null);
                    editor2.getCaretModel().removeCaretListener((CaretListener)this);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/FindUtil$2", "caretPositionChanged"));
                }
            };
            editor2.getCaretModel().addCaretListener(listener2);
        }
        JComponent component2 = HintUtil.createInformationLabel((String)JDOMUtil.escapeText(message2, false, false));
        LightweightHint hint = new LightweightHint(component2);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor2, position, 42, 0, false);
    }

    public static TextRange doReplace(Project project2, Document document, @NotNull FindModel model2, FindResult result2, @NotNull String stringToReplace, boolean reallyReplace, List<? super Pair<TextRange, String>> rangesToChange) {
        int start2;
        int end;
        block10: {
            String toFind;
            block11: {
                block12: {
                    int newOffset;
                    if (model2 == null) {
                        FindUtil.$$$reportNull$$$0(26);
                    }
                    if (stringToReplace == null) {
                        FindUtil.$$$reportNull$$$0(27);
                    }
                    int startOffset = result2.getStartOffset();
                    int endOffset = result2.getEndOffset();
                    if (reallyReplace) {
                        newOffset = FindUtil.doReplace(project2, document, startOffset, endOffset, stringToReplace);
                    } else {
                        String converted = StringUtil.convertLineSeparators(stringToReplace);
                        TextRange textRange = new TextRange(startOffset, endOffset);
                        rangesToChange.add(Pair.create(textRange, converted));
                        newOffset = endOffset;
                    }
                    if (!model2.isRegularExpressions()) break block10;
                    toFind = model2.getStringToFind();
                    if (!model2.isForward()) break block11;
                    if (!StringUtil.endsWithChar(toFind, '$')) break block12;
                    int i = 0;
                    int length = toFind.length();
                    while (i + 2 <= length && toFind.charAt(length - i - 2) == '\\') {
                        ++i;
                    }
                    if (i % 2 != 0) break block10;
                    ++end;
                    break block10;
                }
                if (!StringUtil.startsWithChar(toFind, '^')) break block10;
                for (end = newOffset; end < document.getTextLength() && document.getCharsSequence().charAt(end) != '\n'; ++end) {
                }
                break block10;
            }
            if (StringUtil.startsWithChar(toFind, '^')) {
                --start2;
            } else if (StringUtil.endsWithChar(toFind, '$')) {
                for (start2 = startOffset; start2 >= 0 && document.getCharsSequence().charAt(start2) != '\n'; --start2) {
                }
            }
        }
        return new TextRange(start2, end);
    }

    private static int doReplace(Project project2, Document document, int startOffset, int endOffset, String stringToReplace) {
        String converted = StringUtil.convertLineSeparators(stringToReplace);
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> document.replaceString(startOffset, endOffset, converted)), null, null);
        return startOffset + converted.length();
    }

    private static void moveCaretAndDontChangeSelection(Editor editor2, int offset, ScrollType scrollType) {
        LogicalPosition pos = editor2.offsetToLogicalPosition(offset);
        editor2.getCaretModel().moveToLogicalPosition(pos);
        editor2.getScrollingModel().scrollToCaret(scrollType);
    }

    public static <T> UsageView showInUsageView(@Nullable PsiElement sourceElement, final T @NotNull [] targets2, final @NotNull Function<? super T, ? extends Usage> usageConverter, @NlsContexts.TabTitle @NotNull String title, @Nullable Consumer<? super UsageViewPresentation> presentationSetup, @NotNull Project project2) {
        UsageTarget[] usageTargetArray;
        if (usageConverter == null) {
            FindUtil.$$$reportNull$$$0(28);
        }
        if (title == null) {
            FindUtil.$$$reportNull$$$0(29);
        }
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(30);
        }
        if (targets2 == null) {
            FindUtil.$$$reportNull$$$0(31);
        }
        if (targets2.length == 0) {
            return null;
        }
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        presentation2.setCodeUsagesString(title);
        presentation2.setTabName(title);
        presentation2.setTabText(title);
        if (presentationSetup != null) {
            presentationSetup.consume((UsageViewPresentation)presentation2);
        }
        if (sourceElement == null) {
            usageTargetArray = UsageTarget.EMPTY_ARRAY;
        } else {
            UsageTarget[] usageTargetArray2 = new UsageTarget[1];
            usageTargetArray = usageTargetArray2;
            usageTargetArray2[0] = new PsiElement2UsageTargetAdapter(sourceElement);
        }
        UsageTarget[] usageTargets = usageTargetArray;
        final UsageView view = UsageViewManager.getInstance((Project)project2).showUsages(usageTargets, Usage.EMPTY_ARRAY, presentation2);
        ProgressManager.getInstance().run(new Task.Backgroundable(project2, FindBundle.message("progress.title.updating.usage.view", new Object[0])){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                UsageViewImpl impl = (UsageViewImpl)view;
                for (Object pointer : targets2) {
                    if (impl.isDisposed()) break;
                    ApplicationManager.getApplication().runReadAction(() -> {
                        Usage usage2 = (Usage)usageConverter.fun(pointer);
                        if (usage2 != null) {
                            view.appendUsage(usage2);
                        }
                    });
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!impl.isDisposed()) {
                        impl.expandRoot();
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/find/FindUtil$3", "run"));
            }
        });
        return view;
    }

    @Nullable
    public static UsageView showInUsageView(@Nullable PsiElement sourceElement, PsiElement @NotNull [] targets2, @NotNull @NlsContexts.TabTitle String title, @NotNull Project project2) {
        PsiElement[] psiElementArray;
        if (title == null) {
            FindUtil.$$$reportNull$$$0(32);
        }
        if (project2 == null) {
            FindUtil.$$$reportNull$$$0(33);
        }
        if (targets2 == null) {
            FindUtil.$$$reportNull$$$0(34);
        }
        if (targets2.length == 0) {
            return null;
        }
        if (sourceElement == null) {
            psiElementArray = PsiElement.EMPTY_ARRAY;
        } else {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = sourceElement;
        }
        PsiElement[] primary = psiElementArray;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance(project2);
        SmartPsiElementPointer[] pointers2 = (SmartPsiElementPointer[])Stream.of(targets2).map(smartPointerManager::createSmartPsiElementPointer).toArray(SmartPsiElementPointer[]::new);
        targets2 = PsiElement.EMPTY_ARRAY;
        return FindUtil.showInUsageView(sourceElement, pointers2, p -> {
            Object element2 = p.getElement();
            return element2 == null ? null : UsageInfoToUsageConverter.convert((PsiElement[])primary, (UsageInfo)new UsageInfo((PsiElement)element2));
        }, title, null, project2);
    }

    public static void selectSearchResultsInEditor(@NotNull Editor editor2, @NotNull Iterator<? extends FindResult> resultIterator, int caretShiftFromSelectionStart) {
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(35);
        }
        if (resultIterator == null) {
            FindUtil.$$$reportNull$$$0(36);
        }
        ArrayList<CaretState> caretStates = new ArrayList<CaretState>();
        while (resultIterator.hasNext()) {
            FindResult findResult = resultIterator.next();
            int caretOffset = FindUtil.getCaretPosition(findResult, caretShiftFromSelectionStart);
            int selectionStartOffset = findResult.getStartOffset();
            int selectionEndOffset = findResult.getEndOffset();
            EditorActionUtil.makePositionVisible((Editor)editor2, (int)caretOffset);
            EditorActionUtil.makePositionVisible((Editor)editor2, (int)selectionStartOffset);
            EditorActionUtil.makePositionVisible((Editor)editor2, (int)selectionEndOffset);
            caretStates.add(new CaretState(editor2.offsetToLogicalPosition(caretOffset), editor2.offsetToLogicalPosition(selectionStartOffset), editor2.offsetToLogicalPosition(selectionEndOffset)));
        }
        if (caretStates.size() > editor2.getCaretModel().getMaxCaretCount()) {
            EditorUtil.notifyMaxCarets((Editor)editor2);
        } else if (!caretStates.isEmpty()) {
            editor2.getCaretModel().setCaretsAndSelections(caretStates);
        }
    }

    public static boolean selectSearchResultInEditor(@NotNull Editor editor2, @NotNull FindResult result2, int caretShiftFromSelectionStart) {
        if (editor2 == null) {
            FindUtil.$$$reportNull$$$0(37);
        }
        if (result2 == null) {
            FindUtil.$$$reportNull$$$0(38);
        }
        if (!editor2.getCaretModel().supportsMultipleCarets() || EditorUtil.checkMaxCarets((Editor)editor2)) {
            return false;
        }
        int caretOffset = FindUtil.getCaretPosition(result2, caretShiftFromSelectionStart);
        LogicalPosition caretPosition = editor2.offsetToLogicalPosition(caretOffset);
        if (caretShiftFromSelectionStart == 0) {
            caretPosition = caretPosition.leanForward(true);
        }
        EditorActionUtil.makePositionVisible((Editor)editor2, (int)caretOffset);
        Caret newCaret = editor2.getCaretModel().addCaret(caretPosition, true);
        if (newCaret == null) {
            return false;
        }
        int selectionStartOffset = result2.getStartOffset();
        int selectionEndOffset = result2.getEndOffset();
        EditorActionUtil.makePositionVisible((Editor)editor2, (int)selectionStartOffset);
        EditorActionUtil.makePositionVisible((Editor)editor2, (int)selectionEndOffset);
        newCaret.setSelection(selectionStartOffset, selectionEndOffset);
        EditorSearchSession.logSelectionUpdate();
        return true;
    }

    private static int getCaretPosition(FindResult findResult, int caretShiftFromSelectionStart) {
        return caretShiftFromSelectionStart < 0 ? findResult.getEndOffset() : Math.min(findResult.getStartOffset() + caretShiftFromSelectionStart, findResult.getEndOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 18: 
            case 21: 
            case 24: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 20: 
            case 23: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 16: 
            case 19: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModel";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringToReplace";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageConverter";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultIterator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/FindUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFindInFileModel";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findWordAtCaret";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "find";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "findAll";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findAllAndShow";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "replace";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "doReplace";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "doSearch";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "showInUsageView";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "selectSearchResultsInEditor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "selectSearchResultInEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ReplaceDelegate {
        public boolean shouldReplace(TextRange var1, String var2);
    }

    private static final class MyListener
    implements CaretListener {
        private final Editor myEditor;
        private final RangeHighlighter mySegmentHighlighter;

        private MyListener(@NotNull Editor editor2, @NotNull RangeHighlighter segmentHighlighter) {
            if (editor2 == null) {
                MyListener.$$$reportNull$$$0(0);
            }
            if (segmentHighlighter == null) {
                MyListener.$$$reportNull$$$0(1);
            }
            this.myEditor = editor2;
            this.mySegmentHighlighter = segmentHighlighter;
        }

        public void caretPositionChanged(@NotNull CaretEvent e) {
            if (e == null) {
                MyListener.$$$reportNull$$$0(2);
            }
            this.removeAll();
        }

        private void removeAll() {
            this.myEditor.getCaretModel().removeCaretListener((CaretListener)this);
            this.mySegmentHighlighter.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segmentHighlighter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/FindUtil$MyListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "caretPositionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

