/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ResolverKt;
import com.intellij.find.actions.ShowTargetUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesActionHandler;
import com.intellij.find.actions.ShowUsagesParameters;
import com.intellij.find.actions.ShowUsagesTable;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.TargetVariant;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.actions.UsageVariantHandler;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerBase;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.find.findUsages.FindUsagesHandlerUi;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.lang.Language;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.ShowUsageViewSettings;
import com.intellij.usages.ShowUsagesSettings;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoAdapter;
import com.intellij.usages.UsageSearchPresentation;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.EdtScheduledExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ShowUsagesAction
extends AnAction
implements PopupAction,
HintManagerImpl.ActionToIgnore {
    public static final String ID = "ShowUsages";
    private static final String DIMENSION_SERVICE_KEY = "ShowUsagesActions.dimensionServiceKey";
    private static final String SPLITTER_SERVICE_KEY = "ShowUsagesActions.splitterServiceKey";
    private static final String PREVIEW_PROPERTY_KEY = "ShowUsagesActions.previewPropertyKey";
    private static int ourPopupDelayTimeout = 300;

    public ShowUsagesAction() {
        this.setInjectedContext(true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowUsagesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public static int getUsagesPageSize() {
        return Math.max(1, AdvancedSettings.getInt((String)"ide.usages.page.size"));
    }

    public void update(@NotNull AnActionEvent e) {
        UsageTarget[] usageTargets;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(1);
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement(usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            ShowUsagesAction.$$$reportNull$$$0(2);
        }
        if ((project2 = e.getProject()) == null) {
            return;
        }
        ShowUsagesActionState state = ShowUsagesAction.getState(project2);
        Runnable continuation = state.continuation;
        if (continuation != null) {
            state.continuation = null;
            ShowUsagesAction.hideHints();
            continuation.run();
            return;
        }
        PsiDocumentManager.getInstance(project2).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        DataContext dataContext = e.getDataContext();
        ShowUsagesAction.showUsages(project2, dataContext, ResolverKt.allTargets(dataContext));
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project2, @NotNull DataContext dataContext, @NotNull @NotNull List<? extends @NotNull TargetVariant> targetVariants) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(4);
        }
        if (targetVariants == null) {
            ShowUsagesAction.$$$reportNull$$$0(5);
        }
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project2, dataContext, FindSettings.getInstance().getDefaultScopeName());
        SlowOperations.allowSlowOperations(() -> ResolverKt.findShowUsages(project2, dataContext, targetVariants, FindBundle.message("show.usages.ambiguous.title", new Object[0]), ShowUsagesAction.createVariantHandler(project2, editor2, popupPosition, searchScope2)));
    }

    @NotNull
    private static UsageVariantHandler createVariantHandler(final @NotNull Project project2, final @Nullable Editor editor2, final @NotNull RelativePoint popupPosition, final @NotNull SearchScope searchScope2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(6);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(7);
        }
        if (searchScope2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(8);
        }
        return new UsageVariantHandler(){

            @Override
            public void handleTarget(@NotNull SearchTarget target2) {
                if (target2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ShowTargetUsagesActionHandler.showUsages(project2, searchScope2, target2, ShowUsagesParameters.initial(project2, editor2, popupPosition));
            }

            @Override
            public void handlePsi(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ShowUsagesAction.startFindUsages(element2, popupPosition, editor2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleTarget";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handlePsi";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @ApiStatus.Internal
    public static void showUsages(@NotNull Project project2, @NotNull DataContext dataContext, @NotNull RelativePoint popupPosition, @NotNull SearchTarget target2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(9);
        }
        if (dataContext == null) {
            ShowUsagesAction.$$$reportNull$$$0(10);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(11);
        }
        if (target2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(12);
        }
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        SearchScope searchScope2 = FindUsagesOptions.findScopeByName(project2, dataContext, FindSettings.getInstance().getDefaultScopeName());
        ShowTargetUsagesActionHandler.showUsages(project2, searchScope2, target2, ShowUsagesParameters.initial(project2, editor2, popupPosition));
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public static void startFindUsages(@NotNull PsiElement element2, @NotNull RelativePoint popupPosition, @Nullable Editor editor2) {
        Project project2;
        FindUsagesManager findUsagesManager;
        FindUsagesHandler handler;
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(13);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(14);
        }
        if ((handler = (findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)(project2 = element2.getProject()))).getFindUsagesManager()).getFindUsagesHandler(element2, FindUsagesHandlerFactory.OperationMode.USAGES_WITH_DEFAULT_OPTIONS)) == null) {
            return;
        }
        FindUsagesOptions options = handler.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        ShowUsagesAction.showElementUsages(ShowUsagesParameters.initial(project2, editor2, popupPosition), ShowUsagesAction.createActionHandler(handler, options));
    }

    private static void rulesChanged(@NotNull UsageViewImpl usageView, @NotNull PingEDT pingEDT, JBPopup popup2) {
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(15);
        }
        if (pingEDT == null) {
            ShowUsagesAction.$$$reportNull$$$0(16);
        }
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                usageView.waitForUpdateRequestsCompletion();
                if (!(popup2 != null && popup2.isDisposed() || usageView.isDisposed())) {
                    pingEDT.ping();
                }
            }
        }));
    }

    @Nls
    @NotNull
    private static String getUsagesTitle(@NotNull PsiElement element2) {
        ItemPresentation itemPresentation;
        if (element2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(17);
        }
        HtmlBuilder builder2 = new HtmlBuilder();
        builder2.append(StringUtil.capitalize(UsageViewUtil.getType((PsiElement)element2))).nbsp().append(HtmlChunk.text(UsageViewUtil.getLongName((PsiElement)element2)).bold());
        if (element2 instanceof NavigationItem && (itemPresentation = ((NavigationItem)((Object)element2)).getPresentation()) != null && StringUtil.isNotEmpty(itemPresentation.getLocationString())) {
            builder2.nbsp().append(HtmlChunk.text(itemPresentation.getLocationString()).wrapWith("font").attr("color", "#" + ColorUtil.toHex(SimpleTextAttributes.GRAY_ATTRIBUTES.getFgColor())));
        }
        String string2 = builder2.toString();
        if (string2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    private static ShowUsagesActionHandler createActionHandler(final @NotNull FindUsagesHandlerBase handler, final @NotNull FindUsagesOptions options) {
        if (handler == null) {
            ShowUsagesAction.$$$reportNull$$$0(19);
        }
        if (options == null) {
            ShowUsagesAction.$$$reportNull$$$0(20);
        }
        final PsiElement[] primaryElements = handler.getPrimaryElements();
        final PsiElement[] secondaryElements = handler.getSecondaryElements();
        final String title = ShowUsagesAction.getUsagesTitle(handler.getPsiElement());
        final String optionsString = options.generateUsagesString();
        return new ShowUsagesActionHandler(){

            @Override
            public boolean isValid() {
                return handler.getPsiElement().isValid();
            }

            @Override
            @NotNull
            public UsageSearchPresentation getPresentation() {
                return new UsageSearchPresentation(){

                    @Nls
                    @NotNull
                    public String getSearchTargetString() {
                        String string2 = title;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return string2;
                    }

                    @Nls
                    @NotNull
                    public String getOptionsString() {
                        String string2 = optionsString;
                        if (string2 == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return string2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[2];
                        objectArray2[0] = "com/intellij/find/actions/ShowUsagesAction$2$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getSearchTargetString";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getOptionsString";
                                break;
                            }
                        }
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                    }
                };
            }

            @Override
            @NotNull
            public UsageSearcher createUsageSearcher() {
                UsageSearcher usageSearcher = FindUsagesManager.createUsageSearcher(handler, primaryElements, secondaryElements, options);
                if (usageSearcher == null) {
                    2.$$$reportNull$$$0(0);
                }
                return usageSearcher;
            }

            @Override
            @NotNull
            public SearchScope getSelectedScope() {
                SearchScope searchScope2 = options.searchScope;
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                return searchScope2;
            }

            @Override
            @NotNull
            public GlobalSearchScope getMaximalScope() {
                GlobalSearchScope globalSearchScope = FindUsagesManager.getMaximalScope(handler);
                if (globalSearchScope == null) {
                    2.$$$reportNull$$$0(2);
                }
                return globalSearchScope;
            }

            @Override
            public ShowUsagesActionHandler showDialog() {
                FindUsagesOptions newOptions = ShowUsagesAction.showDialog(handler);
                if (newOptions == null) {
                    return null;
                }
                return ShowUsagesAction.createActionHandler(handler, newOptions);
            }

            @Override
            public void findUsages() {
                Project project2 = handler.getProject();
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
                findUsagesManager.findUsages(handler.getPrimaryElements(), handler.getSecondaryElements(), handler, options, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }

            @Override
            @NotNull
            public ShowUsagesActionHandler withScope(@NotNull SearchScope searchScope2) {
                if (searchScope2 == null) {
                    2.$$$reportNull$$$0(3);
                }
                FindUsagesOptions newOptions = options.clone();
                newOptions.searchScope = searchScope2;
                ShowUsagesActionHandler showUsagesActionHandler = ShowUsagesAction.createActionHandler(handler, newOptions);
                if (showUsagesActionHandler == null) {
                    2.$$$reportNull$$$0(4);
                }
                return showUsagesActionHandler;
            }

            @Override
            public Language getTargetLanguage() {
                return handler.getPsiElement().getLanguage();
            }

            @Override
            @NotNull
            public Class<?> getTargetClass() {
                Class<?> clazz = handler.getPsiElement().getClass();
                if (clazz == null) {
                    2.$$$reportNull$$$0(5);
                }
                return clazz;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string2;
                switch (n) {
                    default: {
                        string2 = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 3: {
                        string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "searchScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createUsageSearcher";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSelectedScope";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMaximalScope";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$2";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "withScope";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTargetClass";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "withScope";
                        break;
                    }
                }
                String string3 = String.format(string2, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string3);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalArgumentException(string3);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    static void showElementUsages(final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(21);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(22);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project2 = parameters2.project;
        UsageViewImpl usageView = ShowUsagesAction.createUsageView(project2);
        UsageViewStatisticsCollector.logSearchStarted((Project)project2);
        SearchScope searchScope2 = actionHandler.getSelectedScope();
        AtomicInteger outOfScopeUsages = new AtomicInteger();
        AtomicBoolean manuallyResized = new AtomicBoolean();
        Predicate<? super Usage> originUsageCheck = ShowUsagesAction.originUsageCheck(parameters2.editor);
        ShowUsagesTableCellRenderer renderer = new ShowUsagesTableCellRenderer(project2, originUsageCheck, outOfScopeUsages, searchScope2);
        ShowUsagesTable table = new ShowUsagesTable(renderer);
        AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        TitlePanel statusPanel = new TitlePanel();
        statusPanel.add((Component)processIcon, "West");
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList());
        ArrayList usages = new ArrayList();
        LinkedHashSet visibleUsages = new LinkedHashSet();
        table.setTableModel(new SmartList<UsageNode>(new StringNode(UsageViewBundle.message((String)"progress.searching", (Object[])new Object[0]))));
        Runnable itemChosenCallback = table.prepareTable(ShowUsagesAction.showMoreUsagesRunnable(parameters2, actionHandler), ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler));
        Consumer<AbstractPopup> tableResizer = popup2 -> {
            if (popup2 != null && popup2.isVisible() && !manuallyResized.get()) {
                PropertiesComponent properties = PropertiesComponent.getInstance(project2);
                int dataSize = table.getModel().getRowCount();
                ShowUsagesAction.setPopupSize((JTable)((Object)table), popup2, parameters2.popupPosition, parameters2.minWidth, properties.isValueSet(PREVIEW_PROPERTY_KEY), dataSize);
            }
        };
        AbstractPopup popup3 = ShowUsagesAction.createUsagePopup(usageView, (JTable)((Object)table), itemChosenCallback, statusPanel, parameters2, actionHandler, tableResizer);
        popup3.addResizeListener(() -> manuallyResized.set(true), (Disposable)popup3);
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        if (!popup3.isDisposed()) {
            Disposer.register((Disposable)popup3, (Disposable)usageView);
            Disposer.register((Disposable)popup3, indicator::cancel);
            EdtScheduledExecutorService.getInstance().schedule(() -> {
                if (!usageView.isDisposed()) {
                    ShowUsagesAction.showPopupIfNeedTo((JBPopup)popup3, parameters2.popupPosition);
                }
            }, (long)ourPopupDelayTimeout, TimeUnit.MILLISECONDS);
        }
        UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(null, table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
        UsageNode MORE_USAGES_SEPARATOR_NODE = new UsageNode(null, table.MORE_USAGES_SEPARATOR);
        PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", () -> popup3.isDisposed(), 100, () -> {
            boolean hasOutsideScopeUsages;
            ArrayList copy;
            if (popup3.isDisposed()) {
                return;
            }
            ArrayList<UsageNode> nodes = new ArrayList<UsageNode>(usages.size());
            List list2 = usages;
            synchronized (list2) {
                if (!(popup3.isVisible() || !usages.isEmpty() && ShowUsagesAction.showPopupIfNeedTo((JBPopup)popup3, parameters2.popupPosition))) {
                    return;
                }
                ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                copy = new ArrayList(usages);
            }
            boolean shouldShowMoreSeparator = copy.contains(table.MORE_USAGES_SEPARATOR);
            if (shouldShowMoreSeparator) {
                nodes.add(MORE_USAGES_SEPARATOR_NODE);
            }
            if ((hasOutsideScopeUsages = copy.contains(table.USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
                nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
            }
            ArrayList<UsageNode> data2 = new ArrayList<UsageNode>(nodes);
            int filteredOutCount = ShowUsagesAction.getFilteredOutNodeCount(copy, usageView);
            if (filteredOutCount != 0) {
                DefaultActionGroup filteringActions = (DefaultActionGroup)popup3.getUserData(DefaultActionGroup.class);
                if (filteringActions == null) {
                    return;
                }
                final List unselectedActions = Arrays.stream(filteringActions.getChildren(null)).filter(action2 -> action2 instanceof ToggleAction).map(action2 -> (ToggleAction)action2).filter(ta -> !ta.isSelected(ShowUsagesAction.fakeEvent(ta))).filter(ta -> !StringUtil.isEmpty(ta.getTemplatePresentation().getText())).collect(Collectors.toList());
                data2.add(new FilteredOutUsagesNode(table.USAGES_FILTERED_OUT_SEPARATOR, UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filteredOutCount}), UsageViewBundle.message((String)"usages.were.filtered.out.tooltip", (Object[])new Object[0])){

                    @Override
                    public void onSelected() {
                        ShowUsagesAction.toggleFilters(unselectedActions);
                        ShowUsagesAction.showElementUsages(parameters2, actionHandler);
                    }
                });
            }
            data2.sort(new UsageNodeComparator(table));
            boolean hasMore = shouldShowMoreSeparator || hasOutsideScopeUsages;
            int totalCount = copy.size();
            int visibleCount = totalCount - filteredOutCount;
            statusPanel.setText(ShowUsagesAction.getStatusString(!processIcon.isDisposed(), hasMore, visibleCount, totalCount));
            ShowUsagesAction.rebuildTable(project2, originUsageCheck, data2, table, popup3, parameters2.popupPosition, parameters2.minWidth, manuallyResized);
        });
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, () -> ShowUsagesAction.rulesChanged(usageView, pingEDT, (JBPopup)popup3));
        AtomicLong firstUsageAddedTS = new AtomicLong();
        AtomicBoolean tooManyResults = new AtomicBoolean();
        Processor<Usage> collect2 = usage2 -> {
            if (!UsageViewManagerImpl.isInScope((Usage)usage2, (SearchScope)searchScope2)) {
                if (outOfScopeUsages.getAndIncrement() == 0) {
                    visibleUsages.add(USAGES_OUTSIDE_SCOPE_NODE.getUsage());
                    usages.add(table.USAGES_OUTSIDE_SCOPE_SEPARATOR);
                }
                return true;
            }
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.size() >= parameters2.maxUsages) {
                    tooManyResults.set(true);
                    return false;
                }
                UsageNode nodes = ReadAction.compute(() -> usageView.doAppendUsage(usage2));
                usages.add(usage2);
                firstUsageAddedTS.compareAndSet(0L, System.nanoTime());
                if (nodes != null) {
                    visibleUsages.add(nodes.getUsage());
                    boolean continueSearch = true;
                    if (visibleUsages.size() == parameters2.maxUsages) {
                        visibleUsages.add(MORE_USAGES_SEPARATOR_NODE.getUsage());
                        usages.add(table.MORE_USAGES_SEPARATOR);
                        continueSearch = false;
                    }
                    pingEDT.ping();
                    return continueSearch;
                }
            }
            return true;
        };
        UsageSearcher usageSearcher = actionHandler.createUsageSearcher();
        long searchStarted = System.nanoTime();
        FindUsagesManager.startProcessUsages(indicator, project2, usageSearcher, collect2, () -> ApplicationManager.getApplication().invokeLater(() -> {
            Disposer.dispose((Disposable)processIcon);
            Container parent = processIcon.getParent();
            if (parent != null) {
                parent.remove((Component)processIcon);
                parent.repaint();
            }
            pingEDT.ping();
            List list2 = usages;
            synchronized (list2) {
                if (visibleUsages.isEmpty()) {
                    if (usages.isEmpty()) {
                        String hint = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{searchScope2.getDisplayName()});
                        ShowUsagesAction.hint(false, hint, parameters2, actionHandler);
                        ShowUsagesAction.cancel((JBPopup)popup3);
                    }
                } else if (visibleUsages.size() == 1) {
                    if (usages.size() == 1) {
                        Usage usage2 = (Usage)visibleUsages.iterator().next();
                        if (usage2 == table.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                            String hint = UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)searchScope2);
                            ShowUsagesAction.hint(true, hint, parameters2, actionHandler);
                        } else {
                            String hint = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(usage2, hint, parameters2, actionHandler);
                        }
                        ShowUsagesAction.cancel((JBPopup)popup3);
                    } else {
                        assert (usages.size() > 1) : usages;
                        Usage visibleUsage = (Usage)visibleUsages.iterator().next();
                        if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                            String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), searchScope2.getDisplayName()});
                            ShowUsagesAction.navigateAndHint(visibleUsage, hint, parameters2, actionHandler);
                            ShowUsagesAction.cancel((JBPopup)popup3);
                        }
                    }
                }
            }
            long current = System.nanoTime();
            UsageViewStatisticsCollector.logSearchFinished((Project)project2, actionHandler.getTargetClass(), (SearchScope)searchScope2, (Language)actionHandler.getTargetLanguage(), (int)usages.size(), (long)TimeUnit.MILLISECONDS.convert(current - firstUsageAddedTS.get(), TimeUnit.NANOSECONDS), (long)TimeUnit.MILLISECONDS.convert(current - searchStarted, TimeUnit.NANOSECONDS), (boolean)tooManyResults.get(), (CodeNavigateSource)CodeNavigateSource.ShowUsagesPopup);
        }, project2.getDisposed()));
    }

    private static void toggleFilters(@NotNull List<? extends ToggleAction> unselectedActions) {
        if (unselectedActions == null) {
            ShowUsagesAction.$$$reportNull$$$0(23);
        }
        for (ToggleAction toggleAction : unselectedActions) {
            toggleAction.actionPerformed(ShowUsagesAction.fakeEvent(toggleAction));
        }
    }

    @NotNull
    private static AnActionEvent fakeEvent(@NotNull ToggleAction action2) {
        if (action2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(24);
        }
        return new AnActionEvent(null, DataContext.EMPTY_CONTEXT, "", action2.getTemplatePresentation(), ActionManager.getInstance(), 0);
    }

    @NotNull
    private static UsageViewImpl createUsageView(@NotNull Project project2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(25);
        }
        UsageViewPresentation usageViewPresentation = new UsageViewPresentation();
        usageViewPresentation.setDetachedMode(true);
        return new UsageViewImpl(project2, usageViewPresentation, UsageTarget.EMPTY_ARRAY, null){

            @NotNull
            public UsageViewSettings getUsageViewSettings() {
                ShowUsageViewSettings showUsageViewSettings = ShowUsagesSettings.getInstance().getState();
                if (showUsageViewSettings == null) {
                    4.$$$reportNull$$$0(0);
                }
                return showUsageViewSettings;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$4", "getUsageViewSettings"));
            }
        };
    }

    @NotNull
    private static Predicate<? super Usage> originUsageCheck(@Nullable Editor editor2) {
        PsiReference reference2;
        if (editor2 != null && (reference2 = TargetElementUtil.findReference(editor2)) != null) {
            UsageInfo originUsageInfo = new UsageInfo(reference2);
            Predicate<Usage> predicate = usage2 -> usage2 instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage2).getUsageInfo().equals(originUsageInfo);
            if (predicate == null) {
                ShowUsagesAction.$$$reportNull$$$0(26);
            }
            return predicate;
        }
        Predicate<Usage> predicate = __ -> false;
        if (predicate == null) {
            ShowUsagesAction.$$$reportNull$$$0(27);
        }
        return predicate;
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup2, @NotNull RelativePoint popupPosition) {
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(28);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(29);
        }
        if (!popup2.isDisposed() && !popup2.isVisible()) {
            popup2.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private static JComponent createHintComponent(@NotNull @NlsContexts.HintText String secondInvocationTitle, boolean isWarning, @NotNull JComponent button2) {
        if (secondInvocationTitle == null) {
            ShowUsagesAction.$$$reportNull$$$0(30);
        }
        if (button2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(31);
        }
        JComponent label2 = HintUtil.createInformationLabel((String)secondInvocationTitle);
        if (isWarning) {
            label2.setBackground(MessageType.WARNING.getPopupBackground());
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        button2.setBackground(label2.getBackground());
        panel2.setBackground(label2.getBackground());
        label2.setOpaque(false);
        label2.setBorder(null);
        panel2.setBorder(HintUtil.createHintBorder());
        panel2.add((Component)label2, "Center");
        panel2.add((Component)button2, "East");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(32);
        }
        return jPanel;
    }

    @NotNull
    private static InplaceButton createSettingsButton(@NotNull Project project2, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAndFindUsagesRunnable) {
        KeyboardShortcut shortcut;
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(33);
        }
        if (cancelAction == null) {
            ShowUsagesAction.$$$reportNull$$$0(34);
        }
        if (showDialogAndFindUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(35);
        }
        String tooltip = (shortcut = UsageViewUtil.getShowUsagesWithSettingsShortcut()) == null ? FindBundle.message("show.usages.settings.tooltip", new Object[0]) : FindBundle.message("show.usages.settings.tooltip.shortcut", KeymapUtil.getShortcutText((Shortcut)shortcut));
        return new InplaceButton(tooltip, AllIcons.General.Settings, __ -> {
            ApplicationManager.getApplication().invokeLater(showDialogAndFindUsagesRunnable, project2.getDisposed());
            cancelAction.run();
        });
    }

    @Nullable
    private static FindUsagesOptions showDialog(@NotNull FindUsagesHandlerBase handler) {
        if (handler == null) {
            ShowUsagesAction.$$$reportNull$$$0(36);
        }
        UIEventLogger.ShowUsagesPopupShowSettings.log(handler.getProject());
        AbstractFindUsagesDialog dialog = handler instanceof FindUsagesHandlerUi ? ((FindUsagesHandlerUi)((Object)handler)).getFindUsagesDialog(false, false, false) : FindUsagesHandler.createDefaultFindUsagesDialog(false, false, false, handler);
        if (dialog.showAndGet()) {
            dialog.calcFindUsagesOptions();
            return handler.getFindUsagesOptions(DataManager.getInstance().getDataContext());
        }
        return null;
    }

    @NotNull
    private static AbstractPopup createUsagePopup(@NotNull UsageViewImpl usageView, final @NotNull JTable table, final @NotNull Runnable itemChoseCallback, final @NotNull TitlePanel statusPanel, final @NotNull ShowUsagesParameters parameters2, final @NotNull ShowUsagesActionHandler actionHandler, @NotNull Consumer<? super AbstractPopup> tableResizer) {
        CaptionPanel caption;
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(37);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(38);
        }
        if (itemChoseCallback == null) {
            ShowUsagesAction.$$$reportNull$$$0(39);
        }
        if (statusPanel == null) {
            ShowUsagesAction.$$$reportNull$$$0(40);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(41);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(42);
        }
        if (tableResizer == null) {
            ShowUsagesAction.$$$reportNull$$$0(43);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        Project project2 = parameters2.project;
        String title = actionHandler.getPresentation().getSearchTargetString();
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createPopupChooserBuilder(table).setTitle(XmlStringUtil.wrapInHtml("<body><nobr>" + title + "</nobr></body>")).setAdText(ShowUsagesActionHandler.getSecondInvocationHint(actionHandler)).setMovable(true).setResizable(true).setCancelKeyEnabled(true).setDimensionServiceKey(DIMENSION_SERVICE_KEY);
        final PropertiesComponent properties = PropertiesComponent.getInstance(project2);
        boolean addCodePreview = properties.isValueSet(PREVIEW_PROPERTY_KEY);
        OnePixelSplitter contentSplitter = null;
        if (addCodePreview) {
            contentSplitter = new OnePixelSplitter(true, 0.6f);
            contentSplitter.setSplitterProportionKey(SPLITTER_SERVICE_KEY);
            contentSplitter.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_SECOND_SIZE);
            contentSplitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
            builder2.setContentSplitter((JBSplitter)contentSplitter);
        }
        Disposable contentDisposable = Disposer.newDisposable();
        final AtomicReference<AbstractPopup> popupRef = new AtomicReference<AbstractPopup>();
        KeyboardShortcut shortcut = UsageViewUtil.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$5", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        6.$$$reportNull$$$0(0);
                    }
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$6", "actionPerformed"));
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        ActiveComponent statusComponent = new ActiveComponent(){

            @Override
            public void setActive(boolean active) {
                statusPanel.setActive(active);
            }

            @Override
            @NotNull
            public JComponent getComponent() {
                TitlePanel titlePanel = statusPanel;
                if (titlePanel == null) {
                    7.$$$reportNull$$$0(0);
                }
                return titlePanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$7", "getComponent"));
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = ShowUsagesAction.createPinButton(project2, popupRef, pinGroup, table, actionHandler::findUsages);
        builder2.setCommandButton((ActiveComponent)new CompositeActiveComponent(statusComponent, pin));
        DefaultActionGroup filteringGroup = new DefaultActionGroup();
        usageView.addFilteringActions(filteringGroup);
        filteringGroup.add(ActionManager.getInstance().getAction("UsageGrouping.FileStructure"));
        filteringGroup.add((AnAction)new ToggleAction(UsageViewBundle.message((String)"preview.usages.action.text", (Object[])new Object[0]), null, AllIcons.Actions.PreviewDetailsVertically){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    8.$$$reportNull$$$0(0);
                }
                return properties.isValueSet(ShowUsagesAction.PREVIEW_PROPERTY_KEY);
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    8.$$$reportNull$$$0(1);
                }
                if (e.getDataContext() != DataContext.EMPTY_CONTEXT) {
                    properties.setValue(ShowUsagesAction.PREVIEW_PROPERTY_KEY, state);
                    ShowUsagesAction.cancel((JBPopup)popupRef.get());
                    WindowStateService.getInstance().putSize(ShowUsagesAction.DIMENSION_SERVICE_KEY, null);
                    ShowUsagesAction.showElementUsages(parameters2, actionHandler);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$8";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        JPanel northPanel = new JPanel(new GridBagLayout());
        GridBag gc = new GridBag().nextLine();
        ActionToolbar actionToolbar = ShowUsagesAction.createActionToolbar(table, filteringGroup);
        JComponent toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        northPanel.add((Component)toolbarComponent, gc.next());
        if (!(actionHandler.getMaximalScope() instanceof LocalSearchScope)) {
            ScopeChooserCombo scopeChooserCombo = ShowUsagesAction.scopeChooser(project2, actionHandler.getSelectedScope(), scope -> {
                UsageViewStatisticsCollector.logScopeChanged((Project)project2, (SearchScope)actionHandler.getSelectedScope(), (SearchScope)scope, actionHandler.getTargetClass());
                ShowUsagesAction.cancel((JBPopup)popupRef.get());
                ShowUsagesAction.showElementUsages(parameters2, actionHandler.withScope((SearchScope)scope));
            });
            Disposer.register(contentDisposable, scopeChooserCombo);
            northPanel.add((Component)((Object)scopeChooserCombo), gc.next());
        }
        northPanel.add((Component)new Box.Filler(JBUI.size(10, 0), JBUI.size(10, 0), JBUI.size(Short.MAX_VALUE, 0)), gc.next().weightx(1.0).fillCellHorizontally());
        DefaultActionGroup settingsGroup = new DefaultActionGroup(new AnAction[]{new SettingsAction(project2, () -> ShowUsagesAction.cancel((JBPopup)popupRef.get()), ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler))});
        actionToolbar = ShowUsagesAction.createActionToolbar(table, settingsGroup);
        toolbarComponent = actionToolbar.getComponent();
        toolbarComponent.setOpaque(false);
        if (Registry.is("ide.usages.popup.show.options.string")) {
            JLabel optionsLabel = new JLabel(actionHandler.getPresentation().getOptionsString());
            northPanel.add((Component)optionsLabel, gc.next());
        }
        northPanel.add((Component)toolbarComponent, gc.next());
        builder2.setNorthComponent((JComponent)northPanel);
        PopupUpdateProcessor processor = new PopupUpdateProcessor(usageView.getProject()){

            public void updatePopup(Object lookupItemObject) {
            }
        };
        builder2.addListener((JBPopupListener)processor);
        if (addCodePreview) {
            SimpleColoredComponent previewTitle = new SimpleColoredComponent();
            previewTitle.setBorder((Border)JBUI.Borders.empty(3, 8, 4, 8));
            UsagePreviewPanel usagePreviewPanel = new UsagePreviewPanel(project2, usageView.getPresentation(), false){

                public Dimension getPreferredSize() {
                    return new Dimension(table.getWidth(), Math.max(this.getHeight(), this.getLineHeight() * 5));
                }

                public Dimension getMinimumSize() {
                    Dimension size = super.getMinimumSize();
                    size.height = this.getLineHeight() * 5;
                    return size;
                }
            };
            PropertyChangeListener lineHeightListener = e -> {
                if ((Integer)e.getNewValue() > 0) {
                    tableResizer.accept((AbstractPopup)popupRef.get());
                }
            };
            usagePreviewPanel.addPropertyChangeListener("UsageViewPanel.lineHeightProperty", lineHeightListener);
            Disposer.register(contentDisposable, () -> usagePreviewPanel.removePropertyChangeListener(lineHeightListener));
            Disposer.register(contentDisposable, (Disposable)usagePreviewPanel);
            JPanel previewPanel = new JPanel(new BorderLayout());
            previewPanel.add((Component)previewTitle, "North");
            previewPanel.add((Component)usagePreviewPanel.createComponent(), "Center");
            contentSplitter.setSecondComponent((JComponent)previewPanel);
            new DoubleClickListener(){

                protected boolean onDoubleClick(@NotNull MouseEvent event) {
                    if (event == null) {
                        11.$$$reportNull$$$0(0);
                    }
                    if (event.getSource() != table) {
                        return false;
                    }
                    itemChoseCallback.run();
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/find/actions/ShowUsagesAction$11", "onDoubleClick"));
                }
            }.installOn((Component)table);
            builder2.setAutoselectOnMouseMove(false).setCloseOnEnter(false).registerKeyboardAction(KeyStroke.getKeyStroke(10, 0), __ -> itemChoseCallback.run());
            Runnable updatePreviewRunnable = () -> {
                if (((AbstractPopup)popupRef.get()).isDisposed()) {
                    return;
                }
                int[] selectedRows = table.getSelectedRows();
                SmartList<Promise> selectedUsagePromises = new SmartList<Promise>();
                String file2 = null;
                for (int row : selectedRows) {
                    Usage usage2;
                    Object value = table.getModel().getValueAt(row, 0);
                    if (!(value instanceof UsageNode) || !((usage2 = ((UsageNode)value).getUsage()) instanceof UsageInfoAdapter)) continue;
                    UsageInfoAdapter adapter = (UsageInfoAdapter)usage2;
                    file2 = adapter.getPath();
                    if (!adapter.isValid()) continue;
                    selectedUsagePromises.add(adapter.getMergedInfosAsync());
                }
                String selectedFile = file2;
                Promises.collectResults(selectedUsagePromises).onSuccess(data2 -> {
                    SmartList selectedUsages = new SmartList();
                    for (UsageInfo[] usageInfos : data2) {
                        Collections.addAll(selectedUsages, usageInfos);
                    }
                    usagePreviewPanel.updateLayout(selectedUsages);
                    previewTitle.clear();
                    if (usagePreviewPanel.getCannotPreviewMessage(selectedUsages) == null && selectedFile != null) {
                        previewTitle.append(PathUtil.getFileName(selectedFile), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                });
            };
            Alarm previewUpdater = new Alarm(contentDisposable);
            table.getSelectionModel().addListSelectionListener(e -> {
                if (!e.getValueIsAdjusting() && !previewUpdater.isDisposed()) {
                    previewUpdater.addRequest(updatePreviewRunnable, 50);
                }
            });
        } else {
            builder2.setAutoselectOnMouseMove(true).setItemChoosenCallback(itemChoseCallback).setCloseOnEnter(true);
        }
        AbstractPopup popup2 = (AbstractPopup)builder2.createPopup();
        JComponent content2 = popup2.getContent();
        Disposer.register((Disposable)popup2, contentDisposable);
        if (ExperimentalUI.isNewUI()) {
            Insets insets = JBUI.CurrentTheme.Popup.headerInsets();
            statusPanel.getLabel().setBorder(new EmptyBorder(insets.top, 0, insets.bottom, JBUI.scale(10)));
        }
        if ((caption = popup2.getTitle()) instanceof TitlePanel) {
            TitlePanel titlePanel = (TitlePanel)caption;
            titlePanel.getLabel().setHorizontalAlignment(2);
            titlePanel.obeyPreferredWidth(WindowStateService.getInstance().getSize(DIMENSION_SERVICE_KEY) == null);
        }
        parameters2.minWidth.set(-1);
        for (AnAction action2 : filteringGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        for (AnAction action2 : pinGroup.getChildren(null)) {
            action2.unregisterCustomShortcutSet(usageView.getComponent());
            action2.registerCustomShortcutSet(action2.getShortcutSet(), content2);
        }
        popup2.setUserData(addCodePreview ? Arrays.asList(filteringGroup, contentSplitter) : Collections.singletonList(filteringGroup));
        popup2.setDataProvider(dataId -> {
            if (UsageView.USAGE_VIEW_SETTINGS_KEY.is(dataId)) {
                return usageView.getUsageViewSettings();
            }
            return null;
        });
        popupRef.set(popup2);
        AbstractPopup abstractPopup = popup2;
        if (abstractPopup == null) {
            ShowUsagesAction.$$$reportNull$$$0(44);
        }
        return abstractPopup;
    }

    @NotNull
    private static ActionToolbar createActionToolbar(@NotNull JTable table, @NotNull DefaultActionGroup group) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(45);
        }
        if (group == null) {
            ShowUsagesAction.$$$reportNull$$$0(46);
        }
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ShowUsagesPopupToolbar", (ActionGroup)group, true);
        actionToolbar.setTargetComponent((JComponent)table);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        ActionToolbar actionToolbar2 = actionToolbar;
        if (actionToolbar2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(47);
        }
        return actionToolbar2;
    }

    @NotNull
    private static ActiveComponent createPinButton(final @NotNull Project project2, final @NotNull AtomicReference<AbstractPopup> popupRef, @NotNull DefaultActionGroup pinGroup, @NotNull JTable table, final @NotNull Runnable findUsagesRunnable) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(48);
        }
        if (popupRef == null) {
            ShowUsagesAction.$$$reportNull$$$0(49);
        }
        if (pinGroup == null) {
            ShowUsagesAction.$$$reportNull$$$0(50);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(51);
        }
        if (findUsagesRunnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(52);
        }
        Icon icon2 = ToolWindowManager.getInstance((Project)project2).getLocationIcon("Find", AllIcons.General.Pin_tab);
        AnAction pinAction = new AnAction(IdeBundle.messagePointer((String)"show.in.find.window.button.name", (Object[])new Object[0]), IdeBundle.messagePointer((String)"show.in.find.window.button.pin.description", (Object[])new Object[0]), icon2){
            {
                super(arg0, arg1, arg2);
                AnAction action2 = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action2.getShortcutSet());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    12.$$$reportNull$$$0(0);
                }
                UsageViewStatisticsCollector.logOpenInFindToolWindow((Project)project2);
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel((JBPopup)popupRef.get());
                findUsagesRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$12", "actionPerformed"));
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ShowUsagesAction.createActionToolbar(table, pinGroup);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            @Override
            @NotNull
            public JComponent getComponent() {
                JComponent jComponent = pinToolBar;
                if (jComponent == null) {
                    13.$$$reportNull$$$0(0);
                }
                return jComponent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$13", "getComponent"));
            }
        };
    }

    private static void cancel(@Nullable JBPopup popup2) {
        if (popup2 != null) {
            popup2.cancel();
        }
    }

    @NotNull
    private static ScopeChooserCombo scopeChooser(@NotNull Project project2, @NotNull SearchScope initialScope, @NotNull Consumer<? super SearchScope> scopeConsumer) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(53);
        }
        if (initialScope == null) {
            ShowUsagesAction.$$$reportNull$$$0(54);
        }
        if (scopeConsumer == null) {
            ShowUsagesAction.$$$reportNull$$$0(55);
        }
        ScopeChooserCombo scopeChooserCombo = new ScopeChooserCombo();
        scopeChooserCombo.initialize(project2, false, false, initialScope.getDisplayName(), null).onSuccess(__ -> {
            ComboBox<ScopeDescriptor> scopeComboBox = scopeChooserCombo.getComboBox();
            scopeComboBox.setMinimumAndPreferredWidth(JBUIScale.scale(200));
            scopeComboBox.addItemListener(event -> {
                if (event.getStateChange() != 1) {
                    return;
                }
                SearchScope scope = scopeChooserCombo.getSelectedScope();
                if (scope == null) {
                    return;
                }
                scopeConsumer.accept(scope);
            });
            scopeComboBox.putClientProperty((Object)"JComboBox.isBorderless", (Object)Boolean.TRUE);
        });
        scopeChooserCombo.setButtonVisible(false);
        ScopeChooserCombo scopeChooserCombo2 = scopeChooserCombo;
        if (scopeChooserCombo2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(56);
        }
        return scopeChooserCombo2;
    }

    @Nls
    @NotNull
    private static String getStatusString(boolean findUsagesInProgress, boolean hasMore, int visibleCount, int totalCount) {
        if (findUsagesInProgress || hasMore) {
            String string2 = UsageViewBundle.message((String)"showing.0.usages", (Object[])new Object[]{visibleCount - (hasMore ? 1 : 0)});
            if (string2 == null) {
                ShowUsagesAction.$$$reportNull$$$0(57);
            }
            return string2;
        }
        if (visibleCount != totalCount) {
            String string3 = UsageViewBundle.message((String)"showing.0.of.1.usages", (Object[])new Object[]{visibleCount, totalCount});
            if (string3 == null) {
                ShowUsagesAction.$$$reportNull$$$0(58);
            }
            return string3;
        }
        String string4 = UsageViewBundle.message((String)"found.0.usages", (Object[])new Object[]{totalCount});
        if (string4 == null) {
            ShowUsagesAction.$$$reportNull$$$0(59);
        }
        return string4;
    }

    @Nls
    @NotNull
    private static String suggestSecondInvocation(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text2, @Nls(capitalization=Nls.Capitalization.Sentence) @Nullable String hint) {
        if (text2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(60);
        }
        HtmlBuilder builder2 = new HtmlBuilder().append(text2);
        if (hint != null) {
            builder2.br().append(HtmlChunk.text(hint).wrapWith("small"));
        }
        String string2 = builder2.wrapWithHtmlBody().toString();
        if (string2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(61);
        }
        return string2;
    }

    @Nullable
    static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int getFilteredOutNodeCount(@NotNull List<? extends Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(62);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(63);
        }
        return (int)usages.stream().filter(usage2 -> !usageView.isVisible(usage2)).count();
    }

    private static int getUsageOffset(@NotNull Usage usage2) {
        if (usage2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(64);
        }
        if (!(usage2 instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element2 = ((UsageInfo2UsageAdapter)usage2).getElement();
        if (element2 == null) {
            return -1;
        }
        return element2.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<? extends Usage> usages) {
        Editor editor2;
        if (visibleUsage == null) {
            ShowUsagesAction.$$$reportNull$$$0(65);
        }
        if (usages == null) {
            ShowUsagesAction.$$$reportNull$$$0(66);
        }
        if ((editor2 = ShowUsagesAction.getEditorFor(visibleUsage)) == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor2.getDocument().getLineNumber(offset);
        for (Usage usage2 : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(usage2);
            if (otherEditor != editor2) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(usage2);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    private static int calcMaxWidth(@NotNull JTable table) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(67);
        }
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(68);
        }
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component2 = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component2.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private static void rebuildTable(@NotNull Project project2, @NotNull Predicate<? super Usage> originUsageCheck, @NotNull List<UsageNode> data2, @NotNull ShowUsagesTable table, @Nullable AbstractPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, @NotNull AtomicBoolean manuallyResized) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(69);
        }
        if (originUsageCheck == null) {
            ShowUsagesAction.$$$reportNull$$$0(70);
        }
        if (data2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(71);
        }
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(72);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(73);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(74);
        }
        if (manuallyResized == null) {
            ShowUsagesAction.$$$reportNull$$$0(75);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ShowUsagesTable.MyModel tableModel = table.setTableModel(data2);
        List existingData = tableModel.getItems();
        int row = table.getSelectedRow();
        int newSelection = ShowUsagesAction.updateModel(tableModel, existingData, data2, row == -1 ? 0 : row);
        if (newSelection < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)((Object)table));
            newSelection = table.getSelectedRow();
        } else {
            Object valueInTopRow;
            if (newSelection == 0 && table.getModel().getRowCount() > 1 && (valueInTopRow = table.getModel().getValueAt(0, 0)) instanceof UsageNode && originUsageCheck.test((Usage)((UsageNode)valueInTopRow).getUsage())) {
                ++newSelection;
            }
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)((Object)table), (int)newSelection, (int)0);
        if (popup2 != null) {
            if (manuallyResized.get()) {
                ShowUsagesAction.calcMaxWidth((JTable)((Object)table));
            } else {
                PropertiesComponent properties = PropertiesComponent.getInstance(project2);
                ShowUsagesAction.setPopupSize((JTable)((Object)table), popup2, popupPosition, minWidth, properties.isValueSet(PREVIEW_PROPERTY_KEY), data2.size());
            }
        }
    }

    private static int updateModel(@NotNull ShowUsagesTable.MyModel tableModel, @NotNull List<? extends UsageNode> listOld, @NotNull List<? extends UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            ShowUsagesAction.$$$reportNull$$$0(76);
        }
        if (listOld == null) {
            ShowUsagesAction.$$$reportNull$$$0(77);
        }
        if (listNew == null) {
            ShowUsagesAction.$$$reportNull$$$0(78);
        }
        UsageNode[] oa = listOld.toArray(new UsageNode[0]);
        UsageNode[] na = listNew.toArray(new UsageNode[0]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private static void setPopupSize(@NotNull JTable table, @NotNull AbstractPopup popup2, @NotNull RelativePoint popupPosition, @NotNull IntRef minWidth, boolean showCodePreview, int dataSize) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(79);
        }
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(80);
        }
        if (popupPosition == null) {
            ShowUsagesAction.$$$reportNull$$$0(81);
        }
        if (minWidth == null) {
            ShowUsagesAction.$$$reportNull$$$0(82);
        }
        if (ShowUsagesAction.isCodeWithMeClientInstance((JBPopup)popup2)) {
            return;
        }
        Dimension d = popup2.getSize();
        Insets contentInsets = popup2.getContent().getInsets();
        JBInsets.removeFrom(d, contentInsets);
        Component toolbarComponent = ((BorderLayout)popup2.getComponent().getLayout()).getLayoutComponent("North");
        Dimension toolbarSize = toolbarComponent != null ? toolbarComponent.getPreferredSize() : JBUI.emptySize();
        Dimension headerSize = popup2.getHeaderPreferredSize();
        int width = Math.max(d.width, ShowUsagesAction.calcMaxWidth(table));
        width = Math.max(Math.max(headerSize.width, width), toolbarSize.width);
        width = Math.max(minWidth.get(), width);
        int delta = minWidth.get() == -1 ? 0 : width - minWidth.get();
        int newWidth = Math.max(width, d.width + delta);
        minWidth.set(newWidth);
        int minHeight = headerSize.height + toolbarSize.height;
        Rectangle rectangle = ShowUsagesAction.getPreferredBounds(table, popupPosition.getScreenPoint(), newWidth, minHeight, dataSize, showCodePreview);
        table.setSize(rectangle.width, rectangle.height - minHeight);
        if (dataSize > 0) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        Dimension savedSize = WindowStateService.getInstance().getSize(DIMENSION_SERVICE_KEY);
        JBSplitter splitter = (JBSplitter)popup2.getUserData(JBSplitter.class);
        if (savedSize != null) {
            rectangle.width = Math.min(savedSize.width, rectangle.width);
        }
        if (splitter != null) {
            int newHeight = rectangle.height + splitter.getDividerWidth() + splitter.getSecondComponent().getMinimumSize().height;
            if (savedSize != null) {
                savedSize.height -= popup2.getAdComponentHeight();
                newHeight = Math.max(newHeight, savedSize.height);
            }
            rectangle.height = newHeight;
        }
        popup2.setSize(rectangle.getSize());
    }

    private static boolean isCodeWithMeClientInstance(@NotNull JBPopup popup2) {
        JComponent content2;
        if (popup2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(83);
        }
        return (content2 = popup2.getContent()).getClientProperty("THIN_CLIENT") != null;
    }

    @NotNull
    private static Rectangle getPreferredBounds(@NotNull JTable table, @NotNull Point point, int width, int minHeight, int modelRows, boolean showCodePreview) {
        if (table == null) {
            ShowUsagesAction.$$$reportNull$$$0(84);
        }
        if (point == null) {
            ShowUsagesAction.$$$reportNull$$$0(85);
        }
        boolean addExtraSpace = Registry.is("ide.preferred.scrollable.viewport.extra.space");
        int visibleRows = Math.min(showCodePreview ? 20 : 30, modelRows);
        int rowHeight = table.getRowHeight();
        int space = addExtraSpace && visibleRows < modelRows ? rowHeight / 2 : 0;
        int height = visibleRows * rowHeight + minHeight + space;
        Rectangle bounds = new Rectangle(point.x, point.y, width, height);
        ScreenUtil.fitToScreen(bounds);
        if (bounds.height != height) {
            bounds.height = Math.max(1, (bounds.height - (minHeight += addExtraSpace && space == 0 ? rowHeight / 2 : space)) / rowHeight) * rowHeight + minHeight;
        }
        Rectangle rectangle = bounds;
        if (rectangle == null) {
            ShowUsagesAction.$$$reportNull$$$0(86);
        }
        return rectangle;
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<? super UsageNode> outNodes) {
        if (root == null) {
            ShowUsagesAction.$$$reportNull$$$0(87);
        }
        if (usageView == null) {
            ShowUsagesAction.$$$reportNull$$$0(88);
        }
        if (outNodes == null) {
            ShowUsagesAction.$$$reportNull$$$0(89);
        }
        for (UsageNode node2 : root.getUsageNodes()) {
            Usage usage2 = node2.getUsage();
            if (!usageView.isVisible(usage2)) continue;
            node2.setParent((MutableTreeNode)root);
            outNodes.add((UsageNode)node2);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private static void navigateAndHint(@NotNull Usage usage2, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (usage2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(90);
        }
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(91);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(92);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(93);
        }
        usage2.navigate(true);
        Editor newEditor = ShowUsagesAction.getEditorFor(usage2);
        if (newEditor == null) {
            return;
        }
        ShowUsagesAction.hint(false, hint, parameters2.withEditor(newEditor), actionHandler);
    }

    private static void hint(boolean isWarning, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String hint, @NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (hint == null) {
            ShowUsagesAction.$$$reportNull$$$0(94);
        }
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(95);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(96);
        }
        Project project2 = parameters2.project;
        Editor editor2 = parameters2.editor;
        Runnable runnable = () -> {
            if (!actionHandler.isValid()) {
                return;
            }
            JComponent label2 = ShowUsagesAction.createHintComponent(ShowUsagesAction.suggestSecondInvocation(hint, ShowUsagesActionHandler.getSecondInvocationHint(actionHandler)), isWarning, (JComponent)ShowUsagesAction.createSettingsButton(project2, ShowUsagesAction::hideHints, ShowUsagesAction.showDialogAndRestartRunnable(parameters2, actionHandler)));
            ShowUsagesActionState state = ShowUsagesAction.getState(project2);
            state.continuation = ShowUsagesAction.showUsagesInMaximalScopeRunnable(parameters2, actionHandler);
            Runnable clearContinuation = () -> {
                state.continuation = null;
            };
            if (editor2 == null || editor2.isDisposed() || !UIUtil.isShowing(editor2.getContentComponent())) {
                int flags = 42;
                HintManager.getInstance().showHint(label2, parameters2.popupPosition, flags, 0, clearContinuation);
            } else {
                HintManager.getInstance().showInformationHint(editor2, label2, clearContinuation);
            }
        };
        if (editor2 == null) {
            IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(runnable));
        } else {
            IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> editor2.getScrollingModel().runActionOnScrollingFinished(() -> IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(() -> AsyncEditorLoader.performWhenLoaded((Editor)editor2, (Runnable)runnable))));
        }
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage2) {
        FileEditorLocation location;
        if (usage2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(97);
        }
        FileEditor newFileEditor = (location = usage2.getLocation()) == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    @NotNull
    private static Runnable showMoreUsagesRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(98);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(99);
        }
        Runnable runnable = () -> ShowUsagesAction.showElementUsages(parameters2.moreUsages(), actionHandler);
        if (runnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(100);
        }
        return runnable;
    }

    @NotNull
    private static Runnable showUsagesInMaximalScopeRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(101);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(102);
        }
        Runnable runnable = () -> ShowUsagesAction.showUsagesInMaximalScope(parameters2, actionHandler);
        if (runnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(103);
        }
        return runnable;
    }

    private static void showUsagesInMaximalScope(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(104);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(105);
        }
        ShowUsagesAction.showElementUsages(parameters2, actionHandler.withScope(actionHandler.getMaximalScope()));
    }

    @NotNull
    private static Runnable showDialogAndRestartRunnable(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(106);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(107);
        }
        Runnable runnable = () -> ShowUsagesAction.showDialogAndRestart(parameters2, actionHandler);
        if (runnable == null) {
            ShowUsagesAction.$$$reportNull$$$0(108);
        }
        return runnable;
    }

    private static void showDialogAndRestart(@NotNull ShowUsagesParameters parameters2, @NotNull ShowUsagesActionHandler actionHandler) {
        ShowUsagesActionHandler newActionHandler;
        if (parameters2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(109);
        }
        if (actionHandler == null) {
            ShowUsagesAction.$$$reportNull$$$0(110);
        }
        if ((newActionHandler = actionHandler.showDialog()) != null) {
            ShowUsagesAction.showElementUsages(parameters2, newActionHandler);
        }
    }

    @NotNull
    private static ShowUsagesActionState getState(@NotNull Project project2) {
        if (project2 == null) {
            ShowUsagesAction.$$$reportNull$$$0(111);
        }
        ShowUsagesActionState showUsagesActionState = project2.getService(ShowUsagesActionState.class);
        if (showUsagesActionState == null) {
            ShowUsagesAction.$$$reportNull$$$0(112);
        }
        return showUsagesActionState;
    }

    @TestOnly
    public static void setPopupDelayTimeout(int timeout) {
        ourPopupDelayTimeout = timeout;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 25: 
            case 33: 
            case 48: 
            case 53: 
            case 69: 
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetVariants";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 29: 
            case 73: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupPosition";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 37: 
            case 63: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pingEDT";
                break;
            }
            case 19: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 21: 
            case 41: 
            case 92: 
            case 95: 
            case 98: 
            case 101: 
            case 104: 
            case 106: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 22: 
            case 42: 
            case 93: 
            case 96: 
            case 99: 
            case 102: 
            case 105: 
            case 107: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandler";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unselectedActions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 28: 
            case 80: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondInvocationTitle";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cancelAction";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showDialogAndFindUsagesRunnable";
                break;
            }
            case 38: 
            case 45: 
            case 51: 
            case 67: 
            case 68: 
            case 72: 
            case 79: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemChoseCallback";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusPanel";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableResizer";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupRef";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pinGroup";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findUsagesRunnable";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialScope";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeConsumer";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 64: 
            case 90: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleUsage";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originUsageCheck";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 74: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minWidth";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manuallyResized";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableModel";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOld";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listNew";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outNodes";
                break;
            }
            case 91: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsagesTitle";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "originUsageCheck";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createHintComponent";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsagePopup";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionToolbar";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "scopeChooser";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusString";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSecondInvocation";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredBounds";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "showMoreUsagesRunnable";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "showDialogAndRestartRunnable";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createVariantHandler";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "startFindUsages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "rulesChanged";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUsagesTitle";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createActionHandler";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "showElementUsages";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "toggleFilters";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fakeEvent";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createUsageView";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "showPopupIfNeedTo";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createHintComponent";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsButton";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "createUsagePopup";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createActionToolbar";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createPinButton";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "scopeChooser";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "suggestSecondInvocation";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredOutNodeCount";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getUsageOffset";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "areAllUsagesInOneLine";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "calcMaxWidth";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "columnMaxWidth";
                break;
            }
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "rebuildTable";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "updateModel";
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "setPopupSize";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isCodeWithMeClientInstance";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredBounds";
                break;
            }
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "addUsageNodes";
                break;
            }
            case 90: 
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "navigateAndHint";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "hint";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "getEditorFor";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "showMoreUsagesRunnable";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScopeRunnable";
                break;
            }
            case 104: 
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "showUsagesInMaximalScope";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestartRunnable";
                break;
            }
            case 109: 
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "showDialogAndRestart";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 60: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    @Service
    private static final class ShowUsagesActionState {
        Runnable continuation;

        private ShowUsagesActionState() {
        }
    }

    static abstract class FilteredOutUsagesNode
    extends UsageNode {
        @Nls
        @NotNull
        private final String myString;
        @Nls
        @NotNull
        private final String myToolTip;

        private FilteredOutUsagesNode(@NotNull Usage fakeUsage, @Nls @NotNull String string2, @Nls @NotNull String toolTip) {
            if (fakeUsage == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(0);
            }
            if (string2 == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(1);
            }
            if (toolTip == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(2);
            }
            super(null, fakeUsage);
            this.myString = string2;
            this.myToolTip = toolTip;
        }

        @Nls
        @NotNull
        String getString() {
            String string2 = this.myString;
            if (string2 == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(3);
            }
            return string2;
        }

        @Nls
        @NotNull
        String getTooltip() {
            String string2 = this.myToolTip;
            if (string2 == null) {
                FilteredOutUsagesNode.$$$reportNull$$$0(4);
            }
            return string2;
        }

        public String toString() {
            return this.myString;
        }

        public abstract void onSelected();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fakeUsage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolTip";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$FilteredOutUsagesNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class SettingsAction
    extends DumbAwareAction
    implements CustomComponentAction {
        private final Project project;
        private final Runnable cancelAction;
        private final Runnable showDialogAction;

        private SettingsAction(@NotNull Project project2, @NotNull Runnable cancelAction, @NotNull Runnable showDialogAction) {
            if (project2 == null) {
                SettingsAction.$$$reportNull$$$0(0);
            }
            if (cancelAction == null) {
                SettingsAction.$$$reportNull$$$0(1);
            }
            if (showDialogAction == null) {
                SettingsAction.$$$reportNull$$$0(2);
            }
            super(FindBundle.message("show.usages.settings.tooltip", new Object[0]), null, AllIcons.General.GearPlain);
            this.project = project2;
            this.cancelAction = cancelAction;
            this.showDialogAction = showDialogAction;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SettingsAction.$$$reportNull$$$0(3);
            }
            ApplicationManager.getApplication().invokeLater(this.showDialogAction, this.project.getDisposed());
            this.cancelAction.run();
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            if (presentation2 == null) {
                SettingsAction.$$$reportNull$$$0(4);
            }
            if (place == null) {
                SettingsAction.$$$reportNull$$$0(5);
            }
            return new ActionButton((AnAction)this, presentation2, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Nullable
                protected String getShortcutText() {
                    KeyboardShortcut shortcut = UsageViewUtil.getShowUsagesWithSettingsShortcut();
                    return shortcut != null ? KeymapUtil.getShortcutText((Shortcut)shortcut) : null;
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cancelAction";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "showDialogAction";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$SettingsAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCustomComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class StringNode
    extends UsageNode {
        @Nls
        @NotNull
        private final String myString;

        private StringNode(@Nls @NotNull String string2) {
            if (string2 == null) {
                StringNode.$$$reportNull$$$0(0);
            }
            super(null, (Usage)NullUsage.INSTANCE);
            this.myString = string2;
        }

        @Nls
        @NotNull
        String getString() {
            String string2 = this.myString;
            if (string2 == null) {
                StringNode.$$$reportNull$$$0(1);
            }
            return string2;
        }

        public String toString() {
            return this.myString;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "string";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesAction$StringNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesAction$StringNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class UsageNodeComparator
    implements Comparator<UsageNode> {
        private final ShowUsagesTable myTable;

        private UsageNodeComparator(@NotNull ShowUsagesTable table) {
            if (table == null) {
                UsageNodeComparator.$$$reportNull$$$0(0);
            }
            this.myTable = table;
        }

        @Override
        public int compare(UsageNode c1, UsageNode c2) {
            VirtualFile v2;
            String name2;
            int weight2;
            int weight1;
            if (c1 instanceof StringNode || c2 instanceof StringNode) {
                if (c1 instanceof StringNode && c2 instanceof StringNode) {
                    return Comparing.compare(c1.toString(), c2.toString());
                }
                return c1 instanceof StringNode ? 1 : -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o1 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            int n2 = o2 == this.myTable.USAGES_FILTERED_OUT_SEPARATOR ? 3 : (o2 == this.myTable.USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == this.myTable.MORE_USAGES_SEPARATOR ? 1 : 0));
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i = Comparing.compare(name1, name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName());
            if (i != 0) {
                return i;
            }
            if (Comparing.equal(v1, v2)) {
                FileEditorLocation loc1 = o1.getLocation();
                FileEditorLocation loc2 = o2.getLocation();
                return Comparing.compare(loc1, loc2);
            }
            String path1 = v1 == null ? null : v1.getPath();
            String path2 = v2 == null ? null : v2.getPath();
            return Comparing.compare(path1, path2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction$UsageNodeComparator", "<init>"));
        }
    }
}

