/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesTable
extends JBTable
implements DataProvider {
    final Usage MORE_USAGES_SEPARATOR;
    final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR;
    final Usage USAGES_FILTERED_OUT_SEPARATOR;
    private final ShowUsagesTableCellRenderer myRenderer;

    ShowUsagesTable(@NotNull ShowUsagesTableCellRenderer renderer) {
        if (renderer == null) {
            ShowUsagesTable.$$$reportNull$$$0(0);
        }
        this.MORE_USAGES_SEPARATOR = new UsageAdapter();
        this.USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
        this.USAGES_FILTERED_OUT_SEPARATOR = new UsageAdapter();
        this.myRenderer = renderer;
        ScrollingUtil.installActions((JTable)((Object)this));
        HintUpdateSupply.installDataContextHintUpdateSupply((JComponent)((Object)this));
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            ShowUsagesTable.$$$reportNull$$$0(1);
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            int[] selected = this.getSelectedRows();
            if (selected.length == 1) {
                return ShowUsagesTable.getPsiElementForHint(this.getValueAt(selected[0], 0));
            }
        } else if (LangDataKeys.POSITION_ADJUSTER_POPUP.is(dataId)) {
            return PopupUtil.getPopupContainerFor((Component)((Object)this));
        }
        return null;
    }

    public int getRowHeight() {
        if (ExperimentalUI.isNewUI()) {
            Insets innerInsets = JBUI.CurrentTheme.Popup.Selection.innerInsets();
            return JBUI.CurrentTheme.List.rowHeight() + innerInsets.top + innerInsets.bottom;
        }
        return super.getRowHeight() + 4;
    }

    @NotNull
    Runnable prepareTable(@NotNull Runnable appendMoreUsageRunnable, @NotNull Runnable showInMaximalScopeRunnable) {
        if (appendMoreUsageRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(2);
        }
        if (showInMaximalScopeRunnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(3);
        }
        MySpeedSearch speedSearch = new MySpeedSearch(this);
        speedSearch.setComparator(new SpeedSearchComparator(false));
        this.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        this.setShowGrid(false);
        this.setShowVerticalLines(false);
        this.setShowHorizontalLines(false);
        this.setTableHeader(null);
        this.setAutoResizeMode(3);
        this.setIntercellSpacing(new Dimension(0, 0));
        AtomicReference selectedUsages = new AtomicReference();
        AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        AtomicReference filteredOutUsagesSelected = new AtomicReference();
        this.getSelectionModel().addListSelectionListener(e -> {
            selectedUsages.set(null);
            outsideScopeUsagesSelected.set(false);
            moreUsagesSelected.set(false);
            filteredOutUsagesSelected.set(null);
            ArrayList<Usage> usages = null;
            for (int i : this.getSelectedRows()) {
                Object value = this.getValueAt(i, 0);
                if (!(value instanceof UsageNode)) continue;
                Usage usage2 = ((UsageNode)value).getUsage();
                if (usage2 == this.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                    outsideScopeUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage2 == this.MORE_USAGES_SEPARATOR) {
                    moreUsagesSelected.set(true);
                    usages = null;
                    break;
                }
                if (usage2 == this.USAGES_FILTERED_OUT_SEPARATOR) {
                    filteredOutUsagesSelected.set((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)value)));
                    usages = null;
                    break;
                }
                if (usages == null) {
                    usages = new ArrayList<Usage>();
                }
                usages.add((Usage)(usage2 instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage2).getUsageInfo().copy() : usage2));
            }
            selectedUsages.set(usages);
        });
        Runnable runnable = () -> {
            if (moreUsagesSelected.get()) {
                appendMoreUsageRunnable.run();
                return;
            }
            if (outsideScopeUsagesSelected.get()) {
                showInMaximalScopeRunnable.run();
                return;
            }
            if (filteredOutUsagesSelected.get() != null) {
                ((ShowUsagesAction.FilteredOutUsagesNode)((Object)((Object)filteredOutUsagesSelected.get()))).onSelected();
                return;
            }
            List usages = (List)selectedUsages.get();
            if (usages != null) {
                for (Object usage2 : usages) {
                    if (usage2 instanceof UsageInfo) {
                        UsageInfo usageInfo = (UsageInfo)usage2;
                        UsageViewUtil.navigateTo((UsageInfo)usageInfo, (boolean)true);
                        PsiElement element2 = usageInfo.getElement();
                        if (element2 == null) continue;
                        UsageViewStatisticsCollector.logItemChosen((Project)element2.getProject(), (CodeNavigateSource)CodeNavigateSource.ShowUsagesPopup, (Language)element2.getLanguage());
                        continue;
                    }
                    if (!(usage2 instanceof Navigatable)) continue;
                    ((Navigatable)usage2).navigate(true);
                }
            }
        };
        if (runnable == null) {
            ShowUsagesTable.$$$reportNull$$$0(4);
        }
        return runnable;
    }

    public boolean isSeparatorNode(@Nullable Usage node2) {
        return node2 == this.USAGES_OUTSIDE_SCOPE_SEPARATOR || node2 == this.MORE_USAGES_SEPARATOR || node2 == this.USAGES_FILTERED_OUT_SEPARATOR;
    }

    @Nullable
    private static PsiElement getPsiElementForHint(Object selectedValue) {
        PsiElement element2;
        Usage usage2;
        if (selectedValue instanceof UsageNode && (usage2 = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element2 = ((UsageInfo2UsageAdapter)usage2).getElement()) != null) {
            PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element2);
            return view == null ? element2 : view;
        }
        return null;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data2) {
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(5);
        }
        return data2.isEmpty() || data2.get(0) instanceof ShowUsagesAction.StringNode ? 1 : 4;
    }

    @NotNull
    MyModel setTableModel(@NotNull List<UsageNode> data2) {
        MyModel model2;
        if (data2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesTable.calcColumnCount(data2);
        MyModel myModel = model2 = this.getModel() instanceof MyModel ? (MyModel)((Object)this.getModel()) : null;
        if (model2 == null || model2.getColumnCount() != columnCount) {
            model2 = new MyModel(data2, columnCount);
            this.setModel((TableModel)((Object)model2));
            for (int i = 0; i < this.getColumnModel().getColumnCount(); ++i) {
                TableColumn column = this.getColumnModel().getColumn(i);
                column.setPreferredWidth(0);
                column.setCellRenderer(this.myRenderer);
            }
        }
        MyModel myModel2 = model2;
        if (myModel2 == null) {
            ShowUsagesTable.$$$reportNull$$$0(7);
        }
        return myModel2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendMoreUsageRunnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "showInMaximalScopeRunnable";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTable";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareTable";
                break;
            }
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcColumnCount";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTableModel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<UsageNode> {
        private MyModel(@NotNull List<UsageNode> data2, int cols) {
            if (data2 == null) {
                MyModel.$$$reportNull$$$0(0);
            }
            super(MyModel.cols(cols), data2, 0);
        }

        private static ColumnInfo<UsageNode, UsageNode> @NotNull [] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node2) {
                    return node2;
                }
            };
            List<1> list2 = Collections.nCopies(cols, o);
            ColumnInfo[] columnInfoArray = list2.toArray(ColumnInfo.emptyArray());
            if (columnInfoArray == null) {
                MyModel.$$$reportNull$$$0(1);
            }
            return columnInfoArray;
        }

        @Override
        public void addToModel(int idx, UsageNode element2) {
            if (idx < this.getRowCount()) {
                this.insertRow(idx, element2);
            } else {
                this.addRow(element2);
            }
        }

        @Override
        public void removeRangeFromModel(int start2, int end) {
            for (int i = end; i >= start2; --i) {
                this.removeRow(i);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MyModel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "cols";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        MySpeedSearch(@NotNull ShowUsagesTable table) {
            if (table == null) {
                MySpeedSearch.$$$reportNull$$$0(0);
            }
            super((JComponent)((Object)table));
        }

        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        protected int getElementCount() {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().size();
        }

        protected Object getElementAt(int viewIndex) {
            return ((MyModel)((Object)this.getTable().getModel())).getItems().get(this.getTable().convertRowIndexToModel(viewIndex));
        }

        protected String getElementText(@NotNull Object element2) {
            if (element2 == null) {
                MySpeedSearch.$$$reportNull$$$0(1);
            }
            if (!(element2 instanceof UsageNode)) {
                return element2.toString();
            }
            UsageNode node2 = (UsageNode)element2;
            if (node2 instanceof ShowUsagesAction.StringNode) {
                return "";
            }
            Usage usage2 = node2.getUsage();
            if (usage2 == this.getTable().MORE_USAGES_SEPARATOR || usage2 == this.getTable().USAGES_OUTSIDE_SCOPE_SEPARATOR || usage2 == this.getTable().USAGES_FILTERED_OUT_SEPARATOR) {
                return "";
            }
            GroupNode group = (GroupNode)node2.getParent();
            String groupText = group == null ? "" : group.getGroup().getPresentableGroupText();
            return groupText + usage2.getPresentation().getPlainText();
        }

        protected void selectElement(Object element2, String selectedText) {
            List data2 = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i = data2.indexOf(element2);
            if (i == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private ShowUsagesTable getTable() {
            return (ShowUsagesTable)((Object)this.myComponent);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/find/actions/ShowUsagesTable$MySpeedSearch";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getElementText";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

