/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    private Utils() {
    }

    public static void showCompletionPopup(JComponent toolbarComponent, JList list2, @NlsContexts.PopupTitle String title, JTextComponent textField, @NlsContexts.PopupAdvertisement String ad, @Nullable PopupState<JBPopup> popupState) {
        Runnable callback = () -> {
            String selectedValue = (String)list2.getSelectedValue();
            if (selectedValue != null) {
                textField.setText(selectedValue);
                IdeFocusManager.getGlobalInstance().requestFocus((Component)textField, false);
            }
        };
        PopupChooserBuilder builder2 = JBPopupFactory.getInstance().createListPopupBuilder(list2);
        if (title != null) {
            builder2.setTitle(title);
        }
        JBPopup popup2 = builder2.setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(callback).createPopup();
        if (ad != null) {
            popup2.setAdText(ad, 2);
        }
        if (popupState != null) {
            popupState.prepareToShow((Object)popup2);
        }
        if (toolbarComponent != null) {
            popup2.showUnderneathOf((Component)toolbarComponent);
        } else {
            popup2.showUnderneathOf((Component)textField);
        }
    }

    public static void setSmallerFont(JComponent component2) {
        if (SystemInfo.isMac) {
            component2.setFont(JBUI.Fonts.smallFont());
        }
    }

    public static void setSmallerFontForChildren(JComponent component2) {
        for (Component c : component2.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            Utils.setSmallerFont((JComponent)c);
        }
    }

    @NotNull
    public static CustomShortcutSet shortcutSetOf(@NotNull List<Shortcut> shortcuts) {
        if (shortcuts == null) {
            Utils.$$$reportNull$$$0(0);
        }
        return new CustomShortcutSet(shortcuts.toArray(Shortcut.EMPTY_ARRAY));
    }

    @NotNull
    public static List<Shortcut> shortcutsOf(@NotNull String actionId) {
        AnAction action2;
        if (actionId == null) {
            Utils.$$$reportNull$$$0(1);
        }
        List<Shortcut> list2 = (action2 = ActionManager.getInstance().getAction(actionId)) == null ? ContainerUtil.emptyList() : ContainerUtil.immutableList(action2.getShortcutSet().getShortcuts());
        if (list2 == null) {
            Utils.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortcuts";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/editorHeaderActions/Utils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/editorHeaderActions/Utils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shortcutsOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shortcutSetOf";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shortcutsOf";
                break;
            }
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

