/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.FindSettings;
import com.intellij.find.impl.FindPopupDirectoryChooser;
import com.intellij.find.impl.FindPopupPanel;
import com.intellij.find.impl.FindPopupScopeUI;
import com.intellij.find.impl.FindUIHelper;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.dsl.gridLayout.builders.RowBuilder;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.ui.EmptyIcon;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FindPopupScopeUIImpl
implements FindPopupScopeUI {
    static final FindPopupScopeUI.ScopeType PROJECT = new FindPopupScopeUI.ScopeType("Project", FindBundle.messagePointer("find.popup.scope.project", new Object[0]), EmptyIcon.ICON_0);
    static final FindPopupScopeUI.ScopeType MODULE = new FindPopupScopeUI.ScopeType("Module", FindBundle.messagePointer("find.popup.scope.module", new Object[0]), EmptyIcon.ICON_0);
    static final FindPopupScopeUI.ScopeType DIRECTORY = new FindPopupScopeUI.ScopeType("Directory", FindBundle.messagePointer("find.popup.scope.directory", new Object[0]), EmptyIcon.ICON_0);
    static final FindPopupScopeUI.ScopeType SCOPE = new FindPopupScopeUI.ScopeType("Scope", FindBundle.messagePointer("find.popup.scope.scope", new Object[0]), EmptyIcon.ICON_0);
    @NotNull
    private final FindUIHelper myHelper;
    @NotNull
    private final Project myProject;
    @NotNull
    private final FindPopupPanel myFindPopupPanel;
    private final Pair<FindPopupScopeUI.ScopeType, JComponent> @NotNull [] myComponents;
    private ComboBox<String> myModuleComboBox;
    private FindPopupDirectoryChooser myDirectoryChooser;
    private ScopeChooserCombo myScopeCombo;

    FindPopupScopeUIImpl(@NotNull FindPopupPanel panel2) {
        if (panel2 == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(0);
        }
        this.myHelper = panel2.getHelper();
        this.myProject = panel2.getProject();
        this.myFindPopupPanel = panel2;
        this.initComponents();
        boolean fullVersion = !PlatformUtils.isDataGrip();
        this.myComponents = fullVersion ? ContainerUtil.ar(new Pair<FindPopupScopeUI.ScopeType, JLabel>(PROJECT, new JLabel()), new Pair<FindPopupScopeUI.ScopeType, JComponent>(MODULE, FindPopupScopeUIImpl.shrink(this.myModuleComboBox)), new Pair<FindPopupScopeUI.ScopeType, FindPopupDirectoryChooser>(DIRECTORY, this.myDirectoryChooser), new Pair<FindPopupScopeUI.ScopeType, JComponent>(SCOPE, FindPopupScopeUIImpl.shrink((JComponent)((Object)this.myScopeCombo)))) : ContainerUtil.ar(new Pair<FindPopupScopeUI.ScopeType, JComponent>(SCOPE, FindPopupScopeUIImpl.shrink((JComponent)((Object)this.myScopeCombo))), new Pair<FindPopupScopeUI.ScopeType, FindPopupDirectoryChooser>(DIRECTORY, this.myDirectoryChooser));
    }

    public void initComponents() {
        Module[] modules2 = ModuleManager.getInstance(this.myProject).getModules();
        Object[] names = new String[modules2.length];
        for (int i = 0; i < modules2.length; ++i) {
            names[i] = modules2[i].getName();
        }
        Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
        this.myModuleComboBox = new ComboBox(names);
        this.myModuleComboBox.setSwingPopup(false);
        this.myModuleComboBox.setMinimumAndPreferredWidth(JBUIScale.scale(300));
        this.myModuleComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", Functions.id()));
        ActionListener restartSearchListener = e -> this.scheduleResultsUpdate();
        this.myModuleComboBox.addActionListener(restartSearchListener);
        this.myDirectoryChooser = new FindPopupDirectoryChooser(this.myFindPopupPanel);
        this.myScopeCombo = new ScopeChooserCombo();
        String selection = ObjectUtils.coalesce(this.myHelper.getModel().getCustomScope(), this.myHelper.getModel().getCustomScopeName(), FindSettings.getInstance().getDefaultScopeName());
        this.myScopeCombo.init(this.myProject, true, true, selection, (Condition<? super ScopeDescriptor>)new Condition<ScopeDescriptor>(){
            final String moduleFilesScopeName;
            {
                String moduleScopeName = IndexingBundle.message((String)"search.scope.module", (Object[])new Object[]{""});
                int ind = moduleScopeName.indexOf(32);
                this.moduleFilesScopeName = moduleScopeName.substring(0, ind + 1);
            }

            @Override
            public boolean value(ScopeDescriptor descriptor) {
                String display = descriptor.getDisplayName();
                return !display.startsWith(this.moduleFilesScopeName);
            }
        });
        this.myScopeCombo.setBrowseListener(new ScopeChooserCombo.BrowseListener(){
            private FindModel myModelSnapshot;

            @Override
            public void onBeforeBrowseStarted() {
                this.myModelSnapshot = FindPopupScopeUIImpl.this.myHelper.getModel();
                FindPopupScopeUIImpl.this.myFindPopupPanel.getCanClose().set(false);
            }

            @Override
            public void onAfterBrowseFinished() {
                if (this.myModelSnapshot != null) {
                    SearchScope scope = FindPopupScopeUIImpl.this.myScopeCombo.getSelectedScope();
                    if (scope != null) {
                        this.myModelSnapshot.setCustomScope(scope);
                    }
                    FindPopupScopeUIImpl.this.myFindPopupPanel.getCanClose().set(true);
                }
            }
        });
        this.myScopeCombo.getComboBox().addActionListener(restartSearchListener);
        Disposer.register(this.myFindPopupPanel.getDisposable(), this.myScopeCombo);
    }

    @Override
    public Pair<FindPopupScopeUI.ScopeType, JComponent> @NotNull [] getComponents() {
        if (this.myComponents == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(1);
        }
        return this.myComponents;
    }

    @Override
    public void applyTo(@NotNull FindSettings findSettings, @NotNull FindPopupScopeUI.ScopeType selectedScope) {
        if (findSettings == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(2);
        }
        if (selectedScope == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(3);
        }
        findSettings.setDefaultScopeName(this.myScopeCombo.getSelectedScopeName());
    }

    @Override
    public void applyTo(@NotNull FindModel findModel, @NotNull FindPopupScopeUI.ScopeType selectedScope) {
        if (findModel == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(4);
        }
        if (selectedScope == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(5);
        }
        if (selectedScope == PROJECT) {
            findModel.setProjectScope(true);
        } else if (selectedScope == DIRECTORY) {
            String directory = this.myDirectoryChooser.getDirectory();
            findModel.setDirectoryName(directory);
        } else if (selectedScope == MODULE) {
            findModel.setModuleName((String)this.myModuleComboBox.getSelectedItem());
        } else if (selectedScope == SCOPE) {
            SearchScope selectedCustomScope = this.myScopeCombo.getSelectedScope();
            String customScopeName = selectedCustomScope == null ? null : selectedCustomScope.getDisplayName();
            findModel.setCustomScopeName(customScopeName);
            findModel.setCustomScope(selectedCustomScope);
            findModel.setCustomScope(true);
        }
    }

    @Override
    @Nullable
    public ValidationInfo validate(@NotNull FindModel model2, FindPopupScopeUI.ScopeType selectedScope) {
        if (model2 == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(6);
        }
        if (selectedScope == DIRECTORY) {
            return this.myDirectoryChooser.validate(model2);
        }
        return null;
    }

    @Override
    public boolean hideAllPopups() {
        JComboBox[] candidates;
        for (JComboBox candidate : candidates = new JComboBox[]{this.myModuleComboBox, this.myScopeCombo.getComboBox(), this.myDirectoryChooser.getComboBox()}) {
            if (!candidate.isPopupVisible()) continue;
            candidate.hidePopup();
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public FindPopupScopeUI.ScopeType initByModel(@NotNull FindModel findModel) {
        FindPopupScopeUI.ScopeType selectedScope;
        Module module;
        VirtualFile dir;
        if (findModel == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(7);
        }
        this.myDirectoryChooser.initByModel(findModel);
        String dirName = findModel.getDirectoryName();
        if (!StringUtil.isEmptyOrSpaces(dirName) && (dir = LocalFileSystem.getInstance().findFileByPath(dirName)) != null && (module = ModuleUtilCore.findModuleForFile(dir, this.myProject)) != null) {
            this.myModuleComboBox.setSelectedItem((Object)module.getName());
        }
        FindPopupScopeUI.ScopeType scope = this.getScope(findModel);
        FindPopupScopeUI.ScopeType scopeType = selectedScope = Arrays.stream(this.myComponents).filter(o -> o.first == scope).findFirst().orElse(null) == null ? (FindPopupScopeUI.ScopeType)this.myComponents[0].first : scope;
        if (selectedScope == MODULE) {
            this.myModuleComboBox.setSelectedItem((Object)findModel.getModuleName());
        }
        FindPopupScopeUI.ScopeType scopeType2 = selectedScope;
        if (scopeType2 == null) {
            FindPopupScopeUIImpl.$$$reportNull$$$0(8);
        }
        return scopeType2;
    }

    private static JComponent shrink(JComponent toShrink) {
        JPanel wrapper2 = new JPanel();
        new RowBuilder(wrapper2).add(new JComponent[]{toShrink});
        return wrapper2;
    }

    private void scheduleResultsUpdate() {
        this.myFindPopupPanel.scheduleResultsUpdate();
    }

    private FindPopupScopeUI.ScopeType getScope(FindModel model2) {
        if (model2.isCustomScope()) {
            return SCOPE;
        }
        if (model2.isProjectScope()) {
            return PROJECT;
        }
        if (model2.getDirectoryName() != null) {
            return DIRECTORY;
        }
        if (model2.getModuleName() != null) {
            return MODULE;
        }
        return PROJECT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/impl/FindPopupScopeUIImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findSettings";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedScope";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "findModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/impl/FindPopupScopeUIImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "initByModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initByModel";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

