/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.impl.FileAndLineTextRenderer;
import com.intellij.find.impl.SearchEverywhereItem;
import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usages.TextChunk;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

class TextSearchRenderer
extends JPanel
implements ListCellRenderer<SearchEverywhereItem> {
    private final ColoredListCellRenderer<SearchEverywhereItem> myUsageRenderer = new ColoredListCellRenderer<SearchEverywhereItem>(){

        protected void customizeCellRenderer(@NotNull JList<? extends SearchEverywhereItem> list2, SearchEverywhereItem value, int index, boolean selected, boolean hasFocus) {
            if (list2 == null) {
                1.$$$reportNull$$$0(0);
            }
            TextChunk[] text2 = value.getPresentation().getText();
            for (int i = 1; i < text2.length; ++i) {
                TextChunk textChunk = text2[i];
                TextSearchRenderer.this.myUsageRenderer.append(textChunk.getText(), this.getAttributes(textChunk, selected));
            }
            TextSearchRenderer.this.myUsageRenderer.setIcon(AllIcons.Nodes.TextArea);
            TextSearchRenderer.this.myUsageRenderer.setIpad(new Insets(0, 0, 0, this.getIpad().right));
            this.setBorder(null);
        }

        @NotNull
        private SimpleTextAttributes getAttributes(@NotNull TextChunk textChunk, boolean selected) {
            SimpleTextAttributes attributes;
            if (textChunk == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((attributes = textChunk.getSimpleAttributesIgnoreBackground()).getFontStyle() != 1) {
                SimpleTextAttributes simpleTextAttributes = attributes;
                if (simpleTextAttributes == null) {
                    1.$$$reportNull$$$0(2);
                }
                return simpleTextAttributes;
            }
            return new SimpleTextAttributes(null, attributes.getFgColor(), attributes.getWaveColor(), attributes.getStyle() & 0xFFFFFFFE | (selected ? 64 : 0));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "textChunk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/find/impl/TextSearchRenderer$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/find/impl/TextSearchRenderer$1";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getAttributes";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final ColoredListCellRenderer<SearchEverywhereItem> myFileAndLineNumber = new FileAndLineTextRenderer();

    TextSearchRenderer() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.myUsageRenderer, "Center");
        this.add((Component)this.myFileAndLineNumber, "East");
        this.setBorder(JBUI.Borders.empty(2, 2, 2, 0));
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends SearchEverywhereItem> list2, SearchEverywhereItem value, int index, boolean isSelected, boolean cellHasFocus) {
        this.myUsageRenderer.getListCellRendererComponent(list2, (Object)value, index, isSelected, cellHasFocus);
        this.myFileAndLineNumber.getListCellRendererComponent(list2, (Object)value, index, isSelected, cellHasFocus);
        this.setBackground(this.myUsageRenderer.getBackground());
        if (!isSelected) {
            Color color = value.getPresentation().getBackgroundColor();
            this.setBackground(color);
            this.myUsageRenderer.setBackground(color);
            this.myFileAndLineNumber.setBackground(color);
        }
        this.getAccessibleContext().setAccessibleName(FindBundle.message("find.popup.found.element.accesible.name", this.myUsageRenderer.getAccessibleContext().getAccessibleName(), this.myFileAndLineNumber.getAccessibleContext().getAccessibleName()));
        return this;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new StateSetAccessibleJPanel();
        }
        return this.accessibleContext;
    }

    class StateSetAccessibleJPanel
    extends JPanel.AccessibleJPanel {
        StateSetAccessibleJPanel() {
            super(TextSearchRenderer.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.UNKNOWN;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet stateSet = new AccessibleStateSet();
            stateSet.addAll(TextSearchRenderer.this.myUsageRenderer.getAccessibleContext().getAccessibleStateSet().toArray());
            stateSet.addAll(TextSearchRenderer.this.myFileAndLineNumber.getAccessibleContext().getAccessibleStateSet().toArray());
            return stateSet;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            return null;
        }
    }
}

