/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.find.impl.UsagePresentation;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.VfsPresentationUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\"\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getFilePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "usage", "Lcom/intellij/usages/UsageInfo2UsageAdapter;", "usagePresentation", "Lcom/intellij/find/impl/UsagePresentation;", "Lcom/intellij/usages/UsageInfoAdapter;", "intellij.platform.lang.impl"})
public final class UiModelKt {
    @Nullable
    public static final UsagePresentation usagePresentation(@NotNull Project project2, @NotNull GlobalSearchScope scope, @NotNull UsageInfoAdapter usage2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)usage2, (String)"usage");
        return usage2 instanceof UsageInfo2UsageAdapter ? UiModelKt.usagePresentation(project2, scope, (UsageInfo2UsageAdapter)usage2) : null;
    }

    @NotNull
    public static final UsagePresentation usagePresentation(@NotNull Project project2, @NotNull GlobalSearchScope scope, @NotNull UsageInfo2UsageAdapter usage2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)usage2, (String)"usage");
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        com.intellij.usages.UsagePresentation usagePresentation = usage2.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)usagePresentation, (String)"usage.presentation");
        TextChunk[] textChunkArray = usagePresentation.getText();
        Intrinsics.checkNotNullExpressionValue((Object)textChunkArray, (String)"usage.presentation.text");
        TextChunk[] text2 = textChunkArray;
        return new UsagePresentation(text2, VfsPresentationUtil.getFileBackgroundColor((Project)project2, (VirtualFile)usage2.getFile()), UiModelKt.getFilePath(project2, scope, usage2));
    }

    private static final String getFilePath(Project project2, GlobalSearchScope scope, UsageInfo2UsageAdapter usage2) {
        String string2;
        VirtualFile virtualFile2 = usage2.getFile();
        if (virtualFile2 == null) {
            return "";
        }
        VirtualFile file2 = virtualFile2;
        if (ScratchUtil.isScratch(file2)) {
            String string3 = ScratchUtil.getRelativePath(project2, file2);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ScratchUtil.getRelativePath(project, file)");
        } else {
            String string4 = UniqueVFilePathBuilder.getInstance().getUniqueVirtualFilePath(project2, file2, scope);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"UniqueVFilePathBuilder.g\u2026ath(project, file, scope)");
        }
        return string2;
    }
}

