/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.usages.impl;

import com.intellij.find.usages.api.PsiUsage;
import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.find.usages.api.UsageOptions;
import com.intellij.find.usages.impl.AllSearchOptions;
import com.intellij.find.usages.impl.DefaultUsageSearchParameters;
import com.intellij.find.usages.impl.ImplKt;
import com.intellij.find.usages.symbol.SearchTargetSymbol;
import com.intellij.find.usages.symbol.SymbolSearchTargetFactory;
import com.intellij.model.Symbol;
import com.intellij.model.psi.impl.TargetsKt;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchParameters;
import com.intellij.model.search.SearchRequest;
import com.intellij.model.search.SearchService;
import com.intellij.model.search.impl.TextSearchKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClassExtension;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.usages.Usage;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\u001aB\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0011H\u0007\u001aB\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0007\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\u0011H\u0007\u001a\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007\u001a\u001a\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007\u001a$\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u00152\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001fH\u0000\u001a\f\u0010 \u001a\u00020!*\u00020\rH\u0000\"\u0018\u0010\u0000\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"SYMBOL_SEARCH_TARGET_EXTENSION", "Lcom/intellij/openapi/util/ClassExtension;", "Lcom/intellij/find/usages/symbol/SymbolSearchTargetFactory;", "textSearchContexts", "", "Lcom/intellij/model/search/SearchContext;", "buildQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/find/usages/api/Usage;", "O", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/find/usages/api/SearchTarget;", "handler", "Lcom/intellij/find/usages/api/UsageHandler;", "allOptions", "Lcom/intellij/find/usages/impl/AllSearchOptions;", "buildUsageViewQuery", "Lcom/intellij/usages/Usage;", "searchTargets", "", "file", "Lcom/intellij/psi/PsiFile;", "offset", "", "symbolSearchTarget", "symbol", "Lcom/intellij/model/Symbol;", "symbolSearchTargets", "targetSymbols", "", "hasTextSearchStrings", "", "intellij.platform.lang.impl"})
public final class ImplKt {
    private static final ClassExtension<SymbolSearchTargetFactory<?>> SYMBOL_SEARCH_TARGET_EXTENSION = new ClassExtension("com.intellij.lang.symbolSearchTarget");
    private static final Set<SearchContext> textSearchContexts;

    @ApiStatus.Internal
    @NotNull
    public static final List<SearchTarget> searchTargets(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Collection<Symbol> targetSymbols = TargetsKt.targetSymbols(file2, offset);
        if (targetSymbols.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Project project2 = file2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        return ImplKt.symbolSearchTargets(project2, targetSymbols);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SearchTarget> symbolSearchTargets(@NotNull Project project2, @NotNull Collection<? extends Symbol> targetSymbols) {
        void var3_3;
        void $this$mapNotNullTo$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(targetSymbols, (String)"targetSymbols");
        Iterable iterable = targetSymbols;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            SearchTarget searchTarget;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            Symbol it = (Symbol)element$iv;
            boolean bl2 = false;
            if (ImplKt.symbolSearchTarget(project2, it) == null) continue;
            SearchTarget it$iv = searchTarget;
            boolean bl3 = false;
            destination$iv.add(it$iv);
        }
        return CollectionsKt.toList((Iterable)((Iterable)var3_3));
    }

    @ApiStatus.Internal
    @Nullable
    public static final SearchTarget symbolSearchTarget(@NotNull Project project2, @NotNull Symbol symbol) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        for (SymbolSearchTargetFactory factory2 : SYMBOL_SEARCH_TARGET_EXTENSION.forKey(symbol.getClass())) {
            SymbolSearchTargetFactory factory_;
            if (factory2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.find.usages.symbol.SymbolSearchTargetFactory<com.intellij.model.Symbol>");
            }
            SearchTarget target2 = factory_.searchTarget(project2, symbol);
            if (target2 == null) continue;
            return target2;
        }
        if (symbol instanceof SearchTargetSymbol) {
            return ((SearchTargetSymbol)symbol).getSearchTarget();
        }
        if (symbol instanceof SearchTarget) {
            return (SearchTarget)((Object)symbol);
        }
        return null;
    }

    @ApiStatus.Internal
    @NotNull
    public static final <O> Query<? extends Usage> buildUsageViewQuery(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler, @NotNull AllSearchOptions<O> allOptions) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(allOptions, (String)"allOptions");
        Query query2 = ImplKt.buildQuery(project2, target2, handler, allOptions).transforming(buildUsageViewQuery.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(query2, (String)"buildQuery(project, targ\u2026    emptyList()\n    }\n  }");
        return query2;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final <O> Query<? extends com.intellij.find.usages.api.Usage> buildQuery(@NotNull Project project2, @NotNull SearchTarget target2, @NotNull UsageHandler<O> handler, @NotNull AllSearchOptions<O> allOptions) {
        void textSearch;
        Query query2;
        void options;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target2, (String)"target");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(allOptions, (String)"allOptions");
        ArrayList queries = new ArrayList();
        Object object = allOptions;
        UsageOptions usageOptions = ((AllSearchOptions)object).component1();
        Boolean bl = ((AllSearchOptions)object).component2();
        O customOptions = ((AllSearchOptions)object).component3();
        if (options.isUsages()) {
            object = queries;
            SearchService searchService = SearchService.getInstance();
            SearchScope searchScope2 = options.getSearchScope();
            Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"options.searchScope");
            query2 = searchService.searchParameters((SearchParameters)new DefaultUsageSearchParameters(project2, target2, searchScope2));
            object.add(query2);
        }
        object = queries;
        query2 = handler.buildSearchQuery((UsageOptions)options, customOptions);
        object.add(query2);
        if (Intrinsics.areEqual((Object)textSearch, (Object)true)) {
            Iterable $this$mapTo$iv = target2.getTextSearchRequests();
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void searchRequest;
                SearchRequest searchRequest2 = (SearchRequest)item$iv;
                Collection collection = queries;
                boolean bl2 = false;
                SearchScope searchScope3 = options.getSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope3, (String)"options.searchScope");
                Query<? extends PsiUsage> query3 = TextSearchKt.buildTextUsageQuery(project2, (SearchRequest)searchRequest, searchScope3, textSearchContexts);
                Object object2 = buildQuery.1.1.INSTANCE;
                if (object2 != null) {
                    Function1 function1 = object2;
                    object2 = new Function(function1){
                        private final /* synthetic */ Function1 function;
                        {
                            this.function = function1;
                        }

                        public final /* synthetic */ Object apply(Object p0) {
                            return this.function.invoke(p0);
                        }
                    };
                }
                Query query4 = query3.mapping((Function)object2);
                collection.add(query4);
            }
        }
        Query query5 = SearchService.getInstance().merge((List)queries);
        Intrinsics.checkNotNullExpressionValue((Object)query5, (String)"SearchService.getInstance().merge(queries)");
        return query5;
    }

    public static final boolean hasTextSearchStrings(@NotNull SearchTarget $this$hasTextSearchStrings) {
        Intrinsics.checkNotNullParameter((Object)$this$hasTextSearchStrings, (String)"$this$hasTextSearchStrings");
        Collection<SearchRequest> collection = $this$hasTextSearchStrings.getTextSearchRequests();
        return !collection.isEmpty();
    }

    static {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)SearchContext.IN_COMMENTS, (Enum)SearchContext.IN_STRINGS, (Enum)SearchContext.IN_PLAIN_TEXT);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"EnumSet.of(\n  SearchCont\u2026chContext.IN_PLAIN_TEXT\n)");
        textSearchContexts = enumSet;
    }
}

