/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.commandLine.FileSetCodeStyleProcessorKt;
import com.intellij.formatting.commandLine.FileSetProcessor;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import java.io.Closeable;
import java.nio.charset.Charset;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0006H\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H&J\u001a\u0010#\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\b\u0010$\u001a\u0004\u0018\u00010\nH\u0016J)\u0010%\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020\n2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)H\u0002\u00a2\u0006\u0002\u0010*R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0012\u0010\u0013\u001a\u00020\u0010X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0019\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/formatting/commandLine/FileSetCodeStyleProcessor;", "Lcom/intellij/formatting/commandLine/FileSetProcessor;", "Ljava/io/Closeable;", "messageOutput", "Lcom/intellij/formatting/commandLine/MessageOutput;", "isRecursive", "", "charset", "Ljava/nio/charset/Charset;", "primaryCodeStyle", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "defaultCodeStyle", "(Lcom/intellij/formatting/commandLine/MessageOutput;ZLjava/nio/charset/Charset;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "getDefaultCodeStyle", "()Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "operationContinuous", "", "getOperationContinuous", "()Ljava/lang/String;", "operationPerfect", "getOperationPerfect", "getPrimaryCodeStyle", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/Nullable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectUID", "close", "", "isResultSuccessful", "printReport", "processFileInternal", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "processVirtualFile", "projectSettings", "withStyleSettings", "T", "style", "body", "Lkotlin/Function0;", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.platform.lang.impl"})
public abstract class FileSetCodeStyleProcessor
extends FileSetProcessor
implements Closeable {
    private final String projectUID;
    @NotNull
    private final Project project;
    @Nullable
    private final CodeStyleSettings primaryCodeStyle;
    @Nullable
    private final CodeStyleSettings defaultCodeStyle;

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    public abstract String getOperationContinuous();

    @NotNull
    public abstract String getOperationPerfect();

    @NotNull
    public abstract String processFileInternal(@NotNull VirtualFile var1);

    public void printReport() {
        this.getMessageOutput().info("\n");
        this.getMessageOutput().info(this.getTotal() + " file(s) scanned.\n");
        this.getMessageOutput().info(this.getProcessed() + " file(s) " + this.getOperationPerfect() + ".\n");
    }

    public boolean isResultSuccessful() {
        return true;
    }

    @Override
    public void close() {
        ProjectManager.getInstance().closeAndDispose(this.project);
    }

    @Override
    public void processVirtualFile(@NotNull VirtualFile virtualFile2, @Nullable CodeStyleSettings projectSettings) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        this.getMessageOutput().info(this.getOperationContinuous() + " " + virtualFile2.getCanonicalPath() + "...");
        CodeStyleSettings style = (CodeStyleSettings)CollectionsKt.firstOrNull((List)CollectionsKt.listOfNotNull((Object[])new CodeStyleSettings[]{this.primaryCodeStyle, projectSettings, this.defaultCodeStyle}));
        if (style == null) {
            this.getMessageOutput().error("No style for " + virtualFile2.getCanonicalPath() + ", skipping...");
            this.getStatistics().fileProcessed(true);
            return;
        }
        this.withStyleSettings(style, (Function0)new Function0<Unit>(this, virtualFile2){
            final /* synthetic */ FileSetCodeStyleProcessor this$0;
            final /* synthetic */ VirtualFile $virtualFile;

            public final void invoke() {
                VfsUtil.markDirtyAndRefresh(false, false, false, this.$virtualFile);
                FileType fileType = this.$virtualFile.getFileType();
                Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"virtualFile.fileType");
                String resultMessage = fileType.isBinary() ? "Skipped, binary file." : this.this$0.processFileInternal(this.$virtualFile);
                this.this$0.getMessageOutput().info(resultMessage + "\n");
            }
            {
                this.this$0 = fileSetCodeStyleProcessor;
                this.$virtualFile = virtualFile2;
                super(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withStyleSettings(CodeStyleSettings style, Function0<? extends T> body) {
        CodeStyleSettingsManager cssManager;
        CodeStyleSettingsManager codeStyleSettingsManager = cssManager = CodeStyleSettingsManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsManager, (String)"cssManager");
        CodeStyleSettings codeStyleSettings = codeStyleSettingsManager.getMainProjectCodeStyle();
        Intrinsics.checkNotNull((Object)codeStyleSettings);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"cssManager.mainProjectCodeStyle!!");
        CodeStyleSettings tmp = codeStyleSettings;
        try {
            CodeStyle.setMainProjectSettings((Project)this.project, (CodeStyleSettings)style);
            Object object = body.invoke();
            return (T)object;
        }
        finally {
            CodeStyle.setMainProjectSettings((Project)this.project, (CodeStyleSettings)tmp);
        }
    }

    @Nullable
    public final CodeStyleSettings getPrimaryCodeStyle() {
        return this.primaryCodeStyle;
    }

    @Nullable
    public final CodeStyleSettings getDefaultCodeStyle() {
        return this.defaultCodeStyle;
    }

    public FileSetCodeStyleProcessor(@NotNull MessageOutput messageOutput, boolean isRecursive, @Nullable Charset charset, @Nullable CodeStyleSettings primaryCodeStyle, @Nullable CodeStyleSettings defaultCodeStyle) {
        Intrinsics.checkNotNullParameter((Object)messageOutput, (String)"messageOutput");
        super(messageOutput, isRecursive, charset);
        this.primaryCodeStyle = primaryCodeStyle;
        this.defaultCodeStyle = defaultCodeStyle;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"UUID.randomUUID().toString()");
        this.projectUID = string2;
        this.project = FileSetCodeStyleProcessorKt.access$createProject(this.projectUID);
    }

    public /* synthetic */ FileSetCodeStyleProcessor(MessageOutput messageOutput, boolean bl, Charset charset, CodeStyleSettings codeStyleSettings, CodeStyleSettings codeStyleSettings2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        if ((n & 8) != 0) {
            codeStyleSettings = null;
        }
        if ((n & 0x10) != 0) {
            codeStyleSettings2 = null;
        }
        this(messageOutput, bl, charset, codeStyleSettings, codeStyleSettings2);
    }
}

