/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.commandLine.FileSetCodeStyleProcessor;
import com.intellij.formatting.commandLine.FileSetCodeStyleProcessorKt;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.util.LocalTimeCounter;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\rH\u0002J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0015H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/formatting/commandLine/FileSetFormatValidator;", "Lcom/intellij/formatting/commandLine/FileSetCodeStyleProcessor;", "messageOutput", "Lcom/intellij/formatting/commandLine/MessageOutput;", "isRecursive", "", "charset", "Ljava/nio/charset/Charset;", "primaryCodeStyle", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "defaultCodeStyle", "(Lcom/intellij/formatting/commandLine/MessageOutput;ZLjava/nio/charset/Charset;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "operationContinuous", "", "getOperationContinuous", "()Ljava/lang/String;", "operationPerfect", "getOperationPerfect", "createPsiCopy", "Lcom/intellij/psi/PsiFile;", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "originalContent", "isResultSuccessful", "printReport", "", "processFileInternal", "virtualFile", "intellij.platform.lang.impl"})
public final class FileSetFormatValidator
extends FileSetCodeStyleProcessor {
    @NotNull
    private final String operationContinuous;
    @NotNull
    private final String operationPerfect;

    @Override
    @NotNull
    public String getOperationContinuous() {
        return this.operationContinuous;
    }

    @Override
    @NotNull
    public String getOperationPerfect() {
        return this.operationPerfect;
    }

    @Override
    public void printReport() {
        super.printReport();
        this.getMessageOutput().info(this.getSucceeded() + " file(s) are well formed.\n");
    }

    @Override
    public boolean isResultSuccessful() {
        return this.getSucceeded() == this.getProcessed();
    }

    @Override
    @NotNull
    public String processFileInternal(@NotNull VirtualFile virtualFile2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            FileSetCodeStyleProcessorKt.access$getLOG$p().warn("No document available for " + virtualFile2.getPath());
            return "Failed";
        }
        String string3 = document.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"document.text");
        String originalContent = string3;
        PsiFile psiCopy = this.createPsiCopy(virtualFile2, originalContent);
        CodeStyleManager.getInstance(this.getProject()).reformatText(psiCopy, 0, psiCopy.getTextLength());
        String reformattedContent = psiCopy.getText();
        if (Intrinsics.areEqual((Object)originalContent, (Object)reformattedContent)) {
            this.getStatistics().fileProcessed(true);
            string2 = "Formatted well";
        } else {
            this.getStatistics().fileProcessed(false);
            string2 = "Needs reformatting";
        }
        return string2;
    }

    private final PsiFile createPsiCopy(VirtualFile originalFile, String originalContent) {
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance(this.getProject());
        FileType fileType = originalFile.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"originalFile.fileType");
        PsiFile psiFile = psiFileFactory.createFileFromText("a." + fileType.getDefaultExtension(), originalFile.getFileType(), (CharSequence)originalContent, LocalTimeCounter.currentTime(), false);
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiFileFactory.getInstan\u2026Time(),\n      false\n    )");
        PsiFile psiCopy = psiFile;
        PsiFile originalPsi = PsiManager.getInstance(this.getProject()).findFile(originalFile);
        if (originalPsi != null) {
            psiCopy.putUserData(PsiFileFactory.ORIGINAL_FILE, originalPsi);
        }
        return psiCopy;
    }

    public FileSetFormatValidator(@NotNull MessageOutput messageOutput, boolean isRecursive, @Nullable Charset charset, @Nullable CodeStyleSettings primaryCodeStyle, @Nullable CodeStyleSettings defaultCodeStyle) {
        Intrinsics.checkNotNullParameter((Object)messageOutput, (String)"messageOutput");
        super(messageOutput, isRecursive, charset, primaryCodeStyle, defaultCodeStyle);
        this.operationContinuous = "Checking";
        this.operationPerfect = "checked";
    }

    public /* synthetic */ FileSetFormatValidator(MessageOutput messageOutput, boolean bl, Charset charset, CodeStyleSettings codeStyleSettings, CodeStyleSettings codeStyleSettings2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        if ((n & 8) != 0) {
            codeStyleSettings = null;
        }
        if ((n & 0x10) != 0) {
            codeStyleSettings2 = null;
        }
        this(messageOutput, bl, charset, codeStyleSettings, codeStyleSettings2);
    }
}

