/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.commandLine.FileSetCodeStyleProcessor;
import com.intellij.formatting.commandLine.FileSetCodeStyleProcessorKt;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/formatting/commandLine/FileSetFormatter;", "Lcom/intellij/formatting/commandLine/FileSetCodeStyleProcessor;", "messageOutput", "Lcom/intellij/formatting/commandLine/MessageOutput;", "isRecursive", "", "charset", "Ljava/nio/charset/Charset;", "primaryCodeStyle", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "defaultCodeStyle", "(Lcom/intellij/formatting/commandLine/MessageOutput;ZLjava/nio/charset/Charset;Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "operationContinuous", "", "getOperationContinuous", "()Ljava/lang/String;", "operationPerfect", "getOperationPerfect", "closeOpenFiles", "", "processFileInternal", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "reformatFile", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.lang.impl"})
public final class FileSetFormatter
extends FileSetCodeStyleProcessor {
    @NotNull
    private final String operationContinuous;
    @NotNull
    private final String operationPerfect;

    @Override
    @NotNull
    public String getOperationContinuous() {
        return this.operationContinuous;
    }

    @Override
    @NotNull
    public String getOperationPerfect() {
        return this.operationPerfect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String processFileInternal(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            FileSetCodeStyleProcessorKt.access$getLOG$p().warn("No document available for " + virtualFile2.getPath());
            return "Failed";
        }
        try {
            PsiFile psiFile = PsiDocumentManager.getInstance(this.getProject()).getPsiFile(document);
            NonProjectFileWritingAccessProvider.allowWriting((Iterable)CollectionsKt.listOf((Object)virtualFile2));
            if (psiFile == null) {
                FileSetCodeStyleProcessorKt.access$getLOG$p().warn("Unable to get a PSI file for " + virtualFile2.getPath());
                String string2 = "Failed";
                return string2;
            }
            if (!FileSetCodeStyleProcessorKt.access$isFormattingSupported(psiFile)) {
                String string3 = "Skipped, not supported.";
                return string3;
            }
            try {
                this.reformatFile(psiFile, document);
            }
            catch (ProcessCanceledException pce) {
                Object object;
                Object object2 = pce.getCause();
                if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                    object2 = object = pce.getMessage();
                }
                if (object2 == null) {
                    object = "";
                }
                Object cause = object;
                FileSetCodeStyleProcessorKt.access$getLOG$p().warn(virtualFile2.getCanonicalPath() + ": Skipped, rejected by formatter. " + (String)cause);
                String string4 = "Skipped, rejected by formatter.";
                this.closeOpenFiles();
                return string4;
            }
            FileDocumentManager.getInstance().saveDocument(document);
        }
        finally {
            this.closeOpenFiles();
        }
        this.getStatistics().fileProcessed(true);
        return "OK";
    }

    private final void reformatFile(PsiFile file2, Document document) {
        WriteCommandAction.runWriteCommandAction(this.getProject(), new Runnable(this, file2, document){
            final /* synthetic */ FileSetFormatter this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Document $document;

            public final void run() {
                CodeStyleManager codeStyleManager = CodeStyleManager.getInstance(this.this$0.getProject());
                codeStyleManager.reformatText(this.$file, 0, this.$file.getTextLength());
                PsiDocumentManager.getInstance(this.this$0.getProject()).commitDocument(this.$document);
            }
            {
                this.this$0 = fileSetFormatter;
                this.$file = psiFile;
                this.$document = document;
            }
        });
    }

    private final void closeOpenFiles() {
        VirtualFile[] openFiles;
        FileEditorManager editorManager;
        FileEditorManager fileEditorManager = editorManager = FileEditorManager.getInstance(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"editorManager");
        for (VirtualFile openFile : openFiles = fileEditorManager.getOpenFiles()) {
            editorManager.closeFile(openFile);
        }
    }

    public FileSetFormatter(@NotNull MessageOutput messageOutput, boolean isRecursive, @Nullable Charset charset, @Nullable CodeStyleSettings primaryCodeStyle, @Nullable CodeStyleSettings defaultCodeStyle) {
        Intrinsics.checkNotNullParameter((Object)messageOutput, (String)"messageOutput");
        super(messageOutput, isRecursive, charset, primaryCodeStyle, defaultCodeStyle);
        this.operationContinuous = "Formatting";
        this.operationPerfect = "formatted";
    }

    public /* synthetic */ FileSetFormatter(MessageOutput messageOutput, boolean bl, Charset charset, CodeStyleSettings codeStyleSettings, CodeStyleSettings codeStyleSettings2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            charset = null;
        }
        if ((n & 8) != 0) {
            codeStyleSettings = null;
        }
        if ((n & 0x10) != 0) {
            codeStyleSettings2 = null;
        }
        this(messageOutput, bl, charset, codeStyleSettings, codeStyleSettings2);
    }
}

