/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.commandLine;

import com.intellij.formatting.commandLine.CodeStyleProcessorBuildException;
import com.intellij.formatting.commandLine.CodeStyleProcessorBuilder;
import com.intellij.formatting.commandLine.FileSetCodeStyleProcessor;
import com.intellij.formatting.commandLine.FormatterStarter;
import com.intellij.formatting.commandLine.FormatterStarterKt;
import com.intellij.formatting.commandLine.MessageOutput;
import com.intellij.formatting.commandLine.Skipper;
import com.intellij.formatting.commandLine.StdIoMessageOutput;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSettingsLoader;
import java.io.File;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a#\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "appInfo", "", "usageInfo", "createFormatter", "Lcom/intellij/formatting/commandLine/FileSetCodeStyleProcessor;", "args", "", "messageOutput", "Lcom/intellij/formatting/commandLine/MessageOutput;", "([Ljava/lang/String;Lcom/intellij/formatting/commandLine/MessageOutput;)Lcom/intellij/formatting/commandLine/FileSetCodeStyleProcessor;", "readSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "settingsFile", "Ljava/io/File;", "settingsPath", "intellij.platform.lang.impl"})
public final class FormatterStarterKt {
    private static final Logger LOG;
    private static final String usageInfo = "\nUsage: format [-h] [-r|-R] [-d|-dry] [-s|-settings settingsPath] [-charset charsetName] [-allowDefaults] path1 path2...\n  -h|-help         Show a help message and exit.\n  -s|-settings     A path to Intellij IDEA code style settings .xml file. This setting will be\n                   be used as a primary one regardless to the surrounding project settings\n  -r|-R            Scan directories recursively.\n  -d|-dry          Perform a dry run: no file modifications, only exit status.\n  -m|-mask         A comma-separated list of file masks.\n  -charset         Force charset to use when reading and writing files.\n  -allowDefaults   Use factory defaults when style is not defined for a given file. I.e. when -s\n                   is not not set and file doesn't belong to any IDEA project. Otherwise file will\n                   be ignored.\n  path<n>        A path to a file or a directory.  \n";
    private static final String appInfo;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FileSetCodeStyleProcessor createFormatter(@NotNull String[] args2, @NotNull MessageOutput messageOutput) {
        void $this$forEach$iv;
        CodeStyleProcessorBuilder codeStyleProcessorBuilder;
        Intrinsics.checkNotNullParameter((Object)args2, (String)"args");
        Intrinsics.checkNotNullParameter((Object)messageOutput, (String)"messageOutput");
        CodeStyleProcessorBuilder $this$apply = codeStyleProcessorBuilder = new CodeStyleProcessorBuilder(messageOutput);
        boolean bl = false;
        if (args2.length < 2) {
            throw (Throwable)new CodeStyleProcessorBuildException.ShowUsageException();
        }
        Skipper skipFlag = new Skipper(false, 1, null);
        Sequence sequence = SequencesKt.windowed((Sequence)SequencesKt.drop((Sequence)ArraysKt.asSequence((Object[])args2), (int)1), (int)2, (int)1, (boolean)true, (Function1)createFormatter.1.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void arg2;
            Pair $dstr$arg$param = (Pair)element$iv;
            boolean bl2 = false;
            String string2 = (String)$dstr$arg$param.component1();
            String param = (String)$dstr$arg$param.component2();
            Skipper this_$iv = skipFlag;
            boolean $i$f$check = false;
            if (Skipper.access$getSkip$p(this_$iv)) {
                Skipper.access$setSkip$p(this_$iv, false);
                boolean bl3 = false;
                continue;
            }
            switch (arg2) {
                case "-help": 
                case "-h": {
                    throw (Throwable)new CodeStyleProcessorBuildException.ShowUsageException();
                }
                case "-r": 
                case "-R": {
                    $this$apply.recursive();
                    break;
                }
                case "-d": 
                case "-dry": {
                    $this$apply.dryRun();
                    break;
                }
                case "-s": 
                case "-settings": {
                    if (param == null) {
                        throw (Throwable)new CodeStyleProcessorBuildException.ArgumentsException("Missing settings file path.");
                    }
                    CodeStyleSettings codeStyleSettings = FormatterStarterKt.readSettings(param);
                    if (codeStyleSettings == null) {
                        throw (Throwable)new CodeStyleProcessorBuildException.ArgumentsException("Cannot find file " + param);
                    }
                    $this$apply.withCodeStyleSettings(codeStyleSettings);
                    skipFlag.skip();
                    break;
                }
                case "-m": 
                case "-mask": {
                    String string3 = param;
                    if (string3 == null) {
                        throw (Throwable)new CodeStyleProcessorBuildException.ArgumentsException("Missing file mask(s).");
                    }
                    $this$apply.withFileMasks(string3);
                    skipFlag.skip();
                    break;
                }
                case "-charset": {
                    Object $this$runCatching;
                    if (param == null) {
                        throw (Throwable)new CodeStyleProcessorBuildException.ArgumentsException("Missing file mask(s).");
                    }
                    Object object = $this$apply;
                    try {
                        $this$runCatching = object;
                        boolean bl4 = false;
                        $this$runCatching = Result.constructor-impl((Object)Charset.forName(param));
                    }
                    catch (Throwable bl4) {
                        $this$runCatching = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl4));
                    }
                    object = $this$runCatching;
                    if (Result.isSuccess-impl((Object)object)) {
                        Charset it = (Charset)object;
                        boolean bl5 = false;
                        Charset charset = it;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"it");
                        $this$apply.withCharset(charset);
                    }
                    if (Result.exceptionOrNull-impl((Object)object) != null) {
                        Throwable throwable;
                        Throwable throwable2;
                        Throwable it = throwable2 = throwable;
                        boolean bl6 = false;
                        messageOutput.error("Ignoring charset setting: " + it.getMessage());
                    }
                    skipFlag.skip();
                    break;
                }
                case "-allowDefaults": {
                    $this$apply.allowFactoryDefaults();
                    break;
                }
                default: {
                    if (StringsKt.startsWith$default((String)arg2, (String)"-", (boolean)false, (int)2, null)) {
                        throw (Throwable)new CodeStyleProcessorBuildException.ArgumentsException("Unknown option " + (String)arg2);
                    }
                    $this$apply.withEntry((String)arg2);
                }
            }
        }
        return codeStyleProcessorBuilder.build();
    }

    public static /* synthetic */ FileSetCodeStyleProcessor createFormatter$default(String[] stringArray, MessageOutput messageOutput, int n, Object object) {
        if ((n & 2) != 0) {
            messageOutput = StdIoMessageOutput.INSTANCE;
        }
        return FormatterStarterKt.createFormatter(stringArray, messageOutput);
    }

    @Nullable
    public static final CodeStyleSettings readSettings(@NotNull File settingsFile) {
        CodeStyleSettings codeStyleSettings;
        Intrinsics.checkNotNullParameter((Object)settingsFile, (String)"settingsFile");
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile(settingsFile, true);
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl = false;
            it.refresh(false, false);
            codeStyleSettings = new CodeStyleSettingsLoader().loadSettings(it);
        } else {
            codeStyleSettings = null;
        }
        return codeStyleSettings;
    }

    private static final CodeStyleSettings readSettings(String settingsPath) {
        return FormatterStarterKt.readSettings(new File(settingsPath));
    }

    static {
        ApplicationInfoImpl applicationInfoImpl;
        Logger logger = Logger.getInstance(FormatterStarter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FormatterStarter::class.java)");
        LOG = logger;
        ApplicationInfoEx applicationInfoEx = ApplicationInfoEx.getInstanceEx();
        if (applicationInfoEx == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationInfoImpl");
        }
        ApplicationInfoImpl it = applicationInfoImpl = (ApplicationInfoImpl)applicationInfoEx;
        boolean bl = false;
        appInfo = it.getFullApplicationName() + ", build " + it.getBuild().asString();
    }

    public static final /* synthetic */ String access$getAppInfo$p() {
        return appInfo;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }
}

