/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.CodeStyleBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import org.jetbrains.annotations.NotNull;

public class SelectedTextFormatter {
    private final Project myProject;
    private final Editor myEditor;
    private final PsiFile myFile;
    private final String myTextBefore;
    private final RangeMarker mySelectionRangeMarker;

    public SelectedTextFormatter(Project project2, Editor editor2, PsiFile file2) {
        this.myProject = project2;
        this.myEditor = editor2;
        this.myFile = file2;
        this.myTextBefore = this.myEditor.getSelectionModel().getSelectedText();
        this.mySelectionRangeMarker = this.myEditor.getDocument().createRangeMarker(this.myEditor.getSelectionModel().getSelectionStart(), this.myEditor.getSelectionModel().getSelectionEnd());
    }

    public void restoreSelectedText() {
        Document document = this.myEditor.getDocument();
        if (!this.mySelectionRangeMarker.isValid()) {
            return;
        }
        int start2 = this.mySelectionRangeMarker.getStartOffset();
        int end = this.mySelectionRangeMarker.getEndOffset();
        WriteCommandAction.writeCommandAction(this.myProject).withName(LangBundle.message("command.name.configure.code.style.on.selected.fragment.restore.text.before", new Object[0])).run(() -> document.replaceString(start2, end, this.myTextBefore));
        this.myEditor.getSelectionModel().setSelection(start2, start2 + this.myTextBefore.length());
    }

    void reformatSelectedText(@NotNull CodeStyleSettings reformatSettings) {
        SelectionModel model2;
        if (reformatSettings == null) {
            SelectedTextFormatter.$$$reportNull$$$0(0);
        }
        if ((model2 = this.myEditor.getSelectionModel()).hasSelection()) {
            CodeStyle.doWithTemporarySettings((Project)this.myProject, (CodeStyleSettings)reformatSettings, () -> SelectedTextFormatter.reformatRange(this.myFile, this.getSelectedRange()));
        }
    }

    void reformatWholeFile() {
        SelectedTextFormatter.reformatRange(this.myFile, this.myFile.getTextRange());
    }

    private static void reformatRange(@NotNull PsiFile file2, @NotNull TextRange range) {
        if (file2 == null) {
            SelectedTextFormatter.$$$reportNull$$$0(1);
        }
        if (range == null) {
            SelectedTextFormatter.$$$reportNull$$$0(2);
        }
        Project project2 = file2.getProject();
        CommandProcessor.getInstance().executeCommand(project2, () -> ApplicationManager.getApplication().runWriteAction(() -> CodeStyleManager.getInstance(project2).reformatText(file2, range.getStartOffset(), range.getEndOffset())), CodeStyleBundle.message((String)"command.name.reformat", (Object[])new Object[0]), null);
    }

    @NotNull
    TextRange getSelectedRange() {
        SelectionModel model2 = this.myEditor.getSelectionModel();
        int start2 = model2.getSelectionStart();
        int end = model2.getSelectionEnd();
        TextRange textRange = TextRange.create(start2, end);
        if (textRange == null) {
            SelectedTextFormatter.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reformatSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/contextConfiguration/SelectedTextFormatter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/contextConfiguration/SelectedTextFormatter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformatSelectedText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "reformatRange";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

