/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileListPasteProvider
implements PasteProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            FileListPasteProvider.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void performPaste(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileListPasteProvider.$$$reportNull$$$0(1);
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project2 == null || ideView == null) {
            return;
        }
        if (!FileCopyPasteUtil.isFileListFlavorAvailable()) {
            return;
        }
        Transferable contents = CopyPasteManager.getInstance().getContents();
        if (contents == null) {
            return;
        }
        List fileList = FileCopyPasteUtil.getFileList((Transferable)contents);
        if (fileList == null) {
            return;
        }
        ArrayList<PsiFileSystemItem> elements = new ArrayList<PsiFileSystemItem>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            PsiFileSystemItem item = PsiUtilCore.findFileSystemItem(project2, vFile);
            if (item == null) continue;
            elements.add(item);
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiDirectory dir = ideView.getOrChooseDirectory();
        if (dir != null) {
            boolean move = LinuxDragAndDropSupport.isMoveOperation((Transferable)contents);
            if (move) {
                if (DumbService.isDumb(project2) && Messages.showYesNoDialog((Project)project2, (String)RefactoringBundle.message((String)"move.handler.is.dumb.during.indexing"), (String)RefactoringBundle.message((String)"move.title"), (Icon)Messages.getQuestionIcon()) != 0) {
                    return;
                }
                new MoveFilesOrDirectoriesHandler().doMove(PsiUtilCore.toPsiElementArray(elements), dir);
            } else {
                new CopyFilesOrDirectoriesHandler().doCopy(PsiUtilCore.toPsiElementArray(elements), dir);
            }
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileListPasteProvider.$$$reportNull$$$0(2);
        }
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            FileListPasteProvider.$$$reportNull$$$0(3);
        }
        return LangDataKeys.IDE_VIEW.getData(dataContext) != null && FileCopyPasteUtil.isFileListFlavorAvailable();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/FileListPasteProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/FileListPasteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "performPaste";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPastePossible";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isPasteEnabled";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

