/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.actions.CopyReferenceUtil;
import com.intellij.ide.actions.CopyTBXReferenceAction;
import com.intellij.navigation.NavigatorWithinProject;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PlatformUtils;
import com.intellij.util.io.IoKt;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J&\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002J\"\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u0018\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002R\u001c\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/actions/CopyTBXReferenceAction;", "", "()V", "IDE_TAGS", "", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "createJetBrainsLink", "project", "Lcom/intellij/openapi/project/Project;", "elements", "", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "createLink", "refsParameters", "createRefs", "isFile", "", "reference", "index", "getSelectionParameters", "caret", "Lcom/intellij/openapi/editor/Caret;", "getSelectionRange", "element", "parameterIndex", "", "size", "intellij.platform.lang.impl"})
public final class CopyTBXReferenceAction {
    private static final Logger LOG;
    @NlsSafe
    private static final Map<String, String> IDE_TAGS;
    @NotNull
    public static final CopyTBXReferenceAction INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String createJetBrainsLink(@NotNull Project project2, @NotNull List<? extends PsiElement> elements, @Nullable Editor editor2) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        void $this$associateByTo$iv$iv;
        Map $this$associateBy$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int n = elements.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            void i;
            int n3 = n2;
            int n4 = n2++;
            object = nArray;
            boolean bl = false;
            void var21_15 = i;
            object[n4] = var21_15;
        }
        int[] nArray2 = nArray;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)((void)$this$associateBy$iv).length), (int)16);
        void i = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo22 = false;
        int n5 = ((void)$this$associateByTo$iv$iv).length;
        for (int j = 0; j < n5; ++j) {
            void it;
            void element$iv$iv;
            void var14_33 = element$iv$iv = $this$associateByTo$iv$iv[j];
            object = destination$iv$iv;
            boolean bl = false;
            Integer n6 = (int)it;
            it = element$iv$iv;
            boolean bl2 = false;
            String string2 = CopyReferenceUtil.elementToFqn((PsiElement)elements.get((int)it), (Editor)editor2);
            object.put(n6, string2);
        }
        $this$associateBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        void capacity$iv22 = $this$filter$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator $i$f$associateByTo22 = $this$filterTo$iv$iv.entrySet().iterator();
        while ($i$f$associateByTo22.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = $i$f$associateByTo22.next();
            boolean bl = false;
            if (!(it.getValue() != null)) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry it2 = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl3 = false;
            String string3 = FileUtil.getLocationRelativeToUserHome((String)it.getValue(), false);
            object.put(k, string3);
        }
        Set entries2 = destination$iv$iv2.entrySet();
        String refsParameters2 = entries2.isEmpty() ? null : CollectionsKt.joinToString$default((Iterable)entries2, (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<Map.Entry<? extends Integer, ? extends String>, CharSequence>(elements){
            final /* synthetic */ List $elements;

            @NotNull
            public final CharSequence invoke(@NotNull Map.Entry<Integer, String> it) {
                String string2;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                boolean bl = CopyTBXReferenceAction.access$isFile(CopyTBXReferenceAction.INSTANCE, (PsiElement)this.$elements.get(((Number)it.getKey()).intValue()));
                if (this.$elements.size() > 1) {
                    String string3 = it.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it.value");
                    string2 = IoKt.encodeUrlQueryParameter(string3);
                } else {
                    string2 = it.getValue();
                }
                return CopyTBXReferenceAction.access$createRefs(CopyTBXReferenceAction.INSTANCE, bl, string2, CopyTBXReferenceAction.access$parameterIndex(CopyTBXReferenceAction.INSTANCE, ((Number)it.getKey()).intValue(), this.$elements.size()));
            }
            {
                this.$elements = list2;
                super(1);
            }
        }), (int)30, null);
        String copy = this.createLink(editor2, project2, refsParameters2);
        if (copy != null) {
            return copy;
        }
        if (editor2 == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance(project2).getCachedPsiFile(editor2.getDocument());
        if (file2 == null) {
            return null;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        LogicalPosition logicalPosition = caretModel.getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.caretModel.logicalPosition");
        LogicalPosition logicalPosition2 = logicalPosition;
        String path2 = CopyReferenceUtil.getFileFqn((PsiFile)file2) + ":" + (logicalPosition2.line + 1) + ":" + (logicalPosition2.column + 1);
        return this.createLink(editor2, project2, this.createRefs(true, path2, ""));
    }

    private final boolean isFile(PsiElement element2) {
        return element2 instanceof PsiFileSystemItem && CopyReferenceUtil.getQualifiedNameFromProviders((PsiElement)element2) == null;
    }

    private final String parameterIndex(int index, int size) {
        return size == 1 ? "" : String.valueOf(index + 1);
    }

    private final String createRefs(boolean isFile, String reference2, String index) {
        NavigatorWithinProject.NavigationKeyPrefix navigationKey = isFile ? NavigatorWithinProject.NavigationKeyPrefix.PATH : NavigatorWithinProject.NavigationKeyPrefix.FQN;
        return "&" + navigationKey + index + "=" + reference2;
    }

    private final String createLink(Editor editor2, Project project2, String refsParameters2) {
        if (refsParameters2 == null) {
            return null;
        }
        String tool = IDE_TAGS.get(PlatformUtils.getPlatformPrefix());
        if (tool == null) {
            LOG.warn("Cannot find TBX tool for IDE: " + PlatformUtils.getPlatformPrefix());
            return null;
        }
        String string2 = this.getSelectionParameters(editor2);
        if (string2 == null) {
            string2 = "";
        }
        String selectionParameters = string2;
        String projectParameter = "project=" + project2.getName();
        return "jetbrains://" + tool + "/navigate/reference?" + projectParameter + refsParameters2 + selectionParameters;
    }

    private final String getSelectionParameters(Editor editor2) {
        if (editor2 == null) {
            return null;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (editor2.getCaretModel().supportsMultipleCarets()) {
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            List list2 = caretModel.getAllCarets();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"editor.caretModel.allCarets");
            List carets = list2;
            return IntStream.range(0, carets.size()).mapToObj(new IntFunction(editor2, carets){
                final /* synthetic */ Editor $editor;
                final /* synthetic */ List $carets;

                @Nullable
                public final String apply(int i) {
                    E e = this.$carets.get(i);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"carets[i]");
                    return CopyTBXReferenceAction.access$getSelectionParameters(CopyTBXReferenceAction.INSTANCE, this.$editor, (Caret)e, CopyTBXReferenceAction.access$parameterIndex(CopyTBXReferenceAction.INSTANCE, i, this.$carets.size()));
                }
                {
                    this.$editor = editor2;
                    this.$carets = list2;
                }
            }).filter(getSelectionParameters.2.INSTANCE).collect(Collectors.joining());
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        Caret caret = caretModel.getCurrentCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"editor.caretModel.currentCaret");
        return this.getSelectionParameters(editor2, caret, "");
    }

    private final String getSelectionParameters(Editor editor2, Caret caret, String index) {
        String string2;
        String string3 = this.getSelectionRange(editor2, caret);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            string2 = "&selection" + index + "=" + it;
        } else {
            string2 = null;
        }
        return string2;
    }

    private final String getSelectionRange(Editor editor2, Caret caret) {
        if (!caret.hasSelection()) {
            return null;
        }
        LogicalPosition logicalPosition = editor2.offsetToLogicalPosition(caret.getSelectionStart());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"editor.offsetToLogicalPo\u2026ion(caret.selectionStart)");
        LogicalPosition selectionStart = logicalPosition;
        LogicalPosition logicalPosition2 = editor2.offsetToLogicalPosition(caret.getSelectionEnd());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition2, (String)"editor.offsetToLogicalPosition(caret.selectionEnd)");
        LogicalPosition selectionEnd = logicalPosition2;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%d:%d-%d:%d";
        Object[] objectArray = new Object[]{selectionStart.line + 1, selectionStart.column + 1, selectionEnd.line + 1, selectionEnd.column + 1};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        return string3;
    }

    private CopyTBXReferenceAction() {
    }

    static {
        CopyTBXReferenceAction copyTBXReferenceAction;
        INSTANCE = copyTBXReferenceAction = new CopyTBXReferenceAction();
        Logger logger = Logger.getInstance(CopyTBXReferenceAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(CopyT\u2026erenceAction::class.java)");
        LOG = logger;
        IDE_TAGS = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"idea", (Object)"idea"), TuplesKt.to((Object)"Idea", (Object)"idea"), TuplesKt.to((Object)"AppCode", (Object)"appcode"), TuplesKt.to((Object)"CLion", (Object)"clion"), TuplesKt.to((Object)"Python", (Object)"pycharm"), TuplesKt.to((Object)"PyCharmCore", (Object)"pycharm"), TuplesKt.to((Object)"PyCharmEdu", (Object)"pycharm"), TuplesKt.to((Object)"DataSpell", (Object)"pycharm"), TuplesKt.to((Object)"PhpStorm", (Object)"php-storm"), TuplesKt.to((Object)"Ruby", (Object)"rubymine"), TuplesKt.to((Object)"WebStorm", (Object)"web-storm"), TuplesKt.to((Object)"Rider", (Object)"rd"), TuplesKt.to((Object)"GoLand", (Object)"goland"), TuplesKt.to((Object)"DataGrip", (Object)"dbe")});
    }

    public static final /* synthetic */ String access$createRefs(CopyTBXReferenceAction $this, boolean isFile, String reference2, String index) {
        return $this.createRefs(isFile, reference2, index);
    }

    public static final /* synthetic */ boolean access$isFile(CopyTBXReferenceAction $this, PsiElement element2) {
        return $this.isFile(element2);
    }

    public static final /* synthetic */ String access$parameterIndex(CopyTBXReferenceAction $this, int index, int size) {
        return $this.parameterIndex(index, size);
    }

    public static final /* synthetic */ String access$getSelectionParameters(CopyTBXReferenceAction $this, Editor editor2, Caret caret, String index) {
        return $this.getSelectionParameters(editor2, caret, index);
    }
}

