/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.collectors.fus.fileTypes.FileTypeUsageCounterCollector;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateFileAction
extends CreateElementActionBase
implements DumbAware {
    public CreateFileAction() {
        super(ActionsBundle.messagePointer((String)"action.NewFile.text", (Object[])new Object[0]), IdeBundle.messagePointer((String)"action.create.new.file.description", (Object[])new Object[0]), AllIcons.FileTypes.Text);
    }

    public CreateFileAction(@NlsActions.ActionText String text2, @NlsActions.ActionDescription String description, Icon icon2) {
        super(text2, description, icon2);
    }

    public CreateFileAction(@NotNull Supplier<String> dynamicText, @NotNull Supplier<String> dynamicDescription, Icon icon2) {
        if (dynamicText == null) {
            CreateFileAction.$$$reportNull$$$0(0);
        }
        if (dynamicDescription == null) {
            CreateFileAction.$$$reportNull$$$0(1);
        }
        super(dynamicText, dynamicDescription, icon2);
    }

    @Override
    public boolean isDumbAware() {
        return CreateFileAction.class.equals(this.getClass());
    }

    @Override
    protected PsiElement @NotNull [] invokeDialog(@NotNull Project project2, @NotNull PsiDirectory directory) {
        if (project2 == null) {
            CreateFileAction.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(3);
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            CreateFileAction.$$$reportNull$$$0(4);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    @Override
    protected void invokeDialog(@NotNull Project project2, @NotNull PsiDirectory directory, @NotNull Consumer<? super PsiElement[]> elementsConsumer) {
        if (project2 == null) {
            CreateFileAction.$$$reportNull$$$0(5);
        }
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(6);
        }
        if (elementsConsumer == null) {
            CreateFileAction.$$$reportNull$$$0(7);
        }
        MyValidator validator2 = new MyValidator(project2, directory);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            try {
                elementsConsumer.accept((PsiElement[])validator2.create("test"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (Experiments.getInstance().isFeatureEnabled("show.create.new.element.in.popup")) {
            this.createLightWeightPopup(validator2, elementsConsumer).showCenteredInCurrentWindow(project2);
        } else {
            Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.enter.new.file.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), null, null, (InputValidator)validator2);
            elementsConsumer.accept((PsiElement[])validator2.getCreatedElements());
        }
    }

    @NotNull
    private JBPopup createLightWeightPopup(@NotNull CreateElementActionBase.MyInputValidator validator2, @NotNull Consumer<? super PsiElement[]> consumer) {
        if (consumer == null) {
            CreateFileAction.$$$reportNull$$$0(8);
        }
        if (validator2 == null) {
            CreateFileAction.$$$reportNull$$$0(9);
        }
        NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel();
        JTextField nameField = contentPanel.getTextField();
        JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)IdeBundle.message((String)"title.new.file", (Object[])new Object[0]), (JComponent)contentPanel, (JComponent)nameField);
        contentPanel.setApplyAction(event -> {
            String name2 = nameField.getText();
            if (validator2.checkInput(name2) && validator2.canClose(name2)) {
                popup2.closeOk(event);
                consumer.accept(validator2.getCreatedElements());
            } else {
                String errorMessage = validator2 instanceof InputValidatorEx ? ((InputValidatorEx)((Object)validator2)).getErrorText(name2) : LangBundle.message("incorrect.name", new Object[0]);
                contentPanel.setError(errorMessage);
            }
        });
        JBPopup jBPopup = popup2;
        if (jBPopup == null) {
            CreateFileAction.$$$reportNull$$$0(10);
        }
        return jBPopup;
    }

    @Override
    protected PsiElement @NotNull [] create(@NotNull String newName2, @NotNull PsiDirectory directory) throws Exception {
        if (newName2 == null) {
            CreateFileAction.$$$reportNull$$$0(11);
        }
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(12);
        }
        MkDirs mkdirs = new MkDirs(newName2, directory);
        PsiFile file2 = WriteAction.compute(() -> mkdirs.directory.createFile(this.getFileName(mkdirs.newName)));
        FileTypeUsageCounterCollector.triggerCreate((Project)file2.getProject(), (VirtualFile)file2.getVirtualFile());
        PsiElement[] psiElementArray = new PsiElement[]{file2};
        if (psiElementArray == null) {
            CreateFileAction.$$$reportNull$$$0(13);
        }
        return psiElementArray;
    }

    @NotNull
    public static PsiDirectory findOrCreateSubdirectory(@NotNull PsiDirectory parent, @NotNull String subdirName) {
        PsiDirectory sub;
        if (parent == null) {
            CreateFileAction.$$$reportNull$$$0(14);
        }
        if (subdirName == null) {
            CreateFileAction.$$$reportNull$$$0(15);
        }
        PsiDirectory psiDirectory = (sub = parent.findSubdirectory(subdirName)) == null ? WriteAction.compute(() -> parent.createSubdirectory(subdirName)) : sub;
        if (psiDirectory == null) {
            CreateFileAction.$$$reportNull$$$0(16);
        }
        return psiDirectory;
    }

    @Override
    @NotNull
    protected String getActionName(@NotNull PsiDirectory directory, @NotNull String newName2) {
        if (directory == null) {
            CreateFileAction.$$$reportNull$$$0(17);
        }
        if (newName2 == null) {
            CreateFileAction.$$$reportNull$$$0(18);
        }
        String string2 = IdeBundle.message((String)"progress.creating.file", (Object[])new Object[]{directory.getVirtualFile().getPresentableUrl(), File.separator, newName2});
        if (string2 == null) {
            CreateFileAction.$$$reportNull$$$0(19);
        }
        return string2;
    }

    @Override
    protected String getErrorTitle() {
        return IdeBundle.message((String)"title.cannot.create.file", (Object[])new Object[0]);
    }

    protected String getFileName(String newName2) {
        if (this.getDefaultExtension() == null || !FileUtilRt.getExtension(newName2).isEmpty()) {
            return newName2;
        }
        return newName2 + "." + this.getDefaultExtension();
    }

    @Nullable
    protected String getDefaultExtension() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/CreateFileAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/CreateFileAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createLightWeightPopup";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateSubdirectory";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeDialog";
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createLightWeightPopup";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateSubdirectory";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getActionName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 10: 
            case 13: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyValidator
    extends CreateElementActionBase.MyInputValidator
    implements InputValidatorEx {
        private @NlsContexts.DetailedDescription String myErrorText;

        public MyValidator(Project project2, PsiDirectory directory) {
            super(project2, directory);
        }

        @Override
        public boolean checkInput(String inputString) {
            StringTokenizer tokenizer = new StringTokenizer(inputString, "\\/");
            VirtualFile vFile = this.getDirectory().getVirtualFile();
            boolean firstToken = true;
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if ((token.equals(".") || token.equals("..")) && !tokenizer.hasMoreTokens()) {
                    this.myErrorText = IdeBundle.message((String)"error.invalid.file.name", (Object[])new Object[]{token});
                    return false;
                }
                if (vFile != null) {
                    if (firstToken && "~".equals(token)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            this.myErrorText = IdeBundle.message((String)"error.user.home.directory.not.found", (Object[])new Object[0]);
                            return false;
                        }
                        vFile = userHomeDir;
                    } else if ("..".equals(token)) {
                        VirtualFile parent = vFile.getParent();
                        if (parent == null) {
                            this.myErrorText = IdeBundle.message((String)"error.invalid.directory", (Object[])new Object[]{vFile.getPresentableUrl() + File.separatorChar + ".."});
                            return false;
                        }
                        vFile = parent;
                    } else if (!".".equals(token)) {
                        VirtualFile child = vFile.findChild(token);
                        if (child != null) {
                            if (!child.isDirectory()) {
                                this.myErrorText = IdeBundle.message((String)"error.file.with.name.already.exists", (Object[])new Object[]{token});
                                return false;
                            }
                            if (!tokenizer.hasMoreTokens()) {
                                this.myErrorText = IdeBundle.message((String)"error.directory.with.name.already.exists", (Object[])new Object[]{token});
                                return false;
                            }
                        }
                        vFile = child;
                    }
                }
                if (FileTypeManager.getInstance().isFileIgnored(CreateFileAction.this.getFileName(token))) {
                    this.myErrorText = IdeBundle.message((String)"warning.create.directory.with.ignored.name", (Object[])new Object[]{token});
                    return true;
                }
                firstToken = false;
            }
            this.myErrorText = null;
            return true;
        }

        @Override
        public String getErrorText(String inputString) {
            return this.myErrorText;
        }

        @Override
        public boolean canClose(String inputString) {
            if (inputString.isEmpty()) {
                return super.canClose(inputString);
            }
            return super.canClose(CreateFileAction.this.getFileName(inputString));
        }
    }

    public static class MkDirs {
        @NotNull
        public final String newName;
        @NotNull
        public final PsiDirectory directory;

        public MkDirs(@NotNull String newName2, @NotNull PsiDirectory directory) {
            if (newName2 == null) {
                MkDirs.$$$reportNull$$$0(0);
            }
            if (directory == null) {
                MkDirs.$$$reportNull$$$0(1);
            }
            if (SystemInfo.isWindows) {
                newName2 = newName2.replace('\\', '/');
            }
            if (newName2.contains("/")) {
                List<String> subDirs = StringUtil.split(newName2, "/");
                newName2 = subDirs.remove(subDirs.size() - 1);
                boolean firstToken = true;
                for (String dir : subDirs) {
                    if (firstToken && "~".equals(dir)) {
                        VirtualFile userHomeDir = VfsUtil.getUserHomeDir();
                        if (userHomeDir == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        PsiDirectory directory1 = directory.getManager().findDirectory(userHomeDir);
                        if (directory1 == null) {
                            throw new IncorrectOperationException("User home directory not found");
                        }
                        directory = directory1;
                    } else if ("..".equals(dir)) {
                        PsiDirectory parentDirectory = directory.getParentDirectory();
                        if (parentDirectory == null) {
                            throw new IncorrectOperationException("Not a valid directory");
                        }
                        directory = parentDirectory;
                    } else if (!".".equals(dir)) {
                        directory = CreateFileAction.findOrCreateSubdirectory(directory, dir);
                    }
                    firstToken = false;
                }
            }
            this.newName = newName2;
            this.directory = directory;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "directory";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/actions/CreateFileAction$MkDirs";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

