/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.CommonBundle;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.CreateElementActionBase;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ElementCreator
implements WriteActionAware {
    private static final Logger LOG = Logger.getInstance(ElementCreator.class);
    private final Project myProject;
    @NlsContexts.DialogTitle
    private final String myErrorTitle;

    protected ElementCreator(Project project2, @NotNull @NlsContexts.DialogTitle String errorTitle) {
        if (errorTitle == null) {
            ElementCreator.$$$reportNull$$$0(0);
        }
        this.myProject = project2;
        this.myErrorTitle = errorTitle;
    }

    protected abstract PsiElement @NotNull [] create(@NotNull String var1) throws Exception;

    @NlsContexts.Command
    @NotNull
    protected abstract String getActionName(@NotNull String var1);

    @NotNull
    public @NotNull PsiElement @NotNull [] tryCreate(@NotNull String inputString) {
        if (inputString == null) {
            ElementCreator.$$$reportNull$$$0(1);
        }
        if (inputString.isEmpty()) {
            Messages.showMessageDialog((Project)this.myProject, (String)IdeBundle.message((String)"error.name.should.be.specified", (Object[])new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            if (PsiElement.EMPTY_ARRAY == null) {
                ElementCreator.$$$reportNull$$$0(2);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        Ref createdElements = Ref.create();
        Exception exception = this.executeCommand(this.getActionName(inputString), () -> {
            PsiElement[] psiElements = this.create(inputString);
            SmartPointerManager manager = SmartPointerManager.getInstance(this.myProject);
            createdElements.set(ContainerUtil.map(psiElements, manager::createSmartPsiElementPointer));
        });
        if (exception != null) {
            this.handleException(exception);
            if (PsiElement.EMPTY_ARRAY == null) {
                ElementCreator.$$$reportNull$$$0(3);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] psiElementArray = ContainerUtil.mapNotNull((Collection)createdElements.get(), SmartPsiElementPointer::getElement).toArray(PsiElement.EMPTY_ARRAY);
        if (psiElementArray == null) {
            ElementCreator.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @Nullable
    private Exception executeCommand(@NotNull @NlsContexts.Command String commandName2, @NotNull ThrowableRunnable<? extends Exception> invokeCreate) {
        if (commandName2 == null) {
            ElementCreator.$$$reportNull$$$0(5);
        }
        if (invokeCreate == null) {
            ElementCreator.$$$reportNull$$$0(6);
        }
        Exception[] exception = new Exception[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LocalHistoryAction action2 = LocalHistory.getInstance().startAction(commandName2);
            try {
                if (this.startInWriteAction()) {
                    WriteAction.run(invokeCreate);
                } else {
                    invokeCreate.run();
                }
            }
            catch (Exception ex) {
                exception[0] = ex;
            }
            finally {
                action2.finish();
            }
        }, commandName2, null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        return exception[0];
    }

    private void handleException(Exception t) {
        LOG.info(t);
        String errorMessage = ElementCreator.getErrorMessage(t);
        Messages.showMessageDialog((Project)this.myProject, (String)errorMessage, (String)this.myErrorTitle, (Icon)Messages.getErrorIcon());
    }

    @NlsContexts.DialogMessage
    public static String getErrorMessage(Throwable t) {
        String errorMessage = CreateElementActionBase.filterMessage(t.getMessage());
        if (StringUtil.isEmpty(errorMessage)) {
            errorMessage = t.toString();
        }
        return errorMessage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorTitle";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputString";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/ElementCreator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invokeCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/ElementCreator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "tryCreate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCreate";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

