/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.runAnything;

import com.intellij.ide.actions.runAnything.RunAnythingCache;
import com.intellij.ide.actions.runAnything.RunAnythingPopupUI;
import com.intellij.ide.actions.runAnything.RunAnythingSearchListModel;
import com.intellij.ide.actions.runAnything.groups.RunAnythingCompletionGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGeneralGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingGroup;
import com.intellij.ide.actions.runAnything.groups.RunAnythingRecentGroup;
import com.intellij.ide.actions.runAnything.items.RunAnythingItem;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class RunAnythingCalcThread
implements Computable<RunAnythingSearchListModel> {
    @NotNull
    private final String myPattern;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final Project myProject;

    RunAnythingCalcThread(@NotNull Project project2, @NotNull DataContext context2, @NotNull String pattern) {
        if (project2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(2);
        }
        this.myProject = project2;
        this.myPattern = pattern;
        this.myDataContext = context2;
    }

    @Override
    public RunAnythingSearchListModel compute() {
        RunAnythingSearchListModel model2;
        if (RunAnythingPopupUI.isHelpMode(this.myPattern)) {
            model2 = new RunAnythingSearchListModel.RunAnythingHelpListModel();
            List<RunAnythingItem> items = this.buildHelpGroups((RunAnythingSearchListModel.RunAnythingHelpListModel)model2);
            model2.addAll(0, items);
        } else {
            model2 = new RunAnythingSearchListModel.RunAnythingMainListModel();
            List<RunAnythingItem> items = this.buildAllGroups(model2);
            model2.addAll(0, items);
            this.loadEntireSingleMatchedGroup(model2, items);
        }
        return model2;
    }

    private void loadEntireSingleMatchedGroup(@NotNull RunAnythingSearchListModel model2, @NotNull List<RunAnythingItem> items) {
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(3);
        }
        if (items == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(4);
        }
        RunAnythingGroup titleGroup = null;
        RunAnythingGroup moreGroup = null;
        int index = 0;
        for (int i = 0; i < items.size(); ++i) {
            RunAnythingGroup currentTitleGroup = model2.findGroupByTitleIndex(i);
            if (currentTitleGroup instanceof RunAnythingRecentGroup) continue;
            if (currentTitleGroup != null) {
                if (titleGroup == null) {
                    titleGroup = currentTitleGroup;
                } else {
                    return;
                }
            }
            if ((moreGroup = model2.findGroupByMoreIndex(i)) == null) continue;
            if (moreGroup instanceof RunAnythingRecentGroup) {
                moreGroup = null;
                continue;
            }
            index = i;
        }
        if (moreGroup != null) {
            RunAnythingPopupUI.insert(moreGroup, model2, this.myDataContext, this.myPattern, index, 100);
        }
    }

    @NotNull
    private List<RunAnythingItem> buildHelpGroups(@NotNull RunAnythingSearchListModel.RunAnythingHelpListModel model2) {
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(5);
        }
        ArrayList<RunAnythingItem> items = new ArrayList<RunAnythingItem>();
        model2.getGroups().forEach(group -> group.collectItems(this.myDataContext, items, RunAnythingPopupUI.trimHelpPattern(this.myPattern)));
        ArrayList<RunAnythingItem> arrayList = items;
        if (arrayList == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private List<RunAnythingItem> buildAllGroups(@NotNull RunAnythingSearchListModel model2) {
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(7);
        }
        ArrayList<RunAnythingItem> items = new ArrayList<RunAnythingItem>();
        if (this.myPattern.trim().length() == 0) {
            RunAnythingGroup recentGroup = model2.getGroups().stream().filter(group -> group instanceof RunAnythingRecentGroup).findFirst().orElse(null);
            assert (recentGroup != null);
            recentGroup.collectItems(this.myDataContext, items, this.myPattern);
        } else {
            this.buildCompletionGroups(this.myDataContext, items, model2);
        }
        ArrayList<RunAnythingItem> arrayList = items;
        if (arrayList == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private void buildCompletionGroups(@NotNull DataContext dataContext, @NotNull List<RunAnythingItem> items, @NotNull RunAnythingSearchListModel model2) {
        if (dataContext == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(9);
        }
        if (items == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(10);
        }
        if (model2 == null) {
            RunAnythingCalcThread.$$$reportNull$$$0(11);
        }
        if (DumbService.getInstance(this.myProject).isDumb()) {
            return;
        }
        model2.getGroups().stream().filter(group -> group instanceof RunAnythingCompletionGroup || group instanceof RunAnythingGeneralGroup || group instanceof RunAnythingRecentGroup).filter(group -> RunAnythingCache.getInstance(this.myProject).isGroupVisible((RunAnythingGroup)group)).forEach(group -> group.collectItems(dataContext, items, this.myPattern));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/runAnything/RunAnythingCalcThread";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/runAnything/RunAnythingCalcThread";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHelpGroups";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllGroups";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadEntireSingleMatchedGroup";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildHelpGroups";
                break;
            }
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildAllGroups";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildCompletionGroups";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

