/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.ide.actions.searcheverywhere.GroupedSearchListModel;
import com.intellij.ide.actions.searcheverywhere.SEResultsListFactory;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereHeader;
import com.intellij.ide.actions.searcheverywhere.SearchListModel;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.JBList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.annotations.Nls;

class GroupedListFactory
extends SEResultsListFactory {
    private final GroupTitleRenderer myGroupTitleRenderer = new GroupTitleRenderer();

    GroupedListFactory() {
    }

    @Override
    public SearchListModel createModel() {
        return new GroupedSearchListModel();
    }

    @Override
    public JBList<Object> createList(SearchListModel model2) {
        return new JBList((ListModel)model2);
    }

    @Override
    ListCellRenderer<Object> createListRenderer(SearchListModel model2, final SearchEverywhereHeader header) {
        final GroupedSearchListModel groupedModel = (GroupedSearchListModel)model2;
        return new ListCellRenderer<Object>(){
            private final Map<String, ListCellRenderer<? super Object>> myRenderersCache = new HashMap<String, ListCellRenderer<? super Object>>();

            @Override
            public Component getListCellRendererComponent(JList<?> list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == SearchListModel.MORE_ELEMENT) {
                    return GroupedListFactory.this.getMoreElementRenderer(list2, index, isSelected, cellHasFocus);
                }
                Object component2 = GroupedListFactory.this.getNonMoreElementRenderer(list2, value, index, isSelected, cellHasFocus, groupedModel, this.myRenderersCache);
                if (!header.getSelectedTab().isSingleContributor() && groupedModel.isGroupFirstItem(index)) {
                    SearchEverywhereContributor contributor = groupedModel.getContributorForIndex(index);
                    component2 = GroupedListFactory.this.myGroupTitleRenderer.withDisplayedData(contributor.getFullGroupName(), (Component)component2);
                }
                return component2;
            }
        };
    }

    private static class GroupTitleRenderer
    extends CellRendererPanel {
        private final SimpleColoredComponent titleLabel = new SimpleColoredComponent();

        GroupTitleRenderer() {
            this.setLayout(new BorderLayout());
            SeparatorComponent separatorComponent = new SeparatorComponent(this.titleLabel.getPreferredSize().height / 2, JBUI.CurrentTheme.BigPopup.listSeparatorColor(), null);
            Object topPanel = ((BorderLayoutPanel)JBUI.Panels.simplePanel(5, 0).addToCenter(separatorComponent).addToLeft((Component)this.titleLabel).withBorder(JBUI.Borders.empty(1, 7))).withBackground(ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.BACKGROUND : UIUtil.getListBackground());
            this.add((Component)topPanel, "North");
        }

        public GroupTitleRenderer withDisplayedData(@Nls String title, Component itemContent) {
            this.titleLabel.clear();
            this.titleLabel.append(title, SEResultsListFactory.SMALL_LABEL_ATTRS);
            Component prevContent = ((BorderLayout)this.getLayout()).getLayoutComponent("Center");
            if (prevContent != null) {
                this.remove(prevContent);
            }
            this.add(itemContent, "Center");
            this.accessibleContext = itemContent.getAccessibleContext();
            return this;
        }
    }
}

