/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.popup.PopupState;
import com.intellij.util.ui.JBUI;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R!\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/bookmark/actions/ShowLineBookmarksAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "popupState", "Lcom/intellij/ui/popup/PopupState;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
public final class ShowLineBookmarksAction
extends DumbAwareAction {
    private final PopupState<JBPopup> popupState;

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation2 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"event.presentation");
        presentation2.setEnabled(event.getProject() != null);
        Presentation presentation3 = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"event.presentation");
        boolean bl = AdvancedSettings.Companion.getBoolean("show.line.bookmarks.in.popup");
        presentation3.setText(bl ? BookmarkBundle.message("show.line.bookmarks.action.text", new Object[0]) : BookmarkBundle.message("show.bookmarks.action.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.popupState.isRecentlyHidden()) {
            return;
        }
        if (this.popupState.isShowing()) {
            this.popupState.hidePopup();
            return;
        }
        Project project2 = event.getProject();
        if (project2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"event.project ?: return");
        Project project3 = project2;
        BookmarksView panel2 = new BookmarksView(project3, null);
        panel2.setPreferredSize(JBUI.size(640, 240));
        Object object = ExtensionsKt.getBookmarksManager(event);
        if (object != null && (object = object.getAssignedTypes()) != null) {
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BookmarkType it = (BookmarkType)((Object)element$iv);
                boolean bl = false;
                JComponent jComponent = (JComponent)((Object)panel2);
                Disposable disposable = panel2;
                BookmarkType bookmarkType = it;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)bookmarkType), (String)"it");
                ExtensionsKt.registerBookmarkTypeAction(jComponent, disposable, bookmarkType);
            }
        }
        ExtensionsKt.registerEditSourceAction((JComponent)((Object)panel2), panel2);
        ExtensionsKt.registerNavigateOnEnterAction((JTree)panel2.getTree());
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)panel2), (JComponent)panel2.getTree()).setDimensionServiceKey(project3, "ShowBookmarks", false).setTitle(BookmarkBundle.message("popup.title.bookmarks", new Object[0])).setFocusable(true).setRequestFocus(true).setMovable(true).setResizable(true).setCancelOnOtherWindowOpen(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"JBPopupFactory.getInstan\u2026rue)\n      .createPopup()");
        JBPopup popup2 = jBPopup;
        Disposer.register((Disposable)popup2, panel2);
        this.popupState.prepareToShow((Object)popup2);
        popup2.showCenteredInCurrentWindow(project3);
    }

    public ShowLineBookmarksAction() {
        super(BookmarkBundle.messagePointer("show.bookmarks.action.text", new Object[0]));
        PopupState popupState = PopupState.forPopup();
        Intrinsics.checkNotNullExpressionValue((Object)popupState, (String)"PopupState.forPopup()");
        this.popupState = popupState;
    }
}

