/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.actions.ExtensionsKt;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ide/bookmark/actions/ToggleBookmarkAction;", "Lcom/intellij/openapi/actionSystem/Toggleable;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "isUnexpected", "", "Ljava/awt/event/MouseEvent;", "(Ljava/awt/event/MouseEvent;)Z", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.platform.lang.impl"})
public final class ToggleBookmarkAction
extends DumbAwareAction
implements Toggleable {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Icon icon2;
        BookmarkType bookmarkType;
        Bookmark bookmark;
        Bookmark bookmark2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BookmarksManager manager = ExtensionsKt.getBookmarksManager(event);
        Bookmark bookmark3 = bookmark2 = ExtensionsKt.getContextBookmark(event);
        if (bookmark3 != null) {
            Bookmark it = bookmark = bookmark3;
            boolean bl = false;
            BookmarksManager bookmarksManager = manager;
            bookmarkType = bookmarksManager != null ? bookmarksManager.getType(it) : null;
        } else {
            bookmarkType = null;
        }
        BookmarkType type = bookmarkType;
        Bookmark $this$apply = bookmark = event.getPresentation();
        boolean bl = false;
        $this$apply.setEnabledAndVisible(bookmark2 != null);
        String string2 = event.getPlace();
        switch (string2.hashCode()) {
            case -1388598828: {
                if (string2.equals("TouchBarGeneral")) {
                    Toggleable.setSelected((Presentation)$this$apply, (type != null ? 1 : 0) != 0);
                    icon2 = AllIcons.Actions.Checked;
                    break;
                }
            }
            default: {
                icon2 = null;
            }
        }
        $this$apply.setIcon(icon2);
        $this$apply.setText(!ActionPlaces.isPopupPlace((String)event.getPlace()) ? BookmarkBundle.message("bookmark.toggle.action.text", new Object[0]) : (type != null ? BookmarkBundle.message("bookmark.delete.action.text", new Object[0]) : BookmarkBundle.message("bookmark.add.action.text", new Object[0])));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Boolean unexpectedGutterClick;
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        InputEvent inputEvent = event.getInputEvent();
        if (!(inputEvent instanceof MouseEvent)) {
            inputEvent = null;
        }
        MouseEvent mouseEvent = (MouseEvent)inputEvent;
        if (mouseEvent != null) {
            MouseEvent mouseEvent2;
            MouseEvent $this$run = mouseEvent2 = mouseEvent;
            boolean bl2 = false;
            bl = $this$run.getSource() instanceof EditorGutter && this.isUnexpected($this$run);
        } else {
            bl = unexpectedGutterClick = null;
        }
        if (Intrinsics.areEqual(unexpectedGutterClick, (Object)true)) {
            return;
        }
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(event);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        Bookmark bookmark = ExtensionsKt.getContextBookmark(event);
        if (bookmark == null) {
            return;
        }
        Bookmark bookmark2 = bookmark;
        BookmarkType bookmarkType = manager.getType(bookmark2);
        if (bookmarkType == null) {
            bookmarkType = BookmarkType.DEFAULT;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)bookmarkType), (String)"manager.getType(bookmark) ?: BookmarkType.DEFAULT");
        BookmarkType type = bookmarkType;
        manager.toggle(bookmark2, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnexpected(MouseEvent $this$isUnexpected) {
        if (!SwingUtilities.isLeftMouseButton($this$isUnexpected)) return true;
        if ($this$isUnexpected.isPopupTrigger()) return true;
        if (SystemInfo.isMac) {
            if ($this$isUnexpected.isMetaDown()) return false;
            return true;
        }
        if ($this$isUnexpected.isControlDown()) return false;
        return true;
    }

    public ToggleBookmarkAction() {
        super(BookmarkBundle.messagePointer("bookmark.toggle.action.text", new Object[0]));
        this.setEnabledInModalContext(true);
    }
}

