/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.bookmark.FileBookmark;
import com.intellij.ide.bookmark.providers.LineBookmarkProvider;
import com.intellij.ide.bookmark.ui.tree.BookmarkNode;
import com.intellij.ide.bookmark.ui.tree.FileNode;
import com.intellij.ide.bookmark.ui.tree.FolderNode;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00010\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\tH\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ide/bookmark/providers/FileBookmarkImpl;", "Lcom/intellij/ide/bookmark/FileBookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;Lcom/intellij/openapi/vfs/VirtualFile;)V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "descriptor", "Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "getDescriptor", "()Lcom/intellij/openapi/fileEditor/OpenFileDescriptor;", "Lorg/jetbrains/annotations/NotNull;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProvider", "()Lcom/intellij/ide/bookmark/providers/LineBookmarkProvider;", "canNavigate", "", "canNavigateToSource", "createNode", "Lcom/intellij/ide/bookmark/ui/tree/BookmarkNode;", "equals", "other", "", "hashCode", "", "navigate", "", "requestFocus", "toString", "intellij.platform.lang.impl"})
public final class FileBookmarkImpl
implements FileBookmark {
    @NotNull
    private final OpenFileDescriptor descriptor;
    @NotNull
    private final LineBookmarkProvider provider;

    @NotNull
    public final OpenFileDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.descriptor.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"descriptor.file");
        return virtualFile2;
    }

    @Override
    @NotNull
    public Map<String, String> getAttributes() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"url", (Object)this.getFile().getUrl()));
    }

    @NotNull
    public BookmarkNode<FileBookmark> createNode() {
        boolean bl = this.getFile().isDirectory();
        return bl ? (BookmarkNode)new FolderNode(this.getProvider().getProject(), this) : (BookmarkNode)new FileNode(this.getProvider().getProject(), this);
    }

    @Override
    public boolean canNavigate() {
        return !this.getProvider().getProject().isDisposed() && this.descriptor.canNavigate();
    }

    @Override
    public boolean canNavigateToSource() {
        return !this.getFile().isDirectory() && this.canNavigate();
    }

    @Override
    public void navigate(boolean requestFocus) {
        this.descriptor.navigate(requestFocus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getProvider(), this.getFile());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof FileBookmarkImpl && Intrinsics.areEqual((Object)((FileBookmarkImpl)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((FileBookmarkImpl)other).getFile(), (Object)this.getFile());
    }

    @NotNull
    public String toString() {
        return "FileBookmarkImpl(file=" + this.getFile() + ",provider=" + this.getProvider() + ")";
    }

    @Override
    @NotNull
    public LineBookmarkProvider getProvider() {
        return this.provider;
    }

    public FileBookmarkImpl(@NotNull LineBookmarkProvider provider2, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.provider = provider2;
        this.descriptor = new OpenFileDescriptor(this.getProvider().getProject(), file2);
    }
}

