/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.providers;

import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.SelectInManager;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.providers.RootTypeBookmarkProvider;
import com.intellij.ide.bookmark.providers.RootTypeNode;
import com.intellij.ide.scratch.RootType;
import com.intellij.ide.scratch.ScratchTreeStructureProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\tH\u0016R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/ide/bookmark/providers/RootTypeBookmark;", "Lcom/intellij/ide/bookmark/Bookmark;", "provider", "Lcom/intellij/ide/bookmark/providers/RootTypeBookmarkProvider;", "type", "Lcom/intellij/ide/scratch/RootType;", "(Lcom/intellij/ide/bookmark/providers/RootTypeBookmarkProvider;Lcom/intellij/ide/scratch/RootType;)V", "attributes", "", "", "getAttributes", "()Ljava/util/Map;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/Nullable;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProvider", "()Lcom/intellij/ide/bookmark/providers/RootTypeBookmarkProvider;", "getType", "()Lcom/intellij/ide/scratch/RootType;", "canNavigate", "", "canNavigateToSource", "createNode", "Lcom/intellij/ide/bookmark/providers/RootTypeNode;", "equals", "other", "", "hashCode", "", "navigate", "", "requestFocus", "toString", "intellij.platform.lang.impl"})
public final class RootTypeBookmark
implements Bookmark {
    @NotNull
    private final RootTypeBookmarkProvider provider;
    @NotNull
    private final RootType type;

    @Nullable
    public final VirtualFile getFile() {
        return ScratchTreeStructureProvider.getVirtualFile(this.type);
    }

    @Override
    @NotNull
    public Map<String, String> getAttributes() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"root.type.id", (Object)this.type.getId()));
    }

    @NotNull
    public RootTypeNode createNode() {
        return new RootTypeNode(this.getProvider().getProject(), this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canNavigate() {
        if (this.getProvider().getProject().isDisposed()) return false;
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null) return false;
        if (!virtualFile2.isValid()) return false;
        return true;
    }

    @Override
    public boolean canNavigateToSource() {
        return false;
    }

    @Override
    public void navigate(boolean requestFocus) {
        VirtualFile virtualFile2 = this.getFile();
        if (virtualFile2 == null) {
            return;
        }
        Object object = virtualFile2;
        VirtualFile it = object;
        boolean bl = false;
        FileSelectInContext context2 = new FileSelectInContext(this.getProvider().getProject(), it, null);
        SelectInManager selectInManager = SelectInManager.getInstance((Project)this.getProvider().getProject());
        Intrinsics.checkNotNullExpressionValue((Object)selectInManager, (String)"SelectInManager.getInstance(provider.project)");
        List list2 = selectInManager.getTargetList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"SelectInManager.getInsta\u2026vider.project).targetList");
        Object object2 = object = (Iterable)list2;
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            SelectInTarget it2 = (SelectInTarget)t;
            boolean bl2 = false;
            if (!context2.selectIn(it2, requestFocus)) continue;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getProvider(), this.type);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof RootTypeBookmark && Intrinsics.areEqual((Object)((RootTypeBookmark)other).getProvider(), (Object)this.getProvider()) && Intrinsics.areEqual((Object)((RootTypeBookmark)other).type, (Object)this.type);
    }

    @NotNull
    public String toString() {
        return "ScratchBookmark(module=" + this.type.getId() + ",provider=" + this.getProvider() + ")";
    }

    @Override
    @NotNull
    public RootTypeBookmarkProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final RootType getType() {
        return this.type;
    }

    public RootTypeBookmark(@NotNull RootTypeBookmarkProvider provider2, @NotNull RootType type) {
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.provider = provider2;
        this.type = type;
    }
}

