/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0011\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u0012\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\u000fH\u0016J\u000f\u0010\u0011\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/ExternalFolderNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "Lcom/intellij/psi/PsiDirectory;", "directory", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "(Lcom/intellij/psi/PsiDirectory;Lcom/intellij/ide/projectView/ViewSettings;)V", "canRepresent", "", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getVirtualFile", "Lorg/jetbrains/annotations/NotNull;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.lang.impl"})
final class ExternalFolderNode
extends ProjectViewNode<PsiDirectory> {
    public boolean canRepresent(@Nullable Object element2) {
        VirtualFile virtualFile2 = this.getVirtualFile();
        return virtualFile2 != null ? virtualFile2.equals(element2) : false;
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile2;
            boolean bl2 = false;
            bl = VfsUtil.isAncestor(it, file2, true);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public VirtualFile getVirtualFile() {
        PsiDirectory psiDirectory = (PsiDirectory)this.getValue();
        return psiDirectory != null ? psiDirectory.getVirtualFile() : null;
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return ExtensionsKt.computeDirectoryChildren(this);
    }

    protected void update(@NotNull PresentationData presentation2) {
        Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
        VirtualFile virtualFile2 = this.getVirtualFile();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile file2 = virtualFile2;
        Pair<String, Icon> scratch = ExtensionsKt.computeScratchPresentation(this, file2);
        Object object = scratch;
        if (object == null || (object = (Icon)object.getSecond()) == null) {
            object = ExtensionsKt.findFileIcon(this);
        }
        presentation2.setIcon(object);
        Object object2 = scratch;
        if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
            object2 = file2.getPresentableName();
        }
        presentation2.setPresentableText(object2);
    }

    public ExternalFolderNode(@NotNull PsiDirectory directory, @Nullable ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        super(directory.getProject(), directory, settings);
    }
}

