/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.favoritesTreeView.FavoriteNodeProvider;
import com.intellij.ide.favoritesTreeView.FileGroupingProjectNode;
import com.intellij.ide.favoritesTreeView.FileSerializable;
import com.intellij.ide.favoritesTreeView.InvalidUsageNoteNode;
import com.intellij.ide.favoritesTreeView.InvalidUsageNoteProjectNode;
import com.intellij.ide.favoritesTreeView.NoteNode;
import com.intellij.ide.favoritesTreeView.NoteProjectNode;
import com.intellij.ide.favoritesTreeView.NoteSerializable;
import com.intellij.ide.favoritesTreeView.UsageProjectTreeNode;
import com.intellij.ide.favoritesTreeView.UsageSerializable;
import com.intellij.ide.favoritesTreeView.WorkingSetSerializable;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.usages.rules.UsageInFiles;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class UsageFavoriteNodeProvider
extends FavoriteNodeProvider {
    private static final Map<String, TreeSet<WorkingSetSerializable>> ourSerializables = new HashMap<String, TreeSet<WorkingSetSerializable>>();
    private static final Comparator<VirtualFile> VIRTUAL_FILE_COMPARATOR = Comparator.comparing(VirtualFile::getPath);
    private static final Logger LOG = Logger.getInstance(UsageFavoriteNodeProvider.class);

    private static TreeSet<WorkingSetSerializable> createSet() {
        return new TreeSet<WorkingSetSerializable>((o1, o2) -> {
            assert (o1.getId().equals(o2.getId()));
            return Comparing.compare(o1.getVersion(), o2.getVersion());
        });
    }

    @Override
    public Collection<AbstractTreeNode<?>> getFavoriteNodes(DataContext context2, @NotNull ViewSettings viewSettings) {
        Project project2;
        if (viewSettings == null) {
            UsageFavoriteNodeProvider.$$$reportNull$$$0(0);
        }
        if ((project2 = (Project)CommonDataKeys.PROJECT.getData(context2)) == null) {
            return null;
        }
        Usage[] usages = (Usage[])UsageView.USAGES_KEY.getData(context2);
        if (usages != null) {
            MultiMap<VirtualFile, Usage> map2 = new MultiMap<VirtualFile, Usage>();
            ArrayList<Usage> nonMapped = new ArrayList<Usage>();
            for (Usage usage2 : usages) {
                if (usage2 instanceof UsageInFile) {
                    map2.putValue(((UsageInFile)usage2).getFile(), usage2);
                    continue;
                }
                if (usage2 instanceof UsageInFiles) {
                    VirtualFile[] files2;
                    for (VirtualFile file2 : files2 = ((UsageInFiles)usage2).getFiles()) {
                        map2.putValue(file2, usage2);
                    }
                    continue;
                }
                nonMapped.add(usage2);
            }
            TreeSet<VirtualFile> keys2 = new TreeSet<VirtualFile>(VIRTUAL_FILE_COMPARATOR);
            keys2.addAll(map2.keySet());
            SmartList result2 = new SmartList();
            for (VirtualFile key : keys2) {
                FileGroupingProjectNode grouping = new FileGroupingProjectNode(project2, new File(key.getPath()), viewSettings);
                result2.add(grouping);
                Collection subUsages = map2.get(key);
                for (Usage usage3 : subUsages) {
                    if (usage3 instanceof UsageInfo2UsageAdapter) {
                        UsageProjectTreeNode node2 = new UsageProjectTreeNode(project2, ((UsageInfo2UsageAdapter)usage3).getUsageInfo(), viewSettings);
                        grouping.addChild(node2);
                        continue;
                    }
                    if (NullUsage.INSTANCE.equals(usage3)) continue;
                    grouping.addChild(new NoteProjectNode(project2, new NoteNode(usage3.getPresentation().getPlainText(), true), viewSettings));
                }
            }
            for (Usage usage2 : nonMapped) {
                if (usage2 instanceof UsageInfo2UsageAdapter) {
                    UsageProjectTreeNode node3 = new UsageProjectTreeNode(project2, ((UsageInfo2UsageAdapter)usage2).getUsageInfo(), viewSettings);
                    result2.add(node3);
                    continue;
                }
                if (NullUsage.INSTANCE.equals(usage2)) continue;
                result2.add(new NoteProjectNode(project2, new NoteNode(usage2.getPresentation().getPlainText(), true), viewSettings));
            }
            return result2;
        }
        return null;
    }

    public AbstractTreeNode createNode(Project project2, Object element2, @NotNull ViewSettings viewSettings) {
        if (viewSettings == null) {
            UsageFavoriteNodeProvider.$$$reportNull$$$0(1);
        }
        if (element2 instanceof UsageInfo) {
            return new UsageProjectTreeNode(project2, (UsageInfo)element2, viewSettings);
        }
        if (element2 instanceof InvalidUsageNoteNode) {
            return new InvalidUsageNoteProjectNode(project2, (InvalidUsageNoteNode)element2, viewSettings);
        }
        if (element2 instanceof NoteNode) {
            return new NoteProjectNode(project2, (NoteNode)element2, viewSettings);
        }
        if (element2 instanceof File) {
            return new FileGroupingProjectNode(project2, (File)element2, viewSettings);
        }
        return super.createNode(project2, element2, viewSettings);
    }

    @Override
    public PsiElement getPsiElement(Object element2) {
        if (element2 instanceof UsageInfo) {
            return ((UsageInfo)element2).getElement();
        }
        return super.getPsiElement(element2);
    }

    @Override
    public boolean elementContainsFile(Object element2, VirtualFile vFile) {
        return false;
    }

    @Override
    public int getElementWeight(Object element2, boolean isSortByType) {
        return 0;
    }

    @Override
    public String getElementLocation(Object element2) {
        if (element2 instanceof UsageInfo) {
            PsiElement psiElement = ((UsageInfo)element2).getElement();
            PsiFile file2 = psiElement == null ? null : psiElement.getContainingFile();
            return file2 == null ? null : file2.getPresentation().getPresentableText();
        }
        if (element2 instanceof File) {
            return ((File)element2).getParent();
        }
        return null;
    }

    @Override
    public boolean isInvalidElement(Object element2) {
        return false;
    }

    @Override
    @NotNull
    public String getFavoriteTypeId() {
        return "usage";
    }

    @Override
    public String getElementUrl(Object element2) {
        TreeSet<WorkingSetSerializable> serializables = ourSerializables.get(element2.getClass().getName());
        if (serializables != null && !serializables.isEmpty()) {
            WorkingSetSerializable last2 = serializables.last();
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(last2.getId());
                sb.append(' ');
                sb.append(last2.getVersion());
                sb.append(' ');
                last2.serializeMe(element2, sb);
                return sb.toString();
            }
            catch (IOException e) {
                LOG.info(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String getElementModuleName(Object element2) {
        if (element2 instanceof UsageInfo) {
            PsiElement psiElement = ((UsageInfo)element2).getElement();
            Module module = psiElement == null ? null : ModuleUtilCore.findModuleForPsiElement(psiElement);
            return module == null ? null : module.getName();
        }
        return null;
    }

    @Override
    public Object[] createPathFromUrl(Project project2, String url, String moduleName) {
        try {
            List<String> parts = StringUtil.split(url, " ", true);
            if (parts.size() < 3) {
                return null;
            }
            String id2 = parts.get(0);
            TreeSet<WorkingSetSerializable> set2 = ourSerializables.get(id2);
            if (set2 != null && !set2.isEmpty()) {
                int version = Integer.parseInt(parts.get(1));
                String cut = StringUtil.join(parts.subList(2, parts.size()), " ");
                Iterator<WorkingSetSerializable> iterator = set2.descendingIterator();
                while (iterator.hasNext()) {
                    WorkingSetSerializable serializable = iterator.next();
                    if (serializable.getVersion() != version) continue;
                    return UsageFavoriteNodeProvider.readWithSerializable(project2, cut, serializable);
                }
                UsageFavoriteNodeProvider.readWithSerializable(project2, cut, set2.last());
            }
        }
        catch (IOException e) {
            LOG.info(e);
        }
        return null;
    }

    private static Object[] readWithSerializable(Project project2, String is, WorkingSetSerializable serializable) throws IOException {
        Object[] objectArray;
        Object obj = serializable.deserializeMe(project2, is);
        if (obj == null) {
            obj = serializable.deserializeMeInvalid(project2, is);
        }
        if (obj == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = obj;
        }
        return objectArray;
    }

    static {
        TreeSet<WorkingSetSerializable> usageSet = UsageFavoriteNodeProvider.createSet();
        UsageSerializable serializable = new UsageSerializable();
        ourSerializables.put(serializable.getId(), usageSet);
        usageSet.add(serializable);
        TreeSet<WorkingSetSerializable> fileSet = UsageFavoriteNodeProvider.createSet();
        FileSerializable fileSerializable = new FileSerializable();
        ourSerializables.put(fileSerializable.getId(), fileSet);
        fileSet.add(fileSerializable);
        TreeSet<WorkingSetSerializable> noteSet = UsageFavoriteNodeProvider.createSet();
        NoteSerializable noteSerializable = new NoteSerializable();
        ourSerializables.put(noteSerializable.getId(), noteSet);
        noteSet.add(noteSerializable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "viewSettings";
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/UsageFavoriteNodeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getFavoriteNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

