/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class AddNewFavoritesListAction
extends AnAction
implements DumbAware {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddNewFavoritesListAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabledAndVisible(Registry.is("ide.favorites.tool.window.applicable", false));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            AddNewFavoritesListAction.$$$reportNull$$$0(1);
        }
        if ((project2 = e.getProject()) != null) {
            AddNewFavoritesListAction.doAddNewFavoritesList(project2);
        }
    }

    public static String doAddNewFavoritesList(final Project project2) {
        final FavoritesManager favoritesManager = FavoritesManager.getInstance(project2);
        String name2 = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"prompt.input.new.favorites.list.name", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.add.new.favorites.list", (Object[])new Object[0]), (Icon)Messages.getInformationIcon(), (String)AddNewFavoritesListAction.getUniqueName(project2), (InputValidator)new InputValidator(){

            @Override
            public boolean checkInput(String inputString) {
                return inputString != null && inputString.trim().length() > 0;
            }

            @Override
            public boolean canClose(String inputString) {
                inputString = inputString.trim();
                if (favoritesManager.getAvailableFavoritesListNames().contains(inputString)) {
                    Messages.showErrorDialog((Project)project2, (String)IdeBundle.message((String)"error.favorites.list.already.exists", (Object[])new Object[]{inputString.trim()}), (String)IdeBundle.message((String)"title.unable.to.add.favorites.list", (Object[])new Object[0]));
                    return false;
                }
                return inputString.length() > 0;
            }
        });
        if (name2 == null || name2.length() == 0) {
            return null;
        }
        favoritesManager.createNewList(name2);
        return name2;
    }

    private static String getUniqueName(Project project2) {
        List<String> names = FavoritesManager.getInstance(project2).getAvailableFavoritesListNames();
        int i = 0;
        String newName2;
        while (names.contains(newName2 = IdeBundle.message((String)"favorites.list.unnamed", (Object[])new Object[]{i > 0 ? Integer.valueOf(i) : ""}))) {
            ++i;
        }
        return newName2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/ide/favoritesTreeView/actions/AddNewFavoritesListAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

