/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.DynamicBundle;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.reference.SoftReference;
import com.intellij.util.ResourceUtil;
import java.io.IOException;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B)\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bBC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0006H\u0007J\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0014\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0018\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/fileTemplates/impl/DefaultTemplate;", "", "name", "", "extension", "templateUrl", "Ljava/net/URL;", "descriptionUrl", "(Ljava/lang/String;Ljava/lang/String;Ljava/net/URL;Ljava/net/URL;)V", "textSupplier", "Ljava/util/function/Supplier;", "descriptionLoader", "Ljava/util/function/Function;", "descriptionPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/function/Supplier;Ljava/util/function/Function;Ljava/lang/String;)V", "descriptionText", "Ljava/lang/ref/Reference;", "getExtension", "()Ljava/lang/String;", "getName", "qualifiedName", "getQualifiedName", "text", "getDescriptionText", "getTemplateURL", "getText", "toString", "intellij.platform.lang.impl"})
public final class DefaultTemplate {
    private Reference<String> text;
    private Reference<String> descriptionText;
    @NotNull
    private final String name;
    @NotNull
    private final String extension;
    private final Supplier<String> textSupplier;
    private final Function<String, String> descriptionLoader;
    private final String descriptionPath;

    @NotNull
    public final String getQualifiedName() {
        String string2 = FileTemplateBase.getQualifiedName(this.name, this.extension);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileTemplateBase.getQual\u2026ame(name, this.extension)");
        return string2;
    }

    @NotNull
    public final String getText() {
        String text2 = SoftReference.dereference(this.text);
        if (text2 == null) {
            text2 = StringUtil.convertLineSeparators(this.textSupplier.get());
            this.text = new java.lang.ref.SoftReference<String>(text2);
        }
        return text2;
    }

    @NotNull
    public final String getDescriptionText() {
        if (this.descriptionLoader == null) {
            return "";
        }
        String text2 = SoftReference.dereference(this.descriptionText);
        if (text2 != null) {
            return text2;
        }
        try {
            ClassLoader langBundleLoader;
            Object object = DynamicBundle.findLanguageBundle();
            ClassLoader classLoader = object != null && (object = ((DynamicBundle.LanguageBundleEP)object).pluginDescriptor) != null ? object.getPluginClassLoader() : (langBundleLoader = null);
            if (langBundleLoader != null && this.descriptionPath != null) {
                String string2;
                byte[] byArray = ResourceUtil.getResourceAsBytes("fileTemplates/" + this.descriptionPath, langBundleLoader);
                if (byArray != null) {
                    byte[] byArray2 = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"StandardCharsets.UTF_8");
                    Charset charset2 = charset;
                    string2 = new String(byArray2, charset2);
                } else {
                    string2 = text2 = null;
                }
            }
            if (text2 == null) {
                String string3 = this.descriptionPath;
                if (string3 == null) {
                    string3 = "";
                }
                text2 = Strings.convertLineSeparators(this.descriptionLoader.apply(string3));
            }
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(DefaultTemplate.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error(e);
            text2 = "";
        }
        this.descriptionText = new java.lang.ref.SoftReference<String>(text2);
        String string4 = text2;
        Intrinsics.checkNotNull((Object)string4);
        return string4;
    }

    @Deprecated(message="Do not use.")
    @NotNull
    public final URL getTemplateURL() {
        try {
            return new URL("https://not.relevant");
        }
        catch (MalformedURLException e) {
            throw (Throwable)new RuntimeException(e);
        }
    }

    @NotNull
    public String toString() {
        return this.textSupplier.toString();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getExtension() {
        return this.extension;
    }

    public DefaultTemplate(@NotNull String name2, @NotNull String extension2, @NotNull Supplier<String> textSupplier, @Nullable Function<String, String> descriptionLoader, @Nullable String descriptionPath) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter(textSupplier, (String)"textSupplier");
        this.name = name2;
        this.extension = extension2;
        this.textSupplier = textSupplier;
        this.descriptionLoader = descriptionLoader;
        this.descriptionPath = descriptionPath;
    }

    @Deprecated(message="Use {@link #DefaultTemplate(String, String, Supplier, Function, String)}")
    public DefaultTemplate(@NotNull String name2, @NotNull String extension2, final @NotNull URL templateUrl, final @Nullable URL descriptionUrl) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)extension2, (String)"extension");
        Intrinsics.checkNotNullParameter((Object)templateUrl, (String)"templateUrl");
        this(name2, extension2, new Supplier(){

            public final String get() {
                String string2;
                try {
                    string2 = ResourceUtil.loadText(templateUrl.openStream());
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(DefaultTemplate.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error(e);
                    string2 = "";
                }
                return string2;
            }
        }, descriptionUrl == null ? null : (Function)new Function(){

            @NotNull
            public final String apply(@NotNull String it) {
                String string2;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    string2 = ResourceUtil.loadText(descriptionUrl.openStream());
                }
                catch (IOException e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(DefaultTemplate.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                    logger.error(e);
                    string2 = "";
                }
                return string2;
            }
        }, null);
    }
}

