/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateHighlighter;
import com.intellij.ide.fileTemplates.impl.FileTemplateTokenType;
import com.intellij.ide.fileTemplates.impl._FileTemplateTextLexer;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.HTMLEditorKitBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class FileTemplateConfigurable
implements Configurable,
Configurable.NoScroll {
    @NonNls
    private static final String EMPTY_HTML = "<html></html>";
    private JPanel myMainPanel;
    private FileTemplate myTemplate;
    private Editor myTemplateEditor;
    private JTextField myNameField;
    private JTextField myExtensionField;
    private JCheckBox myAdjustBox;
    private JCheckBox myLiveTemplateBox;
    private JPanel myTopPanel;
    private EditorTextField myFileName;
    private JEditorPane myDescriptionComponent;
    private boolean myModified;
    private Supplier<@NonNls String> defaultDescriptionUrl;
    private final Project myProject;
    private final List<ChangeListener> myChangeListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private Splitter mySplitter;
    private final FileType myVelocityFileType = FileTypeManager.getInstance().getFileTypeByExtension("ft");
    private float myProportion = 0.6f;

    public FileTemplateConfigurable(Project project2) {
        this.myProject = project2;
    }

    public FileTemplate getTemplate() {
        return this.myTemplate;
    }

    public void setTemplate(@Nullable FileTemplate template, @Nullable Supplier<String> defaultDescription2) {
        this.setTemplate(template, defaultDescription2, false);
    }

    public void setTemplate(@Nullable FileTemplate template, @Nullable Supplier<String> defaultDescription2, boolean internalTemplate) {
        this.defaultDescriptionUrl = defaultDescription2;
        this.myTemplate = template;
        if (this.myMainPanel != null) {
            this.reset();
            this.updateTopPanel(internalTemplate);
            this.myNameField.selectAll();
            this.myExtensionField.selectAll();
            this.myFileName.setPlaceholder((CharSequence)IdeBundle.message((String)(template != null && FileTemplateBase.isChild(template) ? "template.file.name" : "template.file.name.optional"), (Object[])new Object[0]));
        }
    }

    private void updateTopPanel(boolean internalTemplate) {
        this.myTopPanel.removeAll();
        if (!internalTemplate) {
            boolean child;
            boolean bl = child = this.myTemplate != null && FileTemplateBase.isChild(this.myTemplate);
            if (!child) {
                JLabel label2 = new JLabel(IdeBundle.message((String)"label.name", (Object[])new Object[0]));
                label2.setLabelFor(this.myNameField);
                this.myTopPanel.add((Component)label2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, JBInsets.emptyInsets(), 0, 0));
                this.myTopPanel.add((Component)this.myNameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, JBUI.insets(0, 3), 0, 0));
            }
            JLabel extLabel = new JLabel(IdeBundle.message((String)"label.extension", (Object[])new Object[0]));
            extLabel.setLabelFor(this.myExtensionField);
            this.myTopPanel.add((Component)extLabel, new GridBagConstraints(child ? 0 : 2, child ? 1 : 0, 1, 1, 0.0, 0.0, 10, 0, JBInsets.emptyInsets(), 0, 0));
            this.myTopPanel.add((Component)this.myExtensionField, new GridBagConstraints(child ? 1 : 3, child ? 1 : 0, 1, 1, 0.3, 0.0, 17, child ? 0 : 2, JBUI.insetsLeft(3), 0, 0));
            if (child || this.isEditable() || StringUtil.isNotEmpty(this.myFileName.getText())) {
                JLabel label3 = new JLabel(IdeBundle.message((String)"label.generate.file.name", (Object[])new Object[0]));
                label3.setLabelFor((Component)this.myFileName);
                this.myTopPanel.add((Component)label3, new GridBagConstraints(0, child ? 0 : 1, 1, 1, 0.0, 0.0, 17, 0, JBInsets.emptyInsets(), 0, 0));
                this.myTopPanel.add((Component)this.myFileName, new GridBagConstraints(1, child ? 0 : 1, 3, 1, 1.0, 0.0, 10, 2, JBUI.insetsLeft(3), 0, 0));
            }
        }
        this.myMainPanel.revalidate();
        this.myTopPanel.repaint();
    }

    void setShowAdjustCheckBox(boolean show2) {
        this.myAdjustBox.setEnabled(show2);
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.edit.file.template", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        this.myNameField = new JTextField();
        this.myExtensionField = new JTextField(7);
        this.mySplitter = new Splitter(true, this.myProportion);
        this.myAdjustBox = new JCheckBox(IdeBundle.message((String)"checkbox.reformat.according.to.style", (Object[])new Object[0]));
        this.myLiveTemplateBox = new JCheckBox(IdeBundle.message((String)"checkbox.enable.live.templates", (Object[])new Object[0]));
        this.myTemplateEditor = this.createEditor(null);
        this.myFileName = new EditorTextField(this.createDocument(this.createFile("", "file name")), this.myProject, this.myVelocityFileType);
        this.myFileName.setFont(EditorUtil.getEditorFont());
        this.myFileName.setPlaceholder((CharSequence)IdeBundle.message((String)"template.file.name", (Object[])new Object[0]));
        this.myFileName.setShowPlaceholderWhenFocused(true);
        this.myDescriptionComponent = new JEditorPane();
        this.myDescriptionComponent.setEditorKit(HTMLEditorKitBuilder.simple());
        this.myDescriptionComponent.setText(EMPTY_HTML);
        this.myDescriptionComponent.setEditable(false);
        this.myDescriptionComponent.addHyperlinkListener((HyperlinkListener)new BrowserHyperlinkListener());
        this.myTopPanel = new JPanel(new GridBagLayout());
        this.myTopPanel.setBorder(JBUI.Borders.emptyBottom(3));
        JPanel descriptionPanel = new JPanel(new GridBagLayout());
        descriptionPanel.add((Component)new JLabel(IdeBundle.message((String)"label.description", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, JBUI.insetsBottom(2), 0, 0));
        descriptionPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myDescriptionComponent), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, JBUI.insetsTop(2), 0, 0));
        this.myMainPanel.add((Component)this.myTopPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, JBInsets.emptyInsets(), 0, 0));
        this.myMainPanel.add((Component)this.mySplitter, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 10, 1, JBInsets.emptyInsets(), 0, 0));
        this.mySplitter.setSecondComponent(descriptionPanel);
        this.updateTopPanel(false);
        this.myNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTemplateConfigurable.this.onNameChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$1", "focusLost"));
            }
        });
        this.myExtensionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                FileTemplateConfigurable.this.onNameChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$2", "focusLost"));
            }
        });
        this.myMainPanel.setPreferredSize(JBUI.size(400, 300));
        return this.myMainPanel;
    }

    public void setProportion(float proportion) {
        this.myProportion = proportion;
    }

    private Editor createEditor(@Nullable PsiFile file2) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document doc = this.createDocument(file2);
        Editor editor2 = editorFactory.createEditor(doc, this.myProject);
        EditorSettings editorSettings = editor2.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(3);
        editorSettings.setAdditionalLinesCount(3);
        editorSettings.setCaretRowShown(false);
        editor2.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                FileTemplateConfigurable.this.onTextChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable$3", "documentChanged"));
            }
        }, ((EditorImpl)editor2).getDisposable());
        ((EditorEx)editor2).setHighlighter(this.createHighlighter());
        JPanel topPanel = new JPanel(new BorderLayout(0, 5));
        JPanel southPanel = new JPanel((LayoutManager)new HorizontalLayout(40));
        southPanel.add(this.myAdjustBox);
        southPanel.add(this.myLiveTemplateBox);
        topPanel.add((Component)southPanel, "South");
        topPanel.add((Component)editor2.getComponent(), "Center");
        this.mySplitter.setFirstComponent(topPanel);
        return editor2;
    }

    @NotNull
    private Document createDocument(@Nullable PsiFile file2) {
        Document document;
        Document document2 = document = file2 != null ? PsiDocumentManager.getInstance(file2.getProject()).getDocument(file2) : null;
        Document document3 = document != null ? document : EditorFactory.getInstance().createDocument((CharSequence)(this.myTemplate == null ? "" : this.myTemplate.getText()));
        if (document3 == null) {
            FileTemplateConfigurable.$$$reportNull$$$0(0);
        }
        return document3;
    }

    private void onTextChanged() {
        this.myModified = true;
    }

    private void onNameChanged() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener changeListener : this.myChangeListeners) {
            changeListener.stateChanged(event);
        }
    }

    void addChangeListener(@NotNull ChangeListener listener2) {
        if (listener2 == null) {
            FileTemplateConfigurable.$$$reportNull$$$0(1);
        }
        if (!this.myChangeListeners.contains(listener2)) {
            this.myChangeListeners.add(listener2);
        }
    }

    public void removeChangeListener(ChangeListener listener2) {
        this.myChangeListeners.remove(listener2);
    }

    public boolean isModified() {
        String extension2;
        if (this.myModified) {
            return true;
        }
        String name2 = this.myTemplate == null ? "" : this.myTemplate.getName();
        String string2 = extension2 = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        if (!Objects.equals(name2, this.myNameField.getText())) {
            return true;
        }
        if (!Objects.equals(extension2, this.myExtensionField.getText())) {
            return true;
        }
        return this.myTemplate != null && (this.myTemplate.isReformatCode() != this.myAdjustBox.isSelected() || this.myTemplate.isLiveTemplateEnabled() != this.myLiveTemplateBox.isSelected() || !this.myTemplate.getFileName().equals(this.myFileName.getText()));
    }

    public void apply() throws ConfigurationException {
        if (this.myTemplate != null) {
            this.myTemplate.setText(this.myTemplateEditor.getDocument().getText());
            String name2 = this.myNameField.getText();
            String extension2 = this.myExtensionField.getText();
            String filename = name2 + "." + extension2;
            if (name2.length() == 0 || !FileTemplateConfigurable.isValidFilename(filename)) {
                throw new ConfigurationException(IdeBundle.message((String)"error.invalid.template.file.name.or.extension", (Object[])new Object[0]));
            }
            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(filename);
            if (fileType == UnknownFileType.INSTANCE) {
                FileTypeChooser.associateFileType((String)filename);
            }
            this.myTemplate.setName(name2);
            this.myTemplate.setFileName(this.myFileName.getText());
            this.myTemplate.setExtension(extension2);
            this.myTemplate.setReformatCode(this.myAdjustBox.isSelected());
            this.myTemplate.setLiveTemplateEnabled(this.myLiveTemplateBox.isSelected());
        }
        this.myModified = false;
    }

    private static boolean isValidFilename(String filename) {
        if (filename.contains("/") || filename.contains("\\") || filename.contains(":")) {
            return false;
        }
        File tempFile = new File(FileUtil.getTempDirectory() + File.separator + filename);
        return FileUtil.ensureCanCreateFile(tempFile);
    }

    public void reset() {
        String description;
        String text2 = this.myTemplate == null ? "" : this.myTemplate.getText();
        String name2 = this.myTemplate == null ? "" : this.myTemplate.getName();
        String extension2 = this.myTemplate == null ? "" : this.myTemplate.getExtension();
        String string2 = description = this.myTemplate == null ? "" : this.myTemplate.getDescription();
        if (description.isEmpty() && this.defaultDescriptionUrl != null) {
            description = this.defaultDescriptionUrl.get();
        }
        EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
        this.myTemplateEditor = this.createEditor(this.myTemplate == null ? null : this.createFile(text2, name2));
        this.myNameField.setText(name2);
        this.myFileName.setText(this.myTemplate == null ? "" : this.myTemplate.getFileName());
        this.myExtensionField.setText(extension2);
        this.myAdjustBox.setSelected(this.myTemplate != null && this.myTemplate.isReformatCode());
        this.myLiveTemplateBox.setSelected(this.myTemplate != null && this.myTemplate.isLiveTemplateEnabled());
        int i = description.indexOf("<html>");
        if (i > 0) {
            description = description.substring(i);
        }
        description = XmlStringUtil.stripHtml(description);
        description = description.replace("\n", "").replace("\r", "");
        description = XmlStringUtil.stripHtml(description);
        description = IdeBundle.message((String)"http.velocity", (Object[])new Object[]{description});
        this.myDescriptionComponent.setText(description);
        this.myDescriptionComponent.setCaretPosition(0);
        boolean editable = this.isEditable();
        this.myNameField.setEditable(editable);
        this.myExtensionField.setEditable(editable);
        this.myFileName.setViewer(!editable);
        this.myModified = false;
    }

    private boolean isEditable() {
        return this.myTemplate != null && !this.myTemplate.isDefault();
    }

    @Nullable
    private PsiFile createFile(String text2, String name2) {
        FileType fileType = this.myVelocityFileType;
        if (fileType == FileTypes.UNKNOWN) {
            return null;
        }
        PsiFile file2 = PsiFileFactory.getInstance(this.myProject).createFileFromText(name2 + ".txt.ft", fileType, (CharSequence)text2, 0L, true);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)FileTemplateManager.getInstance((Project)this.myProject).getDefaultProperties());
        properties.setProperty("NAME", IdeBundle.message((String)"name.variable", (Object[])new Object[0]));
        file2.getViewProvider().putUserData(FileTemplateManager.DEFAULT_TEMPLATE_PROPERTIES, properties);
        return file2;
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
        if (this.myTemplateEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myTemplateEditor);
            this.myTemplateEditor = null;
        }
    }

    private EditorHighlighter createHighlighter() {
        SyntaxHighlighter originalHighlighter;
        if (this.myTemplate != null && this.myVelocityFileType != FileTypes.UNKNOWN) {
            return EditorHighlighterFactory.getInstance().createEditorHighlighter(this.myProject, (VirtualFile)new LightVirtualFile("aaa." + this.myTemplate.getExtension() + ".ft"));
        }
        FileType fileType = null;
        if (this.myTemplate != null) {
            fileType = FileTypeManager.getInstance().getFileTypeByExtension(this.myTemplate.getExtension());
        }
        if (fileType == null) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        if ((originalHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, null, null)) == null) {
            originalHighlighter = new PlainSyntaxHighlighter();
        }
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        LayeredLexerEditorHighlighter highlighter = new LayeredLexerEditorHighlighter((SyntaxHighlighter)new FileTemplateHighlighter(), scheme);
        highlighter.registerLayer(FileTemplateTokenType.TEXT, new LayerDescriptor(originalHighlighter, ""));
        return highlighter;
    }

    @VisibleForTesting
    @NotNull
    public static Lexer createDefaultLexer() {
        return new MergingLexerAdapter(new FlexAdapter(new _FileTemplateTextLexer()), TokenSet.create(FileTemplateTokenType.TEXT));
    }

    void focusToNameField() {
        Object field = FileTemplateBase.isChild(this.myTemplate) ? this.myFileName : this.myNameField;
        this.myNameField.selectAll();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> FileTemplateConfigurable.lambda$focusToNameField$0((JComponent)field));
    }

    private static /* synthetic */ void lambda$focusToNameField$0(JComponent field) {
        IdeFocusManager.getGlobalInstance().requestFocus((Component)field, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

