/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoader;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExportableFileTemplateSettings", storages={@Storage(value="file.template.settings.xml")})
class FileTemplateSettings
extends FileTemplatesLoader
implements PersistentStateComponent<Element> {
    static final String EXPORTABLE_SETTINGS_FILE = "file.template.settings.xml";
    private static final String ELEMENT_TEMPLATE = "template";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_FILE_NAME = "file-name";
    private static final String ATTRIBUTE_REFORMAT = "reformat";
    private static final String ATTRIBUTE_LIVE_TEMPLATE = "live-template-enabled";
    private static final String ATTRIBUTE_ENABLED = "enabled";

    FileTemplateSettings(@Nullable Project project2) {
        super(project2);
    }

    @Override
    @Nullable
    public Element getState() {
        Element element2 = new Element("fileTemplateSettings");
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = null;
            for (FileTemplateBase template : manager.getAllTemplates(true)) {
                if (!FileTemplateSettings.shouldSave(template)) continue;
                Element templateElement2 = FileTemplateSettings.saveTemplate(template);
                for (FileTemplate child : template.getChildren()) {
                    templateElement2.addContent(FileTemplateSettings.saveTemplate((FileTemplateBase)child));
                }
                if (templatesGroup == null) {
                    templatesGroup = new Element(FileTemplateSettings.getXmlElementGroupName(manager));
                    element2.addContent(templatesGroup);
                }
                templatesGroup.addContent(templateElement2);
            }
        }
        return element2;
    }

    private static boolean shouldSave(FileTemplateBase template) {
        boolean shouldSave;
        boolean bl = shouldSave = !template.isReformatCode() || !template.getFileName().isEmpty() || template.isLiveTemplateEnabledChanged() && template.isLiveTemplateEnabled() != template.isLiveTemplateEnabledByDefault();
        if (template instanceof BundledFileTemplate) {
            shouldSave |= !((BundledFileTemplate)template).isEnabled();
        }
        return shouldSave || ContainerUtil.or(template.getChildren(), child -> FileTemplateSettings.shouldSave((FileTemplateBase)child));
    }

    @NotNull
    private static Element saveTemplate(FileTemplateBase template) {
        Element templateElement2 = new Element(ELEMENT_TEMPLATE);
        templateElement2.setAttribute(ATTRIBUTE_NAME, template.getQualifiedName());
        if (!template.getFileName().isEmpty()) {
            templateElement2.setAttribute(ATTRIBUTE_FILE_NAME, template.getFileName());
        }
        templateElement2.setAttribute(ATTRIBUTE_REFORMAT, Boolean.toString(template.isReformatCode()));
        templateElement2.setAttribute(ATTRIBUTE_LIVE_TEMPLATE, Boolean.toString(template.isLiveTemplateEnabled()));
        if (template instanceof BundledFileTemplate) {
            templateElement2.setAttribute(ATTRIBUTE_ENABLED, Boolean.toString(((BundledFileTemplate)template).isEnabled()));
        }
        Element element2 = templateElement2;
        if (element2 == null) {
            FileTemplateSettings.$$$reportNull$$$0(0);
        }
        return element2;
    }

    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            FileTemplateSettings.$$$reportNull$$$0(1);
        }
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = state.getChild(FileTemplateSettings.getXmlElementGroupName(manager));
            if (templatesGroup == null) continue;
            for (Element element2 : templatesGroup.getChildren(ELEMENT_TEMPLATE)) {
                FileTemplateSettings.loadTemplate(element2, manager);
                for (Element child : element2.getChildren(ELEMENT_TEMPLATE)) {
                    FileTemplateSettings.loadTemplate(child, manager);
                }
            }
        }
    }

    private static void loadTemplate(Element element2, FTManager manager) {
        String qName = element2.getAttributeValue(ATTRIBUTE_NAME);
        if (qName == null) {
            return;
        }
        FileTemplateBase template = manager.getTemplate(qName);
        if (template == null) {
            return;
        }
        template.setFileName(StringUtil.notNullize(element2.getAttributeValue(ATTRIBUTE_FILE_NAME)));
        template.setReformatCode(Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_REFORMAT)));
        template.setLiveTemplateEnabled(Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_LIVE_TEMPLATE)));
        if (template instanceof BundledFileTemplate) {
            ((BundledFileTemplate)template).setEnabled(Boolean.parseBoolean(element2.getAttributeValue(ATTRIBUTE_ENABLED, "true")));
        }
    }

    private static String getXmlElementGroupName(@NotNull FTManager manager) {
        if (manager == null) {
            FileTemplateSettings.$$$reportNull$$$0(2);
        }
        return StringUtil.toLowerCase(manager.getName()) + "_templates";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/FileTemplateSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "saveTemplate";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/FileTemplateSettings";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getXmlElementGroupName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

