/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.DefaultTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateLoadResult;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoader;
import com.intellij.ide.fileTemplates.impl.FileTemplatesLoaderKt;
import com.intellij.ide.fileTemplates.impl.LoadedConfiguration;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.cl.PluginAwareClassLoader;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.project.ProjectKt;
import com.intellij.util.ResourceUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000`\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a0\u0010\t\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000eH\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0002\u001a&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0002\u001a&\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001ax\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00010\u001f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00162\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010 2\u0006\u0010\u0019\u001a\u00020\u00142\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\"2'\u0010#\u001a#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b(\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050$H\u0082\b\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"DEFAULT_TEMPLATES_ROOT", "", "DESCRIPTION_EXTENSION_SUFFIX", "DESCRIPTION_FILE_EXTENSION", "createSupplierForUrlSource", "Ljava/util/function/Supplier;", "root", "Ljava/net/URL;", "path", "getDescriptionPath", "pathPrefix", "templateName", "templateExtension", "descriptionPaths", "", "loadConfiguration", "Lcom/intellij/ide/fileTemplates/impl/LoadedConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "loadDefaultTemplates", "Lcom/intellij/ide/fileTemplates/impl/FileTemplateLoadResult;", "prefixes", "", "loadDefaultsFromDirectory", "", "result", "loadDefaultsFromJar", "url", "loadTemplate", "processTemplates", "files", "Lkotlin/sequences/Sequence;", "", "descriptionLoader", "Ljava/util/function/Function;", "dataLoader", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "urlToPath", "Ljava/nio/file/Path;", "intellij.platform.lang.impl"})
public final class FileTemplatesLoaderKt {
    private static final String DEFAULT_TEMPLATES_ROOT = "fileTemplates";
    private static final String DESCRIPTION_FILE_EXTENSION = "html";
    private static final String DESCRIPTION_EXTENSION_SUFFIX = ".html";

    private static final String getDescriptionPath(String pathPrefix, String templateName, String templateExtension, Set<String> descriptionPaths) {
        Object path2;
        Locale locale = Locale.getDefault();
        Object[] objectArray = new Object[4];
        objectArray[0] = templateName;
        objectArray[1] = templateExtension;
        Locale locale2 = locale;
        Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"locale");
        objectArray[2] = locale2.getLanguage();
        objectArray[3] = locale.getCountry();
        Object name2 = MessageFormat.format("{0}.{1}_{2}_{3}.html", objectArray);
        CharSequence charSequence = pathPrefix;
        Object object = path2 = charSequence.length() == 0 ? name2 : pathPrefix + "/" + (String)name2;
        if (descriptionPaths.contains(path2)) {
            return path2;
        }
        name2 = MessageFormat.format("{0}.{1}_{2}.html", templateName, templateExtension, locale.getLanguage());
        charSequence = pathPrefix;
        Object object2 = path2 = charSequence.length() == 0 ? name2 : pathPrefix + "/" + (String)name2;
        if (descriptionPaths.contains(path2)) {
            return path2;
        }
        name2 = templateName + "." + templateExtension + DESCRIPTION_EXTENSION_SUFFIX;
        charSequence = pathPrefix;
        path2 = charSequence.length() == 0 ? name2 : pathPrefix + "/" + (String)name2;
        return descriptionPaths.contains(path2) ? path2 : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final LoadedConfiguration loadConfiguration(Project project2) {
        void $this$mapTo$iv$iv;
        Path path2;
        if (project2 == null || project2.isDefault()) {
            path2 = PathManager.getConfigDir().resolve(DEFAULT_TEMPLATES_ROOT);
        } else {
            Path path3 = ProjectKt.getStateStore(project2).getProjectFilePath();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"project.stateStore.projectFilePath");
            path2 = path3.getParent().resolve(DEFAULT_TEMPLATES_ROOT);
        }
        Path configDir = path2;
        List managerToDir = CollectionsKt.listOf((Object[])new Pair[]{TuplesKt.to((Object)"Default", (Object)""), TuplesKt.to((Object)"Internal", (Object)"internal"), TuplesKt.to((Object)"Includes", (Object)"includes"), TuplesKt.to((Object)"Code", (Object)"code"), TuplesKt.to((Object)"J2EE", (Object)"j2ee")});
        Iterable $this$map$iv = managerToDir;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = (String)it.getSecond();
            collection.add(string2);
        }
        FileTemplateLoadResult result2 = FileTemplatesLoaderKt.loadDefaultTemplates((List)destination$iv$iv);
        HashMap<void, FTManager> managers2 = new HashMap<void, FTManager>(managerToDir.size());
        for (Pair pair : managerToDir) {
            void name2;
            destination$iv$iv = (String)pair.component1();
            String pathPrefix = (String)pair.component2();
            Path path4 = configDir.resolve(pathPrefix);
            List list2 = result2.prefixToTemplates.get(pathPrefix);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            FTManager manager = new FTManager((String)name2, path4, list2, Intrinsics.areEqual((Object)name2, (Object)"Internal"));
            manager.loadCustomizedContent();
            managers2.put(name2, manager);
        }
        return new LoadedConfiguration((Map<String, FTManager>)managers2, result2.defaultTemplateDescription, result2.defaultIncludeDescription);
    }

    private static final FileTemplateLoadResult loadDefaultTemplates(List<String> prefixes) {
        FileTemplateLoadResult result2 = new FileTemplateLoadResult(new HashMap());
        HashSet<URL> processedUrls = new HashSet<URL>();
        Set<ClassLoader> processedLoaders = Collections.newSetFromMap(new IdentityHashMap());
        for (IdeaPluginDescriptorImpl plugin : PluginManagerCore.getPluginSet().enabledPlugins) {
            ClassLoader loader;
            Intrinsics.checkNotNullExpressionValue((Object)plugin.getClassLoader(), (String)"plugin.classLoader");
            if (loader instanceof PluginAwareClassLoader && ((PluginAwareClassLoader)((Object)loader)).getFiles().isEmpty() || !processedLoaders.add(loader)) continue;
            try {
                Enumeration<URL> resourceUrls;
                Enumeration<URL> enumeration = resourceUrls = loader instanceof UrlClassLoader ? ((UrlClassLoader)loader).getClassPath().getResources(DEFAULT_TEMPLATES_ROOT) : loader.getResources(DEFAULT_TEMPLATES_ROOT);
                while (resourceUrls.hasMoreElements()) {
                    URL url = resourceUrls.nextElement();
                    if (!processedUrls.add(url)) continue;
                    URL uRL = url;
                    Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"url");
                    String protocol = uRL.getProtocol();
                    if (StringsKt.equals((String)"jar", (String)protocol, (boolean)true)) {
                        FileTemplatesLoaderKt.loadDefaultsFromJar(url, prefixes, result2);
                        continue;
                    }
                    if (!StringsKt.equals((String)"file", (String)protocol, (boolean)true)) continue;
                    FileTemplatesLoaderKt.loadDefaultsFromDirectory(url, result2, prefixes);
                }
            }
            catch (IOException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(FileTemplatesLoader.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.error(e);
            }
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void loadDefaultsFromJar(URL url, List<String> prefixes, FileTemplateLoadResult result2) {
        void files$iv;
        String path22;
        List<String> list2 = UrlUtil.getChildPathsFromJar(url);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"UrlUtil.getChildPathsFromJar(url)");
        List<String> children2 = list2;
        if (children2.isEmpty()) {
            return;
        }
        Set descriptionPaths = new HashSet();
        for (String path22 : children2) {
            if (Intrinsics.areEqual((Object)path22, (Object)"default.html")) {
                result2.defaultTemplateDescription = FileTemplatesLoaderKt.createSupplierForUrlSource(url, path22);
                continue;
            }
            if (Intrinsics.areEqual((Object)path22, (Object)"includes/default.html")) {
                result2.defaultIncludeDescription = FileTemplatesLoaderKt.createSupplierForUrlSource(url, path22);
                continue;
            }
            String string2 = path22;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
            if (!StringsKt.endsWith$default((String)string2, (String)DESCRIPTION_EXTENSION_SUFFIX, (boolean)false, (int)2, null)) continue;
            descriptionPaths.add(path22);
        }
        path22 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)children2), (Function1)loadDefaultsFromJar.1.INSTANCE);
        Function function = new Function(url){
            final /* synthetic */ URL $url;

            @NotNull
            public final String apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FileTemplatesLoaderKt.access$loadTemplate(this.$url, it);
            }
            {
                this.$url = uRL;
            }
        };
        boolean $i$f$processTemplates = false;
        for (String path$iv : files$iv) {
            void descriptionLoader$iv;
            void it;
            String templateName$iv;
            String extension$iv;
            String filename$iv;
            String prefix$iv;
            Object v3;
            CharSequence charSequence;
            Object element$iv$iv22;
            block7: {
                Iterable $this$firstOrNull$iv$iv = prefixes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv22 : $this$firstOrNull$iv$iv) {
                    String it$iv = (String)element$iv$iv22;
                    boolean bl = false;
                    charSequence = it$iv;
                    boolean bl2 = charSequence.length() == 0 ? !StringsKt.contains$default((CharSequence)path$iv, (char)'/', (boolean)false, (int)2, null) : path$iv.length() > it$iv.length() && path$iv.charAt(it$iv.length()) == '/' && StringsKt.startsWith$default((String)path$iv, (String)it$iv, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)path$iv, (char)'/', (int)(it$iv.length() + 1), (boolean)false, (int)4, null) == -1;
                    if (!bl2) continue;
                    v3 = element$iv$iv22;
                    break block7;
                }
                v3 = null;
            }
            if ((String)v3 == null) {
                continue;
            }
            String $i$f$firstOrNull = path$iv;
            CharSequence charSequence2 = prefix$iv;
            int n = charSequence2.length() == 0 ? 0 : prefix$iv.length() + 1;
            int element$iv$iv22 = path$iv.length() - ".ft".length();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$firstOrNull.substring(n, element$iv$iv22), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension(filename$iv), (String)"FileUtilRt.getExtension(filename)");
            element$iv$iv22 = filename$iv;
            int it$iv = 0;
            int n2 = filename$iv.length() - extension$iv.length() - 1;
            Intrinsics.checkNotNullExpressionValue((Object)((String)element$iv$iv22).substring(it$iv, n2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String descriptionPath$iv = FileTemplatesLoaderKt.getDescriptionPath(prefix$iv, templateName$iv, extension$iv, descriptionPaths);
            String string3 = path$iv;
            String string4 = extension$iv;
            String string5 = templateName$iv;
            boolean bl = false;
            Supplier<String> supplier2 = FileTemplatesLoaderKt.createSupplierForUrlSource(url, (String)it);
            void var15_20 = descriptionLoader$iv;
            charSequence = var15_20;
            Supplier<String> supplier3 = supplier2;
            String string6 = string4;
            String string7 = string5;
            boolean bl3 = false;
            boolean bl4 = descriptionPath$iv != null;
            String string8 = descriptionPath$iv;
            Function<String, String> function2 = bl4 ? var15_20 : null;
            Supplier<String> supplier4 = supplier3;
            String string9 = string6;
            String string10 = string7;
            DefaultTemplate template$iv = new DefaultTemplate(string10, string9, supplier4, function2, string8);
            result2.prefixToTemplates.computeIfAbsent(prefix$iv, processTemplates.1.INSTANCE).add(template$iv);
        }
    }

    private static final void processTemplates(Sequence<String> files2, List<String> prefixes, Set<String> descriptionPaths, FileTemplateLoadResult result2, Function<String, String> descriptionLoader, Function1<? super String, ? extends Supplier<String>> dataLoader2) {
        int $i$f$processTemplates = 0;
        for (String path2 : files2) {
            String templateName;
            String extension2;
            String filename;
            String prefix;
            Object v1;
            Object object;
            Object element$iv22;
            block3: {
                Iterable $this$firstOrNull$iv = prefixes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv22 : $this$firstOrNull$iv) {
                    String it = (String)element$iv22;
                    boolean bl = false;
                    object = it;
                    boolean bl2 = object.length() == 0 ? !StringsKt.contains$default((CharSequence)path2, (char)'/', (boolean)false, (int)2, null) : path2.length() > it.length() && path2.charAt(it.length()) == '/' && StringsKt.startsWith$default((String)path2, (String)it, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)path2, (char)'/', (int)(it.length() + 1), (boolean)false, (int)4, null) == -1;
                    if (!bl2) continue;
                    v1 = element$iv22;
                    break block3;
                }
                v1 = null;
            }
            if ((String)v1 == null) {
                continue;
            }
            String $i$f$firstOrNull = path2;
            CharSequence charSequence = prefix;
            int n = charSequence.length() == 0 ? 0 : prefix.length() + 1;
            int element$iv22 = path2.length() - ".ft".length();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$firstOrNull.substring(n, element$iv22), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension(filename), (String)"FileUtilRt.getExtension(filename)");
            element$iv22 = filename;
            int it = 0;
            int n2 = filename.length() - extension2.length() - 1;
            Intrinsics.checkNotNullExpressionValue((Object)((String)element$iv22).substring(it, n2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String descriptionPath = FileTemplatesLoaderKt.getDescriptionPath(prefix, templateName, extension2, descriptionPaths);
            Function<String, String> function = descriptionLoader;
            object = function;
            Supplier supplier2 = (Supplier)dataLoader2.invoke((Object)path2);
            String string2 = extension2;
            String string3 = templateName;
            boolean bl = false;
            boolean bl3 = descriptionPath != null;
            String string4 = descriptionPath;
            Function<String, String> function2 = bl3 ? function : null;
            Supplier supplier3 = supplier2;
            String string5 = string2;
            String string6 = string3;
            DefaultTemplate template = new DefaultTemplate(string6, string5, supplier3, function2, string4);
            result2.prefixToTemplates.computeIfAbsent(prefix, processTemplates.1.INSTANCE).add(template);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final void loadDefaultsFromDirectory(URL root, FileTemplateLoadResult result2, List<String> prefixes) {
        void files$iv;
        HashSet descriptionPaths = new HashSet();
        List templateFiles = new ArrayList();
        Path rootFile = FileTemplatesLoaderKt.urlToPath(root);
        AutoCloseable autoCloseable = Files.find(rootFile, Integer.MAX_VALUE, loadDefaultsFromDirectory.1.INSTANCE, new FileVisitOption[0]);
        Object object = null;
        try {
            Stream it = (Stream)autoCloseable;
            boolean bl = false;
            it.forEach(new Consumer(rootFile, result2, descriptionPaths, templateFiles){
                final /* synthetic */ Path $rootFile$inlined;
                final /* synthetic */ FileTemplateLoadResult $result$inlined;
                final /* synthetic */ HashSet $descriptionPaths$inlined;
                final /* synthetic */ List $templateFiles$inlined;
                {
                    this.$rootFile$inlined = path2;
                    this.$result$inlined = fileTemplateLoadResult;
                    this.$descriptionPaths$inlined = hashSet;
                    this.$templateFiles$inlined = list2;
                }

                public final void accept(Path file2) {
                    String path2 = StringsKt.replace$default((String)((Object)this.$rootFile$inlined.relativize(file2)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
                    if (StringsKt.endsWith$default((String)path2, (String)"/default.html", (boolean)false, (int)2, null)) {
                        this.$result$inlined.defaultTemplateDescription = new Supplier(file2){
                            final /* synthetic */ Path $file;
                            {
                                this.$file = path2;
                            }

                            @NotNull
                            public final String get() {
                                return Files.readString(this.$file);
                            }
                        };
                    } else if (StringsKt.endsWith$default((String)path2, (String)"/includes/default.html", (boolean)false, (int)2, null)) {
                        this.$result$inlined.defaultIncludeDescription = new Supplier(file2){
                            final /* synthetic */ Path $file;
                            {
                                this.$file = path2;
                            }

                            @NotNull
                            public final String get() {
                                return Files.readString(this.$file);
                            }
                        };
                    } else if (StringsKt.endsWith$default((String)path2, (String)".html", (boolean)false, (int)2, null)) {
                        this.$descriptionPaths$inlined.add(path2);
                    } else if (StringsKt.endsWith$default((String)path2, (String)".ft", (boolean)false, (int)2, null)) {
                        this.$templateFiles$inlined.add(path2);
                    }
                }
            });
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            object = it;
            throw it;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
        autoCloseable = CollectionsKt.asSequence((Iterable)templateFiles);
        object = new Function(rootFile){
            final /* synthetic */ Path $rootFile;

            @NotNull
            public final String apply(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Files.readString(this.$rootFile.resolve(it));
            }
            {
                this.$rootFile = path2;
            }
        };
        boolean $i$f$processTemplates = false;
        for (String path$iv : files$iv) {
            void descriptionLoader$iv;
            void it;
            String templateName$iv;
            String extension$iv;
            String filename$iv;
            String prefix$iv;
            Object v1;
            CharSequence charSequence;
            Object element$iv$iv22;
            block9: {
                Iterable $this$firstOrNull$iv$iv = prefixes;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv22 : $this$firstOrNull$iv$iv) {
                    String it$iv = (String)element$iv$iv22;
                    boolean bl = false;
                    charSequence = it$iv;
                    boolean bl2 = charSequence.length() == 0 ? !StringsKt.contains$default((CharSequence)path$iv, (char)'/', (boolean)false, (int)2, null) : path$iv.length() > it$iv.length() && path$iv.charAt(it$iv.length()) == '/' && StringsKt.startsWith$default((String)path$iv, (String)it$iv, (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)path$iv, (char)'/', (int)(it$iv.length() + 1), (boolean)false, (int)4, null) == -1;
                    if (!bl2) continue;
                    v1 = element$iv$iv22;
                    break block9;
                }
                v1 = null;
            }
            if ((String)v1 == null) {
                continue;
            }
            String $i$f$firstOrNull = path$iv;
            CharSequence charSequence2 = prefix$iv;
            int n = charSequence2.length() == 0 ? 0 : prefix$iv.length() + 1;
            int element$iv$iv22 = path$iv.length() - ".ft".length();
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$firstOrNull.substring(n, element$iv$iv22), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.getExtension(filename$iv), (String)"FileUtilRt.getExtension(filename)");
            element$iv$iv22 = filename$iv;
            int it$iv = 0;
            int n2 = filename$iv.length() - extension$iv.length() - 1;
            Intrinsics.checkNotNullExpressionValue((Object)((String)element$iv$iv22).substring(it$iv, n2), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String descriptionPath$iv = FileTemplatesLoaderKt.getDescriptionPath(prefix$iv, templateName$iv, extension$iv, descriptionPaths);
            String string2 = path$iv;
            String string3 = extension$iv;
            String string4 = templateName$iv;
            boolean bl = false;
            Supplier supplier2 = new Supplier((String)it, rootFile){
                final /* synthetic */ String $it;
                final /* synthetic */ Path $rootFile$inlined;
                {
                    this.$it = string2;
                    this.$rootFile$inlined = path2;
                }

                @NotNull
                public final String get() {
                    return Files.readString(this.$rootFile$inlined.resolve(this.$it));
                }
            };
            void var16_25 = descriptionLoader$iv;
            charSequence = var16_25;
            Supplier supplier3 = supplier2;
            String string5 = string3;
            String string6 = string4;
            boolean bl3 = false;
            boolean bl4 = descriptionPath$iv != null;
            String string7 = descriptionPath$iv;
            Function<String, String> function = bl4 ? var16_25 : null;
            Supplier supplier4 = supplier3;
            String string8 = string5;
            String string9 = string6;
            DefaultTemplate template$iv = new DefaultTemplate(string9, string8, supplier4, function, string7);
            result2.prefixToTemplates.computeIfAbsent(prefix$iv, processTemplates.1.INSTANCE).add(template$iv);
        }
    }

    private static final Path urlToPath(URL root) {
        URI uRI = root.toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"root.toURI()");
        String path2 = uRI.getPath();
        if (SystemInfoRt.isWindows) {
            int position;
            String string2 = path2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
            if (StringsKt.startsWith$default((String)string2, (String)"/", (boolean)false, (int)2, null) && (position = StringsKt.indexOf$default((CharSequence)path2, (char)':', (int)0, (boolean)false, (int)6, null)) > 1) {
                String string3 = path2;
                int n = position - 1;
                String string4 = string3.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                path2 = string4;
            }
        }
        Path path3 = Path.of(path2, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"Path.of(path)");
        return path3;
    }

    private static final Supplier<String> createSupplierForUrlSource(URL root, String path2) {
        return new Supplier<String>(root, path2){
            final /* synthetic */ URL $root;
            final /* synthetic */ String $path;

            @NotNull
            public String get() {
                return FileTemplatesLoaderKt.access$loadTemplate(this.$root, this.$path);
            }

            @NotNull
            public String toString() {
                return "(root=" + this.$root + ", path=" + this.$path + ")";
            }
            {
                this.$root = $captured_local_variable$0;
                this.$path = $captured_local_variable$1;
            }
        };
    }

    private static final String loadTemplate(URL root, String path2) {
        String string2;
        try {
            String string3 = ResourceUtil.loadText(new URL(root, "fileTemplates/" + StringsKt.trimEnd((String)path2, (char[])new char[]{'/'})).openStream());
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"ResourceUtil.loadText(UR\u2026End('/')}\").openStream())");
            string2 = string3;
        }
        catch (IOException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FileTemplatesLoader.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.error(e);
            string2 = "";
        }
        return string2;
    }

    public static final /* synthetic */ LoadedConfiguration access$loadConfiguration(Project project2) {
        return FileTemplatesLoaderKt.loadConfiguration(project2);
    }

    public static final /* synthetic */ String access$loadTemplate(URL root, String path2) {
        return FileTemplatesLoaderKt.loadTemplate(root, path2);
    }
}

