/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ResourceUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.HashMapZipFile;
import com.intellij.util.lang.ImmutableZipEntry;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class UrlUtil {
    private static final String URL_PATH_SEPARATOR = "/";
    private static final String FILE_PROTOCOL_PREFIX = "file:";

    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        if (url == null) {
            UrlUtil.$$$reportNull$$$0(0);
        }
        String string2 = ResourceUtil.loadText(url.openStream());
        if (string2 == null) {
            UrlUtil.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public static List<String> getChildrenRelativePaths(@NotNull URL root) throws IOException {
        String protocol;
        if (root == null) {
            UrlUtil.$$$reportNull$$$0(2);
        }
        if ("jar".equalsIgnoreCase(protocol = root.getProtocol())) {
            return UrlUtil.getChildPathsFromJar(root);
        }
        if ("file".equalsIgnoreCase(protocol)) {
            return UrlUtil.getChildPathsFromFile(root);
        }
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            UrlUtil.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    private static List<String> getChildPathsFromFile(@NotNull URL root) {
        if (root == null) {
            UrlUtil.$$$reportNull$$$0(4);
        }
        final ArrayList<String> paths2 = new ArrayList<String>();
        File rootFile = new File(FileUtil.unquote(root.getPath()));
        new Object(){

            private void collectFiles(File fromFile, String prefix) {
                File[] list2 = fromFile.listFiles();
                if (list2 == null) {
                    return;
                }
                for (File file2 : list2) {
                    String childRelativePath;
                    String string2 = childRelativePath = prefix.isEmpty() ? file2.getName() : prefix + UrlUtil.URL_PATH_SEPARATOR + file2.getName();
                    if (file2.isDirectory()) {
                        this.collectFiles(file2, childRelativePath);
                        continue;
                    }
                    paths2.add(childRelativePath);
                }
            }
        }.collectFiles(rootFile, "");
        ArrayList<String> arrayList = paths2;
        if (arrayList == null) {
            UrlUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    @NotNull
    static List<String> getChildPathsFromJar(@NotNull URL root) throws IOException {
        Object object;
        HashMapZipFile zipFile;
        block16: {
            block15: {
                String fileUrl;
                if (root == null) {
                    UrlUtil.$$$reportNull$$$0(6);
                }
                if (!"jar".equalsIgnoreCase(root.getProtocol())) {
                    throw new RuntimeException("This function accepts only jar urls: " + root);
                }
                String rootPath = root.getPath();
                int jarSeparatorIndex = rootPath.indexOf("!/");
                if (jarSeparatorIndex <= 0) {
                    throw new RuntimeException("This function accepts only urls with '!/': " + root);
                }
                Object rootDirName = rootPath.substring(jarSeparatorIndex + 2);
                if (!((String)rootDirName).endsWith(URL_PATH_SEPARATOR)) {
                    rootDirName = (String)rootDirName + URL_PATH_SEPARATOR;
                }
                if (!(fileUrl = rootPath.substring(0, jarSeparatorIndex)).startsWith(FILE_PROTOCOL_PREFIX)) {
                    throw new RuntimeException("This function accepts 'jar:file:' urls: " + root);
                }
                File file2 = URLUtil.urlToFile(new URL(fileUrl));
                ArrayList<String> paths2 = new ArrayList<String>();
                zipFile = HashMapZipFile.load((Path)file2.toPath());
                for (ImmutableZipEntry entry : zipFile.getEntries()) {
                    String path2 = entry.getName();
                    if (!path2.startsWith((String)rootDirName)) continue;
                    paths2.add(path2.substring(((String)rootDirName).length()));
                }
                object = paths2;
                if (zipFile == null) break block15;
                zipFile.close();
            }
            if (object != null) break block16;
            UrlUtil.$$$reportNull$$$0(7);
        }
        return object;
        {
            catch (Throwable throwable) {
                try {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/fileTemplates/impl/UrlUtil";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/fileTemplates/impl/UrlUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenRelativePaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPathsFromFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPathsFromJar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenRelativePaths";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChildPathsFromFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChildPathsFromJar";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

