/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.hierarchy;

import com.intellij.ide.ExporterToTextFile;
import com.intellij.ide.hierarchy.HierarchyBrowserBase;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.StructureTreeModel;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

class ExporterToTextFileHierarchy
implements ExporterToTextFile {
    private static final Logger LOG = Logger.getInstance(ExporterToTextFileHierarchy.class);
    private final HierarchyBrowserBase myHierarchyBrowserBase;

    ExporterToTextFileHierarchy(@NotNull HierarchyBrowserBase hierarchyBrowserBase) {
        if (hierarchyBrowserBase == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(0);
        }
        this.myHierarchyBrowserBase = hierarchyBrowserBase;
    }

    @NotNull
    public String getReportText() {
        StringBuilder buf = new StringBuilder();
        StructureTreeModel currentBuilder = this.myHierarchyBrowserBase.getCurrentBuilder();
        LOG.assertTrue(currentBuilder != null);
        this.appendNode(buf, currentBuilder.getRootImmediately(), System.lineSeparator(), "");
        String string2 = buf.toString();
        if (string2 == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(1);
        }
        return string2;
    }

    private void appendNode(StringBuilder buf, @NotNull TreeNode node2, String lineSeparator, String indent) {
        Object childIndent;
        if (node2 == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(2);
        }
        if (node2.getParent() != null) {
            childIndent = indent + "    ";
            HierarchyNodeDescriptor descriptor = HierarchyBrowserBase.getDescriptor((DefaultMutableTreeNode)node2);
            if (descriptor != null) {
                buf.append(indent).append(descriptor.getHighlightedText().getText()).append(lineSeparator);
            }
        } else {
            childIndent = indent;
        }
        Enumeration<? extends TreeNode> enumeration = node2.children();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
            this.appendNode(buf, child, lineSeparator, (String)childIndent);
        }
    }

    @NotNull
    public String getDefaultFilePath() {
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState();
        return state != null && state.EXPORT_FILE_PATH != null ? state.EXPORT_FILE_PATH : "";
    }

    public void exportedTo(@NotNull String filePath) {
        HierarchyBrowserManager.State state;
        if (filePath == null) {
            ExporterToTextFileHierarchy.$$$reportNull$$$0(3);
        }
        if ((state = HierarchyBrowserManager.getInstance(this.myHierarchyBrowserBase.myProject).getState()) != null) {
            state.EXPORT_FILE_PATH = filePath;
        }
    }

    public boolean canExport() {
        return this.myHierarchyBrowserBase.getCurrentBuilder() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyBrowserBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/hierarchy/ExporterToTextFileHierarchy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReportText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "exportedTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

