/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.impl;

import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.ide.highlighter.custom.CustomFileHighlighter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CustomFileTypeFoldingBuilder
extends CustomFoldingBuilder {
    @Override
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        FileType fileType;
        if (descriptors == null) {
            CustomFileTypeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            CustomFileTypeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CustomFileTypeFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (!((fileType = root.getContainingFile().getFileType()) instanceof CustomSyntaxTableFileType)) {
            return;
        }
        CustomFileHighlighter highlighter = new CustomFileHighlighter(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
        CustomFileTypeFoldingBuilder.buildBraceMatcherBasedFolding(descriptors, root, document, (SyntaxHighlighter)highlighter);
    }

    public static void buildBraceMatcherBasedFolding(List<? super FoldingDescriptor> descriptors, PsiElement root, Document document, SyntaxHighlighter highlighter) {
        LexerEditorHighlighter editorHighlighter = new LexerEditorHighlighter(highlighter, EditorColorsManager.getInstance().getGlobalScheme());
        editorHighlighter.setText((CharSequence)document.getText());
        FileType fileType = root.getContainingFile().getFileType();
        BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher(fileType, root.getLanguage());
        TextRange totalRange = root.getTextRange();
        HighlighterIterator iterator = editorHighlighter.createIterator(totalRange.getStartOffset());
        LinkedList<Trinity<Integer, Integer, IElementType>> stack = new LinkedList<Trinity<Integer, Integer, IElementType>>();
        String editorText = document.getText();
        while (!iterator.atEnd() && iterator.getStart() < totalRange.getEndOffset()) {
            if (braceMatcher.isLBraceToken(iterator, editorText, fileType) && braceMatcher.isStructuralBrace(iterator, editorText, fileType)) {
                stack.addLast(Trinity.create(iterator.getStart(), iterator.getEnd(), iterator.getTokenType()));
            } else if (braceMatcher.isRBraceToken(iterator, editorText, fileType) && braceMatcher.isStructuralBrace(iterator, editorText, fileType) && !stack.isEmpty()) {
                Trinity last2 = (Trinity)stack.getLast();
                if (braceMatcher.isPairBraces((IElementType)last2.third, iterator.getTokenType())) {
                    stack.removeLast();
                    TextRange range = new TextRange((Integer)last2.first, iterator.getEnd());
                    if (StringUtil.countChars(document.getText(range), '\n') >= 3) {
                        descriptors.add(new FoldingDescriptor(root, range));
                    }
                }
            }
            iterator.advance();
        }
    }

    @Override
    protected String getLanguagePlaceholderText(@NotNull ASTNode node2, @NotNull TextRange range) {
        if (node2 == null) {
            CustomFileTypeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CustomFileTypeFoldingBuilder.$$$reportNull$$$0(4);
        }
        return "{...}";
    }

    @Override
    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node2) {
        if (node2 == null) {
            CustomFileTypeFoldingBuilder.$$$reportNull$$$0(5);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/highlighter/custom/impl/CustomFileTypeFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

