/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.PlatformUtils;

public class StructureViewSelectInTarget
implements SelectInTarget {
    public static final Key<StructureViewWrapper> CUSTOM_STRUCTURE_VIEW_KEY = Key.create("customStructureView");
    private final Project myProject;

    public StructureViewSelectInTarget(Project project2) {
        this.myProject = project2;
        if (PlatformUtils.isPyCharmEducational()) {
            throw ExtensionNotApplicableException.create();
        }
    }

    public String toString() {
        return IdeBundle.message((String)"select.in.file.structure", (Object[])new Object[0]);
    }

    public boolean canSelect(SelectInContext context2) {
        return context2.getFileEditorProvider() != null && !LightEdit.owns((Project)context2.getProject());
    }

    public void selectIn(SelectInContext context2, boolean requestFocus) {
        FileEditor fileEditor = context2.getFileEditorProvider().openFileEditor();
        StructureViewWrapper customStructureView = CUSTOM_STRUCTURE_VIEW_KEY.get(context2.getVirtualFile());
        if (customStructureView != null) {
            customStructureView.selectCurrentElement(fileEditor, context2.getVirtualFile(), requestFocus);
            return;
        }
        ToolWindowManager windowManager = ToolWindowManager.getInstance((Project)context2.getProject());
        Runnable runnable = () -> StructureViewFactoryEx.getInstanceEx((Project)this.myProject).runWhenInitialized(() -> this.getStructureViewWrapper().selectCurrentElement(fileEditor, context2.getVirtualFile(), requestFocus));
        if (requestFocus) {
            ToolWindow window = windowManager.getToolWindow(this.getToolWindowId());
            if (window != null) {
                window.activate(runnable);
            }
        } else {
            runnable.run();
        }
    }

    private StructureViewWrapper getStructureViewWrapper() {
        return StructureViewFactoryEx.getInstanceEx((Project)this.myProject).getStructureViewWrapper();
    }

    public String getToolWindowId() {
        return "Structure";
    }

    public String getMinorViewId() {
        return null;
    }

    public float getWeight() {
        return 4.0f;
    }
}

